/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.azure;

import io.vavr.control.Option;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class AzureConnectorPropUtil
implements EnvironmentAware {
    private Environment environment;
    public static final String USING_ENVIRONMENT_PROPERTY = "USING_ENVIRONMENT_PROPERTY";
    public static final String secretPropertyPathStatic = "ORG_KANTEGA_ATLASKERB_CONNECTOR_AZURE_AZUREADCONNECTORTYPE_STATIC_CLIENTSECRET";

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public static String getClientSecretPropertyPath() {
        return secretPropertyPathStatic;
    }

    public static String getClientSecretPropertyPath(String applicationId) {
        return String.format("%s_%s_CLIENTSECRET", "ORG_KANTEGA_ATLASKERB_CONNECTOR_AZURE_AZUREADCONNECTORTYPE", applicationId.replace('-', '_'));
    }

    public CONFIGURATION_LOCATION getConfigurationLocation(String applicationId) {
        String secretPerIdp = this.environment.getProperty(AzureConnectorPropUtil.getClientSecretPropertyPath(applicationId));
        String staticSecret = this.environment.getProperty(AzureConnectorPropUtil.getClientSecretPropertyPath());
        if (StringUtils.isBlank((CharSequence)staticSecret)) {
            staticSecret = this.environment.getProperty(AzureConnectorPropUtil.getClientSecretPropertyPath(), System.getenv(AzureConnectorPropUtil.getClientSecretPropertyPath()));
        }
        String finalStaticSecret = staticSecret;
        return (CONFIGURATION_LOCATION)((Object)Option.of((Object)secretPerIdp).filter(StringUtils::isNotBlank).map(s -> CONFIGURATION_LOCATION.PER_CONNECTOR_ENV_PROPERTY).getOrElse(() -> (CONFIGURATION_LOCATION)((Object)((Object)Option.of((Object)finalStaticSecret).filter(StringUtils::isNotBlank).map(s -> CONFIGURATION_LOCATION.STATIC_ENV_PROPERTY).getOrElse((Object)CONFIGURATION_LOCATION.KSSO_FILE)))));
    }

    public String getClientSecret(String applicationId, String applicationSecret) {
        CONFIGURATION_LOCATION location = this.getConfigurationLocation(applicationId);
        switch (location) {
            case PER_CONNECTOR_ENV_PROPERTY: {
                return this.environment.getProperty(AzureConnectorPropUtil.getClientSecretPropertyPath(applicationId));
            }
            case STATIC_ENV_PROPERTY: {
                return this.environment.getProperty(AzureConnectorPropUtil.getClientSecretPropertyPath());
            }
        }
        return applicationSecret;
    }

    public String getClientSecretProcessEnv(String applicationId, String applicationSecret) {
        CONFIGURATION_LOCATION location = this.getConfigurationLocation(applicationId);
        if (location == CONFIGURATION_LOCATION.PER_CONNECTOR_ENV_PROPERTY || location == CONFIGURATION_LOCATION.STATIC_ENV_PROPERTY) {
            return USING_ENVIRONMENT_PROPERTY;
        }
        return null;
    }

    public static enum CONFIGURATION_LOCATION {
        STATIC_ENV_PROPERTY("Static Environment Property"),
        PER_CONNECTOR_ENV_PROPERTY("Per Connector Environment Property"),
        KSSO_FILE("KSSO File");

        private final String description;

        private CONFIGURATION_LOCATION(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

