/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apiserver.admin;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.ksso.scim.ScimVersion;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apiserver.ApiServer;
import org.kantega.atlaskerb.apiserver.ApiServerConfManager;
import org.kantega.atlaskerb.apiserver.ApiServerConfigState;
import org.kantega.atlaskerb.scim.ScimConfManager;

public class ApiServerAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final TemplateRenderer renderer;
    private final ApiServerConfManager apiServerConfManager;
    private final ApiServer apiServer;
    private final ScimConfManager scimConfManager;

    @Inject
    public ApiServerAction(RequireAdminServletDependencyBucket bucket, ApiServerConfManager apiServerConfManager, ApiServer apiServer) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.renderer = bucket.getTemplateRenderer();
        this.apiServerConfManager = apiServerConfManager;
        this.apiServer = apiServer;
        this.scimConfManager = bucket.getScimConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("scimBaseUrlEnabled", this.scimConfManager.isScimBaseUrlEndpointEnabled());
        model.put("scimBaseUrlExample", this.scimConfManager.getBaseUrlEndpoint("<tenantId>", ScimVersion.V2_0));
        ApiServerConfigState apiServerConfig = this.apiServerConfManager.getConfig();
        model.put("apiServerEnabled", apiServerConfig.isEnabled());
        model.put("apiServerAddress", apiServerConfig.getAddress());
        model.put("apiServerPort", apiServerConfig.getPort());
        model.put("displayName", this.applicationProperties.getDisplayName());
        this.renderPage(resp, model);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("disableBaseUrl") != null) {
            this.scimConfManager.setscimBaseUrlEndpointEnabled(false);
            resp.sendRedirect("api-server");
            return;
        }
        if (req.getParameter("enableBaseUrl") != null) {
            this.scimConfManager.setscimBaseUrlEndpointEnabled(true);
            resp.sendRedirect("api-server");
            return;
        }
        boolean enabled = req.getParameter("crowdApiEnabled") != null;
        String crowdApiAddress = req.getParameter("crowdApiAddress");
        String crowdApiPort = req.getParameter("crowdApiPort");
        HashMap<String, Boolean> errors = new HashMap<String, Boolean>();
        if (!this.isValidIPAddress(crowdApiAddress)) {
            errors.put("invalidIp", true);
        }
        if (!this.isValidPort(crowdApiPort)) {
            errors.put("invalidPort", true);
        }
        if (!errors.isEmpty()) {
            Map<String, Object> model = this.newModel(req);
            model.put("apiServerEnabled", enabled);
            model.put("apiServerAddress", crowdApiAddress);
            model.put("apiServerPort", crowdApiPort);
            model.putAll(errors);
            this.renderPage(resp, model);
            return;
        }
        List<Directory> needsUpdate = this.apiServer.findConnectorDirectoriesToUpdate();
        ApiServerConfigState newConfig = this.apiServerConfManager.setApiServerConfig(enabled, crowdApiAddress, Integer.parseInt(crowdApiPort));
        this.apiServer.configChanged(newConfig);
        this.apiServer.updateConnectorDirectories(needsUpdate, this.apiServerConfManager.getCrowdServerUrl());
        resp.sendRedirect("api-server");
    }

    private boolean isValidPort(String crowdApiPort) {
        if (crowdApiPort == null) {
            return false;
        }
        try {
            int port = Integer.parseInt(crowdApiPort);
            return port > 0 && port <= 131072;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isValidIPAddress(String ipAddress) {
        if (ipAddress == null) {
            return false;
        }
        List<Integer> dots = this.dots(ipAddress);
        if (dots.size() != 5) {
            return false;
        }
        for (int i = 0; i < dots.size() - 1; ++i) {
            String comp = ipAddress.substring(dots.get(i) + 1, dots.get(i + 1));
            try {
                int c = Integer.parseInt(comp);
                if (c >= 0 && c <= 255) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private List<Integer> dots(String ipAddress) {
        ArrayList<Integer> dots = new ArrayList<Integer>();
        dots.add(-1);
        for (int i = 0; i < ipAddress.length(); ++i) {
            if (ipAddress.charAt(i) != '.') continue;
            dots.add(i);
        }
        dots.add(ipAddress.length());
        return dots;
    }

    private void renderPage(HttpServletResponse resp, Map<String, Object> model) throws IOException {
        model.put("topMenu", "connectors");
        model.put("menuItem", "apiServer");
        model.put("isServerRunning", this.apiServer.isRunning());
        model.put("currentConfig", this.apiServer.getConfig());
        model.put("startException", this.apiServer.getStartException());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/connector/api-server.vm", model, (Writer)resp.getWriter());
    }
}

