/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.security;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.utils.CrowdUtil;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DarkFeaturesServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final Logger log = LoggerFactory.getLogger(DarkFeaturesServlet.class);

    @Inject
    public DarkFeaturesServlet(RequireAdminServletDependencyBucket bucket, @ComponentImport PluginAccessor pluginAccessor) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.createModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/dark-features.vm", model, (Writer)resp.getWriter());
    }

    @NotNull
    private Map<String, Object> createModel(HttpServletRequest req) {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dark-features");
        model.put("menuItem", "dark-features");
        model.put("ldapFilterEncoding", this.kerbConfManager.isLdapFilterEncoding());
        model.put("kssoConfigVersion", this.kerbConfManager.getSavedKssoConfigVersion().map(Version::stringValue).getOrElse((Object)"<Not set>"));
        model.put("contextPath", req.getContextPath());
        model.put("homeDirectory", this.kerbConfManager.getKerberosHomeDirectoryPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("useLegacyKerberos", this.kerbConfManager.isUseLegacyKerberos());
        model.put("allowLegacyRelativeSafeRedirect", this.kerbConfManager.isAllowLegacyRelativeSafeRedirect());
        model.put("hostappBaseUrlChanged", this.kerbConfManager.getHostappBaseUrlChanged().getOrElse((Object)"<not set>"));
        model.put("savedHostappBaseUrl", this.kerbConfManager.getSavedHostappBaseUrl().getOrElse((Object)"<not set>"));
        CrowdUtil.addCrowdDirectoriesToModel(model, this.hostApp);
        return model;
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        try {
            if (StringUtils.equals((CharSequence)req.getParameter("ldapFilterEncodingChanged"), (CharSequence)"true")) {
                this.kerbConfManager.setLdapFilterEncoding(req.getParameter("ldapFilterEncoding") != null);
            } else if (StringUtils.equals((CharSequence)req.getParameter("kssoConfigVersionInputFieldEdited"), (CharSequence)"true")) {
                if (StringUtils.isNotBlank((CharSequence)req.getParameter("kssoConfigVersion"))) {
                    this.kerbConfManager.setKssoConfigVersion(Version.of((String)req.getParameter("kssoConfigVersion")));
                } else {
                    this.kerbConfManager.darkFeatureRemoveKssoConfigVersion();
                }
            } else if (StringUtils.equals((CharSequence)req.getParameter("kssoUpgradeFailuresRemovedClicked"), (CharSequence)"true")) {
                this.log.debug("Removing upgrade failures");
                this.kerbConfManager.removeUpdateFailures();
            } else if (StringUtils.equals((CharSequence)req.getParameter("useLegacyKerberosChanged"), (CharSequence)"true")) {
                this.log.debug("Setting useLegacyKerberos to {}", (Object)(req.getParameter("useLegacyKerberos") != null ? 1 : 0));
                this.kerbConfManager.setUseLegacyKerberos(req.getParameter("useLegacyKerberos") != null);
            } else if (StringUtils.equals((CharSequence)req.getParameter("allowLegacyRelativeSafeRedirectChanged"), (CharSequence)"true")) {
                this.log.debug("Setting allowLegacyRelativeSafeRedirect to ", (Object)req.getParameter("allowLegacyRelativeSafeRedirect"));
                this.kerbConfManager.setAllowLegacyRelativeSafeRedirect("on".equals(req.getParameter("allowLegacyRelativeSafeRedirect")));
            }
            this.saveCrowdDirectorySettings(req);
            HttpUrlUtils.sendSaveSuccess((HttpServletResponse)resp);
        }
        catch (Exception e) {
            HttpUrlUtils.sendSaveError((HttpServletResponse)resp, (Exception)e);
            this.log.error("Problem saving settings", (Throwable)e);
        }
    }

    private void saveCrowdDirectorySettings(HttpServletRequest req) {
        Map<String, Object> model = this.createModel(req);
        List crowdDirectories = (List)model.get("crowdDirectories");
        for (Directory directory : crowdDirectories) {
            ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
            HashMap<String, String> attrs = new HashMap<String, String>(directory.getAttributes());
            attrs.put("crowdType", "on".equals(req.getParameter("crowdDirectoryToggle" + directory.getId())) ? CrowdUtil.CrowdType.ATLASSIAN_CROWD.toString() : CrowdUtil.CrowdType.JIRA_CROWD.toString());
            builder.setAttributes(attrs);
            this.hostApp.getCrowdDirectoryService().updateDirectory(builder.toDirectory());
        }
    }
}

