/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.idp;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import kantega.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.rest.resource.api.idp.model.AddManagedGroupDto;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="managedgroups")
public class IdpManagedGroupsResource {
    private final Logger log = LoggerFactory.getLogger(IdpManagedGroupsResource.class);
    private final IdpConfManager idpConfManager;
    private final UserManager userManager;
    private final JsonWrapper jsonWrapper;

    @Inject
    public IdpManagedGroupsResource(@ComponentImport UserManager userManager, IdpConfManager idpConfManager, JsonWrapper jsonWrapper) {
        this.idpConfManager = idpConfManager;
        this.userManager = userManager;
        this.jsonWrapper = jsonWrapper;
    }

    @GET
    @Path(value="/{idpId}/groups")
    @Produces(value={"application/json"})
    public Response getAllGroupsForIdp(@Context HttpServletRequest request, @PathParam(value="idpId") String idpId) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            IdpConfiguration previousConf = this.idpConfManager.getIdentityProviderById(idpId);
            if (previousConf == null) {
                SanitizedLogStatement.of(idpId).andThenLog(id -> this.log.debug("getAllGroupsForIdp -> Could not find IDP configuration for id {}", id));
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            List groupNames = previousConf.getManagedGroups().stream().map(ManagedGroup::getName).collect(Collectors.toList());
            SanitizedLogStatement.of(idpId).andThenLog(id -> this.log.debug("Found {} managed groups for IDP {}", (Object)groupNames.size(), (Object)idpId));
            try {
                return Response.ok((Object)this.jsonWrapper.buildJsonString(groupNames)).build();
            }
            catch (JsonProcessingException e) {
                this.log.error("KSSO: something went wrong processing json object ", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        });
    }

    @GET
    @Path(value="/{idpId}/groups/{managedGroupName}")
    public Response getSpecificGroup(@Context HttpServletRequest request, @PathParam(value="idpId") String idpId, @PathParam(value="managedGroupName") String managedGroupName) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            IdpConfiguration previousConf = this.idpConfManager.getIdentityProviderById(idpId);
            if (previousConf == null) {
                SanitizedLogStatement.of(idpId).andThenLog(id -> this.log.debug("getSpecificGroup -> Could not find IDP configuration for id {}", id));
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Optional<String> first = previousConf.getManagedGroups().stream().map(ManagedGroup::getName).filter(s -> StringUtils.equals((CharSequence)s, (CharSequence)managedGroupName)).findFirst();
            if (first.isPresent()) {
                SanitizedLogStatement.of(String.format("getSpecificGroup -> Found managed group %s for IDP %s ", managedGroupName, idpId)).andThenLog(arg_0 -> ((Logger)this.log).debug(arg_0));
                return Response.noContent().build();
            }
            SanitizedLogStatement.of(String.format("getSpecificGroup -> Could not find managed group %s for IDP %s ", managedGroupName, idpId)).andThenLog(arg_0 -> ((Logger)this.log).debug(arg_0));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addGroup(@Context HttpServletRequest request, AddManagedGroupDto bean) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            String idpId = bean.getIdpId();
            String addManagedGroup = bean.getAddManagedGroup();
            IdpConfiguration previousConf = this.idpConfManager.getIdentityProviderById(idpId);
            if (previousConf == null) {
                SanitizedLogStatement.of(idpId).andThenLog(id -> this.log.debug("addGroup -> Could not find IDP configuration for id {}", id));
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(previousConf);
            ManagedGroup managedGroup = new ManagedGroup(addManagedGroup);
            builder.getManagedGroups().add(managedGroup);
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
            SanitizedLogStatement.of(idpId).andThenLog(id -> this.log.debug("addGroup -> Added managed group {} for IDP {}", (Object)addManagedGroup, id));
            return Response.noContent().build();
        });
    }

    @PUT
    @Path(value="/{idpId}/groups/{groupToReplace}")
    @Consumes(value={"application/json"})
    public Response replaceGroup(@Context HttpServletRequest request, AddManagedGroupDto bean, @PathParam(value="idpId") String idpId, @PathParam(value="groupToReplace") String removeManagedGroup) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            String addManagedGroup = bean.getAddManagedGroup();
            IdpConfiguration previousConf = this.idpConfManager.getIdentityProviderById(idpId);
            if (previousConf == null) {
                SanitizedLogStatement.of(idpId).andThenLog(id -> this.log.debug("replaceGroup -> Could not find IDP configuration for id {}", id));
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (addManagedGroup == null) {
                this.log.debug("replaceGroup -> Managed group to add is null");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (removeManagedGroup == null) {
                this.log.debug("replaceGroup -> Managed group to remove is null");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            IdpConfigurationBuilder<?, ?> builderForReplaceGroup = IdpConfigurationBuilder.ofGeneric(previousConf);
            ManagedGroup managedGroup = new ManagedGroup(addManagedGroup);
            ManagedGroup managedGroupToRemove = new ManagedGroup(removeManagedGroup);
            builderForReplaceGroup.getManagedGroups().remove(managedGroupToRemove);
            builderForReplaceGroup.getManagedGroups().add(managedGroup);
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builderForReplaceGroup.build());
            SanitizedLogStatement.of(String.format("replaceGroup -> Replaced managed group %s with %s for IDP %s", removeManagedGroup, addManagedGroup, idpId)).andThenLog(arg_0 -> ((Logger)this.log).debug(arg_0));
            return Response.noContent().build();
        });
    }

    @DELETE
    @Path(value="/{idpId}/groups/{managedGroupName}")
    public Response removeGroup(@Context HttpServletRequest request, @PathParam(value="idpId") String idpId, @PathParam(value="managedGroupName") String removeManagedGroup) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            IdpConfiguration previousConf = this.idpConfManager.getIdentityProviderById(idpId);
            if (previousConf == null) {
                SanitizedLogStatement.of(idpId).andThenLog(id -> this.log.debug("removeGroup -> Could not find IDP configuration for id {}", id));
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(previousConf);
            ManagedGroup managedGroup = new ManagedGroup(removeManagedGroup);
            boolean removed = builder.getManagedGroups().remove(managedGroup);
            if (!removed) {
                SanitizedLogStatement.of(String.format("removeGroup -> Could not find managed group %s for IDP %s", removeManagedGroup, idpId)).andThenLog(arg_0 -> ((Logger)this.log).debug(arg_0));
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
            SanitizedLogStatement.of(String.format("removeGroup -> Removed managed group %s for IDP %s", removeManagedGroup, idpId)).andThenLog(arg_0 -> ((Logger)this.log).debug(arg_0));
            return Response.noContent().build();
        });
    }
}

