/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.azure.AzureAdConnectorType;
import org.kantega.atlaskerb.connector.azure.AzureConnectorPropUtil;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.connector.model.ObjectTypeFilter;
import org.kantega.atlaskerb.connector.model.UsernameSelectionAttribute;
import org.kantega.atlaskerb.connector.model.filters.GroupFilter;
import org.kantega.atlaskerb.connector.model.filters.UserMembershipFilter;
import org.kantega.atlaskerb.connector.model.filters.UserTypeSelectionFilter;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.kerberos.servlet.TestKerberosAction;
import org.kantega.atlaskerb.userlookup.UserLookupTransform;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EditConnectorAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;
    private AzureConnectorPropUtil azureConnectorPropUtil;

    @Inject
    public EditConnectorAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostApp();
    }

    @Autowired
    void setAzureConnectorPropUtil(AzureConnectorPropUtil azureConnectorPropUtil) {
        this.azureConnectorPropUtil = azureConnectorPropUtil;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ConnectorType connectorType;
        Map<String, Object> model = this.newModel(req);
        TestKerberosAction.checkSupportedBrowser(model, req.getHeader("User-Agent"));
        Directory directory = null;
        String kind = req.getParameter("kind");
        if (kind != null) {
            connectorType = this.connectorConfManager.getConnectorTypes().get(kind);
        } else {
            String id = req.getParameter("id");
            if (id != null) {
                directory = this.connectorConfManager.getDirectory(id);
                connectorType = this.connectorConfManager.getConnectorTypes().get(directory.getKind());
                String clientSecretConfigurationLocation = this.azureConnectorPropUtil.getConfigurationLocation(id).toString();
                model.put("clientSecretConfigLocation", clientSecretConfigurationLocation);
                model.put("clientSecretEnvName", AzureConnectorPropUtil.getClientSecretPropertyPath(id));
                model.put("clientSecretEnvNameStatic", AzureConnectorPropUtil.getClientSecretPropertyPath());
                model.put("connectorType", connectorType);
                model.put("platformSupportsAvatars", this.hostApp.supportsAvatars(this.applicationProperties));
                model.put("connectorId", directory.getId());
                model.put("currentConnector", directory);
            } else {
                throw new IllegalArgumentException("Missing id or kind parameter");
            }
        }
        connectorType.editDirectory(req, directory, model);
        this.renderPage(connectorType, resp, model);
    }

    private void renderPage(ConnectorType connectorType, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        model.put("kind", connectorType.getKey());
        this.renderTemplate(resp, model, "templates/atlaskerb/connector/" + connectorType.getEditDirectoryTemplate());
    }

    private void renderTemplate(HttpServletResponse resp, Map<String, Object> model, String template) throws IOException {
        model.put("topMenu", "connectors");
        model.put("menuItem", "editConnector");
        model.put("displayName", this.applicationProperties.getDisplayName());
        resp.setContentType("text/html");
        this.renderer.render(template, model, (Writer)resp.getWriter());
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Directory dir;
        UsernameSelectionAttribute usernameSelectionAttribute;
        ObjectTypeFilter objectTypeFilter;
        UserLookupTransform usernameTransformation;
        UserTypeSelectionFilter userTypeFilter;
        GroupFilter groupFilter;
        UserMembershipFilter userMembershipFilter;
        Set<String> remoteAddresses;
        String password;
        String kind;
        String id;
        MultipartHttpRequest mreq;
        Map<String, Object> model = this.newModel(req);
        long maxSize = 10000000L;
        try {
            mreq = this.hostApp.getMultipartRequest(req, maxSize);
        }
        catch (IOException e) {
            model.put("uploadException", e);
            model.put("maxSize", maxSize / 1000L);
            this.renderTemplate(resp, model, "templates/atlaskerb/connector/upload-error.vm");
            return;
        }
        ConnectorType connectorType = this.connectorConfManager.getConnectorTypes().get(mreq.getParameter("kind"));
        String connectorId = mreq.getParameter("connectorId");
        Directory existingConnector = null;
        if (StringUtils.isNotBlank((CharSequence)connectorId)) {
            existingConnector = this.connectorConfManager.getDirectory(connectorId);
            model.put("connectorId", existingConnector.getId());
            model.put("currentConnector", existingConnector);
        }
        if (existingConnector != null) {
            id = existingConnector.getId();
            kind = existingConnector.getKind();
            password = existingConnector.getPassword();
            remoteAddresses = existingConnector.getRemoteAddresses();
            userMembershipFilter = existingConnector.getUserMembershipFilter();
            groupFilter = existingConnector.getGroupFilter();
            userTypeFilter = existingConnector.getUserTypeSelectionFilter();
            usernameTransformation = existingConnector.getUsernameTransformation();
            objectTypeFilter = existingConnector.getObjectTypeFilter();
            usernameSelectionAttribute = existingConnector.getUsernameSelectionAttribute();
        } else {
            id = this.connectorConfManager.nextId();
            kind = connectorType.getKey();
            password = connectorType.getKey();
            remoteAddresses = Collections.singleton("127.0.0.1");
            userMembershipFilter = UserMembershipFilter.ALL;
            groupFilter = GroupFilter.ALL;
            userTypeFilter = new UserTypeSelectionFilter(UserTypeSelectionFilter.SelectionMode.MEMBERS_ONLY);
            usernameTransformation = UserLookupTransform.NONE;
            objectTypeFilter = ObjectTypeFilter.USERS_GROUPS_MEMBERSHIPS;
            usernameSelectionAttribute = UsernameSelectionAttribute.USER_PRINCIPAL_NAME;
        }
        ArrayList<Pair<String, String>> userTransformationRegexes = new ArrayList<Pair<String, String>>();
        Directory.Common common = new Directory.Common(id, kind, password, remoteAddresses, userMembershipFilter, groupFilter, userTypeFilter, objectTypeFilter, usernameTransformation, userTransformationRegexes, usernameSelectionAttribute);
        if (connectorType instanceof AzureAdConnectorType) {
            ((AzureAdConnectorType)connectorType).setAzureConnectorPropUtil(this.azureConnectorPropUtil);
        }
        if ((dir = connectorType.processEditDirectoryPost(mreq, model, existingConnector, common)) != null) {
            this.connectorConfManager.saveOrEdit(dir);
            resp.sendRedirect("connector/" + dir.getId());
        } else {
            this.renderPage(connectorType, resp, model);
        }
    }
}

