/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import kantega.shaded.org.opensaml.core.xml.XMLObject;
import kantega.shaded.org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import kantega.shaded.org.opensaml.core.xml.io.UnmarshallingException;
import kantega.shaded.org.opensaml.core.xml.util.XMLObjectSupport;
import kantega.shaded.org.opensaml.saml.saml2.core.AuthnRequest;
import kantega.shaded.org.opensaml.saml.saml2.core.Response;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSSerializer;

public class XmlUtils {
    public static String formatXml(Element dom) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HashMap<String, Boolean> serializerParams = new HashMap<String, Boolean>();
        boolean canSetPrettyPrint = true;
        LSSerializer serializer = SerializeSupport.getDOMImplementationLS((Node)dom).createLSSerializer();
        if (serializer instanceof DOMConfiguration) {
            DOMConfiguration conf = (DOMConfiguration)((Object)serializer);
            canSetPrettyPrint = conf.canSetParameter("format-pretty-print", true);
        }
        if (canSetPrettyPrint) {
            serializerParams.put("format-pretty-print", true);
        }
        serializerParams.put("xml-declaration", false);
        SerializeSupport.writeNode((Node)dom, (OutputStream)os, serializerParams);
        return new String(os.toByteArray(), StandardCharsets.UTF_8);
    }

    public static String serializeXml(Element dom) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        SerializeSupport.writeNode((Node)dom, (OutputStream)os);
        return new String(os.toByteArray(), StandardCharsets.UTF_8);
    }

    public static Response parseResponseFile(File responseFile) {
        return (Response)XmlUtils.parse(responseFile);
    }

    public static AuthnRequest parseRequestFile(File requestFile) {
        return (AuthnRequest)XmlUtils.parse(requestFile);
    }

    public static XMLObject parse(File responseFile) {
        XMLObject xMLObject;
        block8: {
            InputStream is = Files.newInputStream(responseFile.toPath(), new OpenOption[0]);
            try {
                ParserPool parserPool = XMLObjectProviderRegistrySupport.getParserPool();
                xMLObject = XMLObjectSupport.unmarshallFromInputStream((ParserPool)parserPool, (InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UnmarshallingException | XMLParserException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return xMLObject;
    }
}

