/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.json.JSONArray;
import org.kantega.atlaskerb.userlookup.regextransformation.RegexTransformationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMappingUtils {
    private static final Logger log = LoggerFactory.getLogger(UserMappingUtils.class);
    private static final String lowerStart = "_lower_case_start_";
    private static final String lowerEnd = "_lower_case_end_";
    private static final String patternLower = "\\\\L";
    private static final String upperStart = "_upper_case_start_";
    private static final String upperEnd = "_upper_case_end_";
    private static final String patternUpper = "\\\\U";

    public static RegexTransformationResult regexTransformPairToResult(String textInput, String regexPattern, String regexReplacement) {
        String transformedUsername = null;
        String regexErrorMessage = null;
        if (StringUtils.isBlank((CharSequence)regexPattern) && StringUtils.isBlank((CharSequence)regexReplacement)) {
            transformedUsername = "";
            regexErrorMessage = "";
        } else if (StringUtils.isBlank((CharSequence)regexPattern) || StringUtils.isBlank((CharSequence)regexReplacement)) {
            regexErrorMessage = "Both fields must have a value";
        } else {
            try {
                transformedUsername = UserMappingUtils.interpretRegexAndReplace(textInput, regexPattern, regexReplacement);
            }
            catch (Exception e) {
                regexErrorMessage = e.getMessage();
            }
        }
        return new RegexTransformationResult(textInput, transformedUsername, regexErrorMessage, regexPattern, regexReplacement);
    }

    private static Either<String, Boolean> validateRegex(String regexPattern, String regexReplacement) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regexPattern);
        }
        catch (PatternSyntaxException pse) {
            return Either.left((Object)("Invalid expression: " + pse.getDescription()));
        }
        String transformedReplacement = UserMappingUtils.transformReplacementCasingRules(regexReplacement);
        String textReplaced = pattern.matcher("").replaceFirst(transformedReplacement);
        try {
            UserMappingUtils.changeCasing(textReplaced, new StringBuilder());
        }
        catch (Exception e) {
            return Either.left((Object)("Unable to change casing for username: " + textReplaced));
        }
        return Either.right((Object)true);
    }

    public static io.vavr.collection.List<Either<String, Boolean>> validateRegexTransformations(io.vavr.collection.List<Tuple2<String, String>> regexTuples) {
        return regexTuples.map(tuple -> UserMappingUtils.validateRegex((String)tuple._1, (String)tuple._2));
    }

    public static List<RegexTransformationResult> regexTransformations(String userPrincipalName, List<Pair<String, String>> regexTuples) {
        return regexTuples.stream().map(pair -> UserMappingUtils.regexTransformPairToResult(userPrincipalName, (String)pair.getLeft(), (String)pair.getRight())).collect(Collectors.toList());
    }

    public static Optional<String> transformUsername(String username, List<Pair<String, String>> regexTuples) {
        return UserMappingUtils.transformUsernameWithIndex(username, (io.vavr.collection.List<Tuple2<String, String>>)io.vavr.collection.List.ofAll(regexTuples).map(pair -> Tuple.of((Object)((String)pair.getLeft()), (Object)((String)pair.getRight())))).map(tuple -> (String)tuple.apply((index, result) -> result)).toJavaOptional();
    }

    public static Option<Tuple2<Integer, String>> transformUsernameWithIndex(String username, io.vavr.collection.List<Tuple2<String, String>> regexTuples) {
        int index = 0;
        for (Tuple2 regexTuple : regexTuples) {
            String result = UserMappingUtils.regexTransformPairToResult(username, (String)regexTuple._1, (String)regexTuple._2).getResult();
            if (StringUtils.isNotBlank((CharSequence)result)) {
                return Option.of((Object)Tuple.of((Object)index, (Object)result));
            }
            ++index;
        }
        return Option.none();
    }

    private static String interpretRegexAndReplace(String text, String regexPattern, String regexReplacement) {
        String transformedReplacement = UserMappingUtils.transformReplacementCasingRules(regexReplacement);
        Matcher m = Pattern.compile(regexPattern).matcher(text);
        if (!m.matches()) {
            return null;
        }
        String textReplaced = m.replaceFirst(transformedReplacement);
        StringBuilder newText = new StringBuilder();
        try {
            newText = UserMappingUtils.changeCasing(textReplaced, newText);
        }
        catch (Exception e) {
            log.warn("Unable to change casing for username: " + textReplaced);
            return textReplaced;
        }
        return newText.toString();
    }

    private static String transformReplacementCasingRules(String regexReplacement) {
        String transformedLower = regexReplacement.replaceAll("\\\\L(\\$[\\d])+", "_lower_case_start_$1_lower_case_end_");
        return transformedLower.replaceAll("\\\\U(\\$[\\d])+", "_upper_case_start_$1_upper_case_end_");
    }

    private static @NonNull StringBuilder changeCasing(String textReplaced, StringBuilder newText) {
        int i;
        String[] parts2;
        String[] splitted;
        for (String part : splitted = textReplaced.split(lowerStart)) {
            if (part.contains(lowerEnd)) {
                parts2 = part.split(lowerEnd);
                for (i = 0; i < parts2.length; ++i) {
                    if (i == 0) {
                        newText.append(parts2[i].toLowerCase());
                        continue;
                    }
                    newText.append(parts2[i]);
                }
                continue;
            }
            newText.append(part);
        }
        splitted = newText.toString().split(upperStart);
        newText = new StringBuilder();
        for (String part : splitted) {
            if (part.contains(upperEnd)) {
                parts2 = part.split(upperEnd);
                for (i = 0; i < parts2.length; ++i) {
                    if (i == 0) {
                        newText.append(parts2[i].toUpperCase());
                        continue;
                    }
                    newText.append(parts2[i]);
                }
                continue;
            }
            newText.append(part);
        }
        return newText;
    }

    public static String extractStringFromBrackets(String multiRegexString) {
        if (StringUtils.isBlank((CharSequence)multiRegexString)) {
            return "";
        }
        Pattern pattern = Pattern.compile("^\\[(.*)\\]$");
        Matcher matcher = pattern.matcher(multiRegexString);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return "";
    }

    public static List<Pair<String, String>> parseMultiRegex(String multiRegexString) {
        ArrayList<Pair<String, String>> regexTuples = new ArrayList<Pair<String, String>>();
        String extractedString = UserMappingUtils.extractStringFromBrackets(multiRegexString);
        if (!StringUtils.isBlank((CharSequence)extractedString)) {
            Pattern pattern = Pattern.compile("\\(([^,]+),([^\\)]+)\\)");
            Matcher matcher = pattern.matcher(extractedString);
            while (matcher.find()) {
                String regex = matcher.group(1).trim();
                String replacement = matcher.group(2).trim();
                regexTuples.add((Pair<String, String>)Pair.of((Object)regex, (Object)replacement));
            }
        }
        return regexTuples;
    }

    public static JSONArray getRegexTransformations(List<Pair<String, String>> regexTuples) {
        JSONArray regexTransformations = new JSONArray();
        List<RegexTransformationResult> validations = UserMappingUtils.regexTransformations("john.doe@example.com", regexTuples);
        validations.forEach(result -> regexTransformations.put((Object)result.toJson()));
        return regexTransformations;
    }
}

