/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SafeRedirect {
    private static final Logger log = LoggerFactory.getLogger(SafeRedirect.class);
    private static final String SEND_REDIRECT_ONGOING = "com.atlassian.web.servlet.plugin.request.RedirectInterceptingResponse.sendRedirect";
    private final ApplicationProperties applicationProperties;

    @Inject
    public SafeRedirect(@ComponentImport ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public void sendRedirect(String targetUrl, HttpServletRequest req, HttpServletResponse res, HostApp hostApp) throws IOException {
        String rootpageRedirectFallback = req.getContextPath() + "/";
        req.setAttribute(SEND_REDIRECT_ONGOING, (Object)Boolean.TRUE);
        if (this.isLocal((String)targetUrl)) {
            log.debug("Local redirect to '{}'", targetUrl);
            try {
                new URI((String)targetUrl);
                if (hostApp.isMainLoginPage(req)) {
                    if (hostApp.getRedirectTarget(req) != null) {
                        targetUrl = hostApp.getRedirectTarget(req);
                    } else if (hostApp.sendToDashboardAfterLogin()) {
                        targetUrl = rootpageRedirectFallback;
                    }
                }
                res.sendRedirect((String)targetUrl);
            }
            catch (URISyntaxException e) {
                log.debug("URISyntaxException for '{}'; will send to rootpage. Msg: {}", targetUrl, (Object)e.getMessage());
                res.sendRedirect(rootpageRedirectFallback);
            }
        } else {
            String configuredBaseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
            boolean targetServernameEqualsConfigured = HttpUrlUtils.servernameEquals((String)targetUrl, (String)configuredBaseUrl);
            if (!targetServernameEqualsConfigured) {
                log.warn("AbsoluteUrl {} is not the base URL {} for this instance, using fallback redirect to /", targetUrl, (Object)configuredBaseUrl);
            }
            Object redirectUrl = targetServernameEqualsConfigured ? targetUrl : rootpageRedirectFallback;
            log.debug("Non local redirect to '{}' (is sent to root page: {})", redirectUrl, (Object)(!targetServernameEqualsConfigured ? 1 : 0));
            res.sendRedirect((String)redirectUrl);
        }
    }

    public boolean isLocal(String uri) {
        return !StringUtils.contains((CharSequence)uri, (CharSequence)"://");
    }
}

