/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.apitokens.v1.user;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.rest.resource.api.apitokens.v1.user.CreateTokenV1;
import org.kantega.atlaskerb.rest.resource.api.apitokens.v1.user.DeleteTokenV1;
import org.kantega.atlaskerb.rest.resource.api.apitokens.v1.user.GetExpiryStatusV1;
import org.kantega.atlaskerb.rest.resource.api.apitokens.v1.user.GetTokensForUserV1;
import org.kantega.atlaskerb.rest.resource.api.apitokens.v1.user.RefreshTokenV1;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="user")
@UnrestrictedAccess
@PublicApi
public class ApiTokensUserResourceV1 {
    private final Logger log = LoggerFactory.getLogger(ApiTokensUserResourceV1.class);
    private final UserManager userManager;
    private final ApiTokenService apiTokenService;

    @Inject
    public ApiTokensUserResourceV1(@ComponentImport UserManager userManager, ApiTokenService apiTokenService) {
        this.userManager = userManager;
        this.apiTokenService = apiTokenService;
    }

    @Path(value="/tokens")
    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request) {
        return ResponseUtils.user(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userKey -> GetTokensForUserV1.run(userKey, this.apiTokenService));
    }

    @Path(value="/tokens")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, String body) {
        return ResponseUtils.user(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> {
            Try maybeJson = Option.of((Object)body).filter(StringUtils::isNotBlank).toTry().flatMap(JsonMapping.Write::stringAsJson).onFailure(throwable -> this.log.error("Unable to build JSON from request: ", throwable));
            if (maybeJson.isFailure()) {
                return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Invalid JSON: " + maybeJson.getCause().getMessage());
            }
            return (Response)maybeJson.mapTry((CheckedFunction1 & Serializable)json -> CreateTokenV1.run(json, userProfile, this.apiTokenService)).onFailure(throwable -> this.log.error("Failed to create API token: ", throwable)).getOrElse((Object)ResponseUtils.errorWithMessageInJson(Response.Status.INTERNAL_SERVER_ERROR, "Encountered an error while creating API token."));
        });
    }

    @Path(value="/refresh")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response refresh(@Context HttpServletRequest request, String body) {
        return ResponseUtils.user(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userKey -> (Response)Try.of((CheckedFunction0 & Serializable)() -> RefreshTokenV1.run(request, body, userKey, this.apiTokenService, this.userManager)).onFailure(e -> this.log.error("Experienced a failure during refresh of API token: ", e)).getOrElse((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build()));
    }

    @Path(value="/expiry/status")
    @GET
    @Produces(value={"application/json"})
    public Response status(@Context HttpServletRequest request, @QueryParam(value="id") String id) {
        return ResponseUtils.user(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> {
            Option maybeSecret = HttpUrlUtils.extractApiTokenFromBasicAuthHeader((HttpServletRequest)request);
            if (maybeSecret.isDefined() || id != null) {
                return GetExpiryStatusV1.run(request, id, userProfile, this.apiTokenService, this.userManager);
            }
            String message = "API Token was not present in Basic Auth header to check expiry status.";
            this.log.debug("API Token was not present in Basic Auth header to check expiry status.");
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "API Token was not present in Basic Auth header to check expiry status.");
        }).onFailure(t -> this.log.error("Encountered an error while checking token expiry status:  ", t)).getOrElse(() -> Response.serverError().build()));
    }

    @Path(value="/delete/{id}")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response delete(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        return ResponseUtils.user(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> {
            if (id != null) {
                return DeleteTokenV1.run(id, userProfile, this.apiTokenService, this.userManager);
            }
            String errorMessage = "Cannot delete API Token without id.";
            this.log.debug("Cannot delete API Token without id.");
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Cannot delete API Token without id.");
        }).onFailure(e -> this.log.error("Encountered an exception while deleting API token. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

