/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.sal.api.web.context.HttpContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.hostapp.JiraHostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.TraditionalLoginUtils;

public class SSOLoginHookContextProvider
implements ContextProvider {
    private final HostApp hostApp;
    private final HttpContext httpContext;
    private final IdpConfManager idpConfigManager;
    private final KerbConfManager kerbConfManager;
    private final UserLookupService userLookupService;

    @Inject
    public SSOLoginHookContextProvider(@ComponentImport HttpContext httpContext, HostAppFactory hostAppFactory, IdpConfManager idpConfigManager, KerbConfManager kerbConfManager, RequireAdminServletDependencyBucket bucket) {
        this.hostApp = hostAppFactory.getInstance();
        this.idpConfigManager = idpConfigManager;
        this.httpContext = httpContext;
        this.kerbConfManager = kerbConfManager;
        this.userLookupService = bucket.getUserLookupService();
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public static Map<String, Object> getContextMap(KerbConfManager kerbConfManager, IdpConfManager idpConfigManager, HostApp hostApp, HttpContext httpContext, UserLookupService userLookupService, boolean isJsm) {
        Map<String, Object> model = new HashMap<String, Object>();
        HttpServletRequest request = null;
        HttpServletResponse response = null;
        if (httpContext != null) {
            request = httpContext.getRequest();
            response = httpContext.getResponse();
        }
        model.put("shouldLoginManually", hostApp.shouldLoginManually(request, response));
        model.put("shouldDisableRedirect", hostApp.shouldDisableRedirect(request));
        model.put("samlLoginUsernamePlaceholder", kerbConfManager.getSamlLoginUsernamePlaceholder());
        model.put("nextButtonText", kerbConfManager.getNextButtonText());
        model.put("usernameFieldText", kerbConfManager.getUsernameFieldText());
        model.put("idpListTitleText", kerbConfManager.getIdpListTitleText());
        model.put("forgotPasswordUrl", hostApp.getForgotPasswordUrl());
        model.put("shouldDoSsoAfterLogout", idpConfigManager.isAnyProviderForcingReLoginAfterLogout());
        model.put("loginPageUrl", hostApp.getLoginPage());
        model.put("shouldUseLegacyLoginExperience", hostApp.shouldUseLegacyLoginExperience());
        model.put("redirectProgressDelay", idpConfigManager.getRedirectProgressDelay() + "s");
        model.put("showCustomTextBoxOnLoginPage", kerbConfManager.isCustomTextBoxOnLoginPageEnabled());
        model.put("customTextOnLoginPageWithHtml", kerbConfManager.getCustomTextBoxOnLoginPageContent());
        boolean isAllTraditionalLoginPrevented = TraditionalLoginUtils.shouldTraditionalLoginBePreventedForThisPage(kerbConfManager, userLookupService, hostApp, request);
        boolean isAtLeastOneManualRedirect = idpConfigManager.isAtLeastOneManualRedirect();
        boolean shouldShowLoginWithUsernamePassword = !isAllTraditionalLoginPrevented && idpConfigManager.isUsernamePasswordLinkEnabled();
        model.put("visibleIdentityProviders", idpConfigManager.getIdentityProvidersSortedByLoginDisplayPosition().stream().filter(IdpConfiguration::isEnabled).filter(idp -> idp.getRedirectProperties().isVisible()).collect(Collectors.toList()));
        model.put("isUseIcon", idpConfigManager.isUseIcon());
        boolean isTraditionalLoginPreventedForSomeUsers = kerbConfManager.isTraditionalLoginPrevented() || kerbConfManager.isTraditionalLoginJsmPrevented();
        model.put("isTraditionalLoginPrevented", isTraditionalLoginPreventedForSomeUsers);
        if (isTraditionalLoginPreventedForSomeUsers) {
            model.put("isAllTraditionalLoginPrevented", isAllTraditionalLoginPrevented);
            model.put("traditionalLoginPreventedMessageWithHtml", kerbConfManager.getTraditionalLoginDisabledMessage());
            model.put("allTraditionalLoginPreventedMessageWithHtml", kerbConfManager.getAllTraditionalLoginDisabledMessage());
        }
        if (!hostApp.shouldUseLegacyLoginExperience()) {
            model.put("pluginAdminPath", "/plugins/servlet/" + PluginKey.getPluginKeyBasepart());
            model.put("pluginKey", PluginKey.getPluginKeyBasepart());
            model.put("isAtLeastOneManualRedirect", isAtLeastOneManualRedirect);
            model.put("idpIdHostedDomainMap", SSOLoginHookContextProvider.getIdpIdHostedDomainMap(idpConfigManager));
            model.put("shouldShowLoginWithUsernamePassword", shouldShowLoginWithUsernamePassword);
            model.put("loginHintMap", SSOLoginHookContextProvider.getLoginHintMapForIdentityProviders(idpConfigManager));
            model = kerbConfManager.populateModelWithCustomLoginTexts(model);
        }
        String destinationAfterRedirect = HttpUrlUtils.turnConsecutiveSlashesIntoSingleSlash((String)HttpUrlUtils.softUrlDecode((String)SSOLoginHookContextProvider.getTargetAfterRedirect(httpContext, hostApp, isJsm)));
        model.put("destinationAfterRedirect", destinationAfterRedirect);
        return model;
    }

    public Map<String, Object> getContextMap(Map<String, Object> map) {
        return SSOLoginHookContextProvider.getContextMap(this.kerbConfManager, this.idpConfigManager, this.hostApp, this.httpContext, this.userLookupService, false);
    }

    private static Map<String, String> getIdpIdHostedDomainMap(IdpConfManager idpConfigManager) {
        HashMap<String, String> idpIdHostedDomainMap = new HashMap<String, String>();
        for (IdpConfiguration idp : idpConfigManager.getIdentityProviders()) {
            if (idp.getRedirectProperties().getRedirectPolicy().equals((Object)IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN) && !idp.getKnownDomains().isEmpty()) {
                idpIdHostedDomainMap.put(idp.getId(), idp.getKnownDomains().stream().findFirst().orElse(""));
                continue;
            }
            idpIdHostedDomainMap.put(idp.getId(), "");
        }
        return idpIdHostedDomainMap;
    }

    private static Map<String, String> getLoginHintMapForIdentityProviders(IdpConfManager idpConfigManager) {
        HashMap<String, String> loginHintMap = new HashMap<String, String>();
        for (IdpConfiguration idp : idpConfigManager.getIdentityProviders()) {
            if (idp.getRedirectProperties().isSendLoginHint()) {
                loginHintMap.put(idp.getId(), "true");
                continue;
            }
            loginHintMap.put(idp.getId(), "false");
        }
        return loginHintMap;
    }

    private static String getTargetAfterRedirect(HttpContext httpContext, HostApp hostApp, boolean isJsm) {
        try {
            HttpServletRequest request = Objects.requireNonNull(httpContext.getRequest());
            Object baseUrl = HttpUrlUtils.getRequestBaseUrl((HttpServletRequest)request);
            String target = SSOLoginHookContextProvider.extractTargetParameter(request.getQueryString(), hostApp);
            if (hostApp instanceof JiraHostApp && isJsm && !StringUtils.startsWith((CharSequence)target, (CharSequence)((JiraHostApp)hostApp).getJsmUrlPart())) {
                baseUrl = (String)baseUrl + ((JiraHostApp)hostApp).getJsmUrlPart();
            }
            if (StringUtils.isBlank((CharSequence)target)) {
                return "";
            }
            if (StringUtils.startsWith((CharSequence)target, (CharSequence)baseUrl)) {
                return target;
            }
            return (String)baseUrl + "/" + target;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String extractTargetParameter(String queryString, HostApp hostApp) {
        String[] urlParameters;
        for (String urlParameter : urlParameters = queryString.split("&")) {
            for (String potentialUserDestinationUrlParameter : hostApp.getTargetUrlParameters()) {
                if (!urlParameter.contains(potentialUserDestinationUrlParameter + "=")) continue;
                return urlParameter.replace(potentialUserDestinationUrlParameter + "=", "");
            }
        }
        return "";
    }
}

