/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.upgrade.data.UpgradePluginSettingsEntryResult;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.atlaskerb.utils.Version;

public class UsernameFromHeaderAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public UsernameFromHeaderAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        java.util.Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/usernameFromHeader.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        HashMap additionalContextDataForPost = HashMap.empty();
        boolean usernameEnabled = "on".equals(req.getParameter("enableUsernameFromHeader"));
        boolean emailEnabled = "on".equals(req.getParameter("enableEmailFromHeader"));
        this.buildModelAndRenderTemplate(req, resp, additionalContextDataForPost.merge(this.setHeaderAttributesAndIpUnblockedList(req, usernameEnabled, emailEnabled)).toJavaMap());
    }

    private boolean hasUpgradeFailures() {
        return this.kssoUpgradeManager.getUpgradeFailures().exists(upgradeConfigResult -> upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST);
    }

    private Map<String, Object> setHeaderAttributesAndIpUnblockedList(HttpServletRequest req, boolean usernameEnabled, boolean emailEnabled) {
        java.util.HashMap additionalDataFromPost = new java.util.HashMap();
        if (usernameEnabled) {
            this.kerbConfManager.setHeaderUsernameAttribute(req.getParameter("headerUsernameAttribute"));
        } else {
            this.kerbConfManager.setHeaderUsernameAttribute(null);
        }
        if (emailEnabled) {
            this.kerbConfManager.setHeaderEmailAttribute(req.getParameter("headerEmailAttribute"));
        } else {
            this.kerbConfManager.setHeaderEmailAttribute(null);
        }
        if (usernameEnabled || emailEnabled) {
            String ipUnblockedList = req.getParameter("headerUsernameIpUnblockedlist");
            Option.of((Object)ipUnblockedList).orElse(Option.of((Object)"")).map(InternetAddressUtils::softNormalizeIpRestrictions).filter(InternetAddressUtils::isValidExistingPermissionList).onEmpty(() -> additionalDataFromPost.put("headerUsernameIpUnblockedlist", ipUnblockedList)).onEmpty(() -> additionalDataFromPost.put("headerUsernameRegexError", true)).onEmpty(() -> additionalDataFromPost.put("headerUsernameRegexFailedUnblockedList", "unblocked list")).onEmpty(() -> additionalDataFromPost.put("invalidDataInIpUnblockedlist", Option.of((Object)ipUnblockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpgradeManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull())).peek(_list -> {
                if (this.hasUpgradeFailures()) {
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST);
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST);
                }
            }).peek(this.kerbConfManager::setHeaderUsernameIpUnblockedList);
            this.kerbConfManager.setHeaderauthUseXForwardedFor("on".equals(req.getParameter("setHeaderauthUseXForwardedFor")));
        } else {
            this.kerbConfManager.setHeaderUsernameIpUnblockedList(null);
            this.kerbConfManager.setHeaderauthUseXForwardedFor(false);
        }
        return HashMap.ofAll(additionalDataFromPost);
    }

    private java.util.Map<String, Object> buildModel(HttpServletRequest request) {
        java.util.Map<String, Object> model = this.newModel(request);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "usernameFromHeader");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("hasUpgradeFailures", this.hasUpgradeFailures());
        if (this.hasUpgradeFailures()) {
            this.addDataFromConfigUpdate(model);
        }
        String usernameAttribute = this.kerbConfManager.getHeaderUsernameAttribute();
        String emailAttribute = this.kerbConfManager.getHeaderEmailAttribute();
        String unblockedlist = this.kerbConfManager.getHeaderUsernameIpUnblockedListAsString();
        boolean usernameEnabled = StringUtils.isNotBlank((CharSequence)unblockedlist) && StringUtils.isNotBlank((CharSequence)usernameAttribute);
        boolean emailEnabled = StringUtils.isNotBlank((CharSequence)unblockedlist) && StringUtils.isNotBlank((CharSequence)emailAttribute);
        usernameAttribute = StringUtils.isBlank((CharSequence)usernameAttribute) ? "username-from-header" : usernameAttribute;
        emailAttribute = StringUtils.isBlank((CharSequence)emailAttribute) ? "email-from-header" : emailAttribute;
        unblockedlist = StringUtils.isBlank((CharSequence)unblockedlist) ? "127.0.0.1" : unblockedlist;
        model.put("headerUsernameAttribute", usernameAttribute);
        model.put("headerEmailAttribute", emailAttribute);
        model.put("headerUsernameIpUnblockedlist", unblockedlist);
        model.put("enableUsernameFromHeader", usernameEnabled);
        model.put("enableEmailFromHeader", emailEnabled);
        model.put("remoteAddr", request.getRemoteAddr());
        if (this.kerbConfManager.isHeaderauthUseXForwardedFor()) {
            model.put("remoteAddr", this.kerbConfManager.getRemoteIpAddress(request));
        }
        model.put("hasRemoteIpValve", HttpUrlUtils.isRemoteIpValveConfigured());
        model.put("isJsdInstalled", this.kerbConfManager.isJsmInstalled());
        model.put("isHeaderauthUseXForwardedFor", this.kerbConfManager.isHeaderauthUseXForwardedFor());
        return model;
    }

    private void addDataFromConfigUpdate(java.util.Map<String, Object> model) {
        List<UpgradePluginSettingsEntryResult> updateFailures = this.kssoUpgradeManager.getUpgradeFailures();
        Option previousVersion = updateFailures.headOption().flatMap(UpgradePluginSettingsEntryResult::maybeVersion);
        previousVersion.peek(version -> {
            if (version.isHigherThanOrEqualTo(Version.of((String)"5.0.0"))) {
                model.put("updatedHeaderUnblockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, KerbConfManager.KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST));
                model.put("headerUnblockedUpdateErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, KerbConfManager.KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST));
            } else {
                model.put("updatedHeaderUnblockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, KerbConfManager.KEYS.LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST));
                model.put("headerUnblockedUpdateErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, KerbConfManager.KEYS.LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST));
            }
        }).onEmpty(() -> {
            model.put("updatedHeaderUnblockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, KerbConfManager.KEYS.LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST));
            model.put("headerUnblockedUpdateErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, KerbConfManager.KEYS.LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST));
        });
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, java.util.Map<String, Object> protoModel) throws IOException {
        java.util.Map<String, Object> model = this.buildModel(req);
        model.putAll(protoModel);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/usernameFromHeader.vm", model, (Writer)resp.getWriter());
    }
}

