/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim.admin;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.ksso.scim.ScimProviderKind;
import com.ksso.scim.ScimVersion;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apiserver.ApiServerConfManager;
import org.kantega.atlaskerb.apiserver.ApiServerConfigState;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;
import org.kantega.atlaskerb.scim.ScimTenantConfig;

public class ShowScimDirectoryAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ApiServerConfManager apiServerConfManager;
    private final ScimConfManager scimConfManager;
    private final TemplateRenderer renderer;

    @Inject
    public ShowScimDirectoryAction(RequireAdminServletDependencyBucket bucket, ApiServerConfManager apiServerConfManager, ScimConfManager scimConfManager) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.renderer = bucket.getTemplateRenderer();
        this.apiServerConfManager = apiServerConfManager;
        this.scimConfManager = scimConfManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getParameter("internalId") != null) {
            String internalId = this.getId(req).replaceFirst("\\?.*$", "");
            try {
                long internalIdent = Long.parseLong(internalId);
                Option<ScimDirectory> tenantDirectory = this.scimConfManager.getScimDirectoryByInternalId(internalIdent);
                resp.sendRedirect(tenantDirectory.isDefined() ? ((ScimDirectory)tenantDirectory.get()).getTenantId() : "../../provisioning/overview");
            }
            catch (NumberFormatException e) {
                resp.sendRedirect("../../provisioning/overview");
            }
            return;
        }
        String tenantId = this.getId(req);
        ScimDirectory directory = (ScimDirectory)this.scimConfManager.getScimDirectory(tenantId).getOrElseThrow(() -> new RuntimeException("SCIM tenant not found: " + tenantId));
        Map<String, Object> model = this.newModel(req);
        this.renderPage(resp, model, directory);
    }

    private void renderPage(HttpServletResponse resp, Map<String, Object> model, ScimDirectory directory) throws IOException {
        ApiServerConfigState apiServerConfig = this.apiServerConfManager.getConfig();
        String tenantId = directory.getTenantId();
        ScimTenantConfig config = directory.getConfig();
        ScimVersion version = config.getKind() == ScimProviderKind.OKTA_V1 ? ScimVersion.V1_1 : ScimVersion.V2_0;
        model.put("topMenu", "connectors");
        model.put("menuItem", "showScimDirectory");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("currentScimDirectory", directory);
        model.put("tenantId", tenantId);
        model.put("tenantName", directory.getTenantName());
        model.put("kind", config.getKind());
        model.put("apiServerEnabled", apiServerConfig.isEnabled());
        model.put("scimBaseUrlEnabled", this.scimConfManager.isScimBaseUrlEndpointEnabled());
        model.put("apiServerUrl", this.scimConfManager.getApiServerEndpoint(tenantId, version));
        model.put("scimBaseUrl", this.scimConfManager.getBaseUrlEndpoint(tenantId, version));
        model.put("authMode", config.getScimAuthMethod().toString());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/scim/show-scim-directory.vm", model, (Writer)resp.getWriter());
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        return p.substring(p.lastIndexOf("/") + 1);
    }
}

