/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.saml.CertDetails;
import org.kantega.atlaskerb.saml.CertGuiWrapper;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.servlet.IdpsConfigServlet;
import org.kantega.samllib.tools.SamlKeyGenerator;

public class CertsServlet
extends RequireAdminServlet {
    private final TemplateRenderer templateRenderer;
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;

    @Inject
    public CertsServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.templateRenderer = bucket.getTemplateRenderer();
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostApp();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.idpConfManager.ensureKeysExist(request.getServerName());
        response.setContentType("text/html");
        Map<String, Object> model = this.newModel(request);
        model.put("menuItem", "samlCerts");
        model.put("topMenu", "SAML");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("dateUtils", new IdpsConfigServlet.DateUtils());
        X509Certificate activeCert = this.idpConfManager.parseCert(this.idpConfManager.getSigningCert());
        String activeCertFilename = this.idpConfManager.getActiveSigningKeyShaId() + ".jks";
        model.put("activeCert", new CertGuiWrapper(new CertDetails(activeCert, activeCertFilename), this.idpConfManager.getSigningKeysDirectory()));
        model.put("isValidCertificate", CertTool.isValidCertificate(activeCert, 0));
        model.put("isExpiringSoonCertificate", CertTool.isExpiringSoon(activeCert));
        model.put("standbyCerts", CertGuiWrapper.getList(this.idpConfManager.getStandbyCertificates(), this.idpConfManager.getSigningKeysDirectory()));
        model.put("downloadCertURL", this.idpConfManager.getSAMLRequestCertUrl(request));
        model.put("keyPasswordSet", this.idpConfManager.getSamlPrivateKeyPassword() != null);
        model.put("warnSamlKeyExpires", this.idpConfManager.isWarnSamlKeyExpires());
        CertsServlet.checkSigningKeyPassword(model, this.idpConfManager);
        model.put("certsPage", true);
        model.put("algorithms", this.idpConfManager.getAlgorithms());
        model.put("selectedAlgorithm", this.idpConfManager.getSamlCertificateAlgorithm());
        this.templateRenderer.render("templates/saml/certs.vm", model, (Writer)response.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String hash;
        File tempFile = new File(this.idpConfManager.getSigningKeysDirectory(), UUID.randomUUID() + ".jks.tmp");
        Try.of((CheckedFunction0 & Serializable)() -> this.hostApp.getMultipartRequest(request, 3000000L)).flatMap(multipartHttpRequest -> Option.of((Object)multipartHttpRequest.getFile("cert_file")).toTry()).andThenTry(keyStoreBytes -> Try.run(() -> FileUtils.writeByteArrayToFile((File)tempFile, (byte[])keyStoreBytes))).mapTry((CheckedFunction1 & Serializable)keyStoreBytes -> {
            try (FileInputStream temp = new FileInputStream(tempFile);){
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(temp, "changeit".toCharArray());
                KeyStore keyStore = ks;
                return keyStore;
            }
        }).filter(ks -> List.of((Object[])new String[]{"myKey", "myCert"}).forAll(alias -> (Boolean)Try.of((CheckedFunction0 & Serializable)() -> ks.containsAlias((String)alias)).getOrElse((Object)false))).andThenTry(ks -> Try.run(() -> {
            String sha256 = CertTool.sha256FingerPrint(ks.getCertificate("myCert").getEncoded());
            SamlKeyGenerator.writeKeyStore((File)new File(this.idpConfManager.getSigningKeysDirectory(), sha256 + ".jks"), (KeyStore)ks);
        })).andFinallyTry(() -> FileUtils.forceDelete((File)tempFile));
        if (request.getParameter("addStandby") != null) {
            this.idpConfManager.addStandbyKey(request.getServerName(), request.getParameter("algorithm"));
        }
        if (request.getParameter("promoteCert") != null) {
            hash = request.getParameter("hash");
            String filename = this.idpConfManager.getStandbyCertificate(hash).getFilename();
            this.idpConfManager.promoteActiveCertificate(filename.substring(0, filename.lastIndexOf(".jks")));
        }
        if (request.getParameter("deleteCert") != null) {
            hash = request.getParameter("hash");
            this.idpConfManager.deleteCertificate(this.idpConfManager.getStandbyCertificate(hash).getFilename());
        }
        if (request.getParameter("update_password") != null) {
            String currentPassword = this.idpConfManager.getSamlPrivateKeyPassword();
            String newPassword = "use_random_password".equals(request.getParameter("encryption")) ? this.idpConfManager.generateSamlPrivateKeyPassword() : null;
            this.idpConfManager.updateSigningKeyPassword(currentPassword, newPassword);
            this.idpConfManager.setSamlPrivateKeyPassword(newPassword);
        }
        this.idpConfManager.setWarnSamlKeyExpires(request.getParameter("warnSamlKeyExpires") != null);
        if (request.getParameter("algorithm") != null) {
            String algorithm = request.getParameter("algorithm");
            this.idpConfManager.setSamlCertificateAlgorithm(algorithm);
        }
        response.sendRedirect("certs");
    }

    public static void checkSigningKeyPassword(Map<String, Object> model, IdpConfManager idpConfManager) {
        if (idpConfManager.getSpSigningCredential() != null) {
            model.put("invalidSigningKeyPassword", idpConfManager.isActiveSigningKeyDefined() && idpConfManager.getSpSigningCredential().getPrivateKey() == null);
        }
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }
}

