/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.security.CookieSecurity;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

@UnrestrictedAccess
public class RememberJsmLogoutFilter
implements Filter {
    private final ApplicationProperties applicationProperties;
    private final IdpConfManager idpConfManager;

    @Inject
    RememberJsmLogoutFilter(@ComponentImport ApplicationProperties applicationProperties, IdpConfManager idpConfManager) {
        this.applicationProperties = applicationProperties;
        this.idpConfManager = idpConfManager;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isLogout;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        boolean bl = isLogout = HttpUrlUtils.urlDecode((String)req.getQueryString()).contains("logout") || StringUtils.contains((CharSequence)req.getRequestURI(), (CharSequence)"logout");
        if (!isLogout) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        Object cookieValue = "true";
        IdpConfiguration idpConf = null;
        String idpIdSessionKey = (String)req.getSession().getAttribute("ksso.idp.id.session.key");
        if (idpIdSessionKey != null) {
            Object samlSessionIdentification;
            idpConf = this.idpConfManager.getIdentityProviderById(idpIdSessionKey);
            cookieValue = idpConf.getId() + "#" + idpIdSessionKey;
            String idTokenSessionKey = (String)req.getSession().getAttribute("ksso.oidc.idtoken");
            if (StringUtils.isNotBlank((CharSequence)idTokenSessionKey)) {
                cookieValue = (String)cookieValue + "#" + idTokenSessionKey;
            }
            if ((samlSessionIdentification = req.getSession().getAttribute("ksso.saml.session.identification")) != null) {
                cookieValue = (String)cookieValue + "#" + samlSessionIdentification;
            }
            cookieValue = Base64.getEncoder().encodeToString(((String)cookieValue).getBytes(StandardCharsets.UTF_8));
        }
        Cookie cookie = CookieSecurity.cookieWithDynamicSecurity(this.applicationProperties, "ksso_manual_login_after_logout", (String)cookieValue);
        cookie.setPath(req.getContextPath() + "/");
        res.addCookie(cookie);
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    public void destroy() {
    }
}

