/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.HomeDirectoryResolver;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.Keytab;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.cache.LastUserAgentsCache;
import org.kantega.atlaskerb.config.ConfigNameSpaces;
import org.kantega.atlaskerb.jaas.JaasConfig;
import org.kantega.atlaskerb.kerberos.Stats;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.security.SameSiteCookiePolicy;
import org.kantega.atlaskerb.utils.CleanupUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.atlaskerb.utils.Version;
import org.kantega.atlaskerb.wrapper.upm.LicenseManagerWrapper;
import org.simplericity.serberuhs.DecodedKerberosToken;
import org.simplericity.serberuhs.KerberosTokenDecoder;
import org.simplericity.serberuhs.keytab.KeytabInfo;
import org.simplericity.serberuhs.keytab.KeytabParser;
import org.simplericity.serberuhs.legacy.LegacyDecodedKerberosToken;
import org.simplericity.serberuhs.legacy.LegacySpNego;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KerbConfManager
implements DebugInfo {
    private static final String KEYTAB_INFO_KEY = "keytabInfo";
    private static final String key = "atlaskerb";
    private static final String oldDisableLoginFileName = "disable_username_password_login.txt";
    private static final String disableTraditionalLoginFileName = "prevent_username_password_login.txt";
    private static final String disableJsmLoginFileName = "prevent_jsm_username_password_login.txt";
    private static final String disableBasicAuthFileName = "disable_basic_auth_rest.txt";
    private static final String enableCsrfOriginCheckFileName = "enable_csrf_origin_check.txt";
    private static final String keytabFileName = "kerberos.keytab";
    private static final java.util.List<String> commonSettingsFileNames = Arrays.asList("prevent_username_password_login.txt", "disable_basic_auth_rest.txt", "prevent_jsm_username_password_login.txt", "enable_csrf_origin_check.txt");
    private static final java.util.List<String> kerberosSettingsFileNames = Arrays.asList("kerberos.keytab");
    private static final java.util.List<String> usercleanupSettingsFilePaths = Arrays.asList(CleanupUtils.getCleanupDirName(CleanupMode.USERS), CleanupUtils.getCleanupDirName(CleanupMode.JSM));
    private static Map<ConfigNameSpaces.ConfigSubset, java.util.List<String>> configSubsetFileNames = new HashMap<ConfigNameSpaces.ConfigSubset, java.util.List<String>>();
    public static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final String[] defaultDisabledUserAgents;
    private static final String restApiRestrictedFilename = "restrict_rest_api_to_api_tokens.txt";
    private static final String oldTraditionalLoginEnabledJsdContent = "isTraditionalLoginEnabledJSD=true";
    private static final String traditionalLoginDisabledJsmContent = "The existence of this file disables traditional username / password login for the Jira Service Management portal. If you need to enable traditional login for JSM, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
    private static final String oldBasicAuthDisabledContent = "isBasicAuthDisabled=true";
    private static final String basicAuthDisabledContent = "The existence of this file disables Basic Auth with username and password on the REST interface. Now only Kerberos, OAuth, Personal access tokens or Kantega SSO API tokens are valid options for authenticating with the REST API.If you need to enable basic auth, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
    private static final String completeLockdownContent = "completeLockdown=true";
    private static final String traditionalLoginDisabledFileContent = "The existence of this file disables traditional username / password login. If you need to enable traditional login, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
    private static final String csrfOriginCheckFileContent = "The existence of this file enables CSRF origin checks and it is recommended to keep it due to security concerns. If you need to disable CSRF origin checks, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
    private static final String restApiRestrictedToApiTokenFileContent = "The existence of this file disables certain REST endpoints to only work with API token authentication. This may affect login mechanisms or other Atlassian functionality if not configured carefully. If you need to restore the original functionality, delete this file. No server restart is required. It may take up to one minute for the change to take effect.";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final PluginMetadataManager pluginMetadataManager;
    private final Stats stats;
    private final Cache<String, Object> oneMinuteCache;
    private final Cache<String, Subject> subjectCache;
    private final LastUserAgentsCache lastUserAgentsCache;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private HomeDirectoryResolver homeDirectoryResolver;
    private final LicenseManagerWrapper licenseManagerWrapper;
    private final PluginSettings settings;

    private String generateSecureRandomKey() {
        byte[] bytes = new byte[48];
        SECURE_RANDOM.nextBytes(bytes);
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static Set<String> getFileNamesFromConfigSubset(Set<ConfigNameSpaces.ConfigSubset> configSubset) {
        return configSubset.stream().filter(c -> c == ConfigNameSpaces.ConfigSubset.COMMON || c == ConfigNameSpaces.ConfigSubset.KERBEROS || c == ConfigNameSpaces.ConfigSubset.USER_CLEANUP).map(configSubsetFileNames::get).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    PluginSettings buildSettings() {
        PluginSettings settingsForKey;
        String dn = this.applicationProperties.getDisplayName().toLowerCase();
        if ((dn.contains("jira") || dn.contains("confluence")) && KerbConfManager.settingsForKeyHasProperties(settingsForKey = this.pluginSettingsFactory.createSettingsForKey(key))) {
            return settingsForKey;
        }
        return this.pluginSettingsFactory.createGlobalSettings();
    }

    @Inject
    public KerbConfManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginMetadataManager pluginMetadataManager, LastUserAgentsCache lastUserAgentsCache) {
        this.applicationProperties = applicationProperties;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.stats = new Stats();
        this.pluginAccessor = pluginAccessor;
        this.pluginMetadataManager = pluginMetadataManager;
        this.oneMinuteCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
        this.subjectCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
        this.lastUserAgentsCache = lastUserAgentsCache;
        this.settings = this.buildSettings();
        this.licenseManagerWrapper = new LicenseManagerWrapper(licenseManager);
    }

    public DecodedKerberosToken decodeKerberosToken(String tokenString) throws Exception {
        if (tokenString == null || !tokenString.startsWith("Negotiate ") || tokenString.length() < 11) {
            return null;
        }
        byte[] token = Base64.decodeBase64((byte[])StandardCharsets.UTF_8.encode(tokenString.substring("Negotiate ".length())).array());
        if (this.isUseLegacyKerberos()) {
            byte[] kerberosToken = new LegacySpNego().getKerberosToken(token);
            LegacyDecodedKerberosToken legacyDecodedKerberosToken = LegacyDecodedKerberosToken.fromToken((byte[])kerberosToken);
            return DecodedKerberosToken.fromLegacyDecodedKerberosToken((LegacyDecodedKerberosToken)legacyDecodedKerberosToken);
        }
        byte[] kerberosToken = KerberosTokenDecoder.parseKerberosTokenFromSpnego((byte[])token);
        return DecodedKerberosToken.fromToken((byte[])kerberosToken);
    }

    public static java.util.List<HashMap<String, String>> convertKerberosKeysToList(java.util.List<KerberosKey> keys) {
        ArrayList<HashMap<String, String>> keyList = new ArrayList<HashMap<String, String>>();
        for (KerberosKey key : keys) {
            HashMap<String, String> keyMap = new HashMap<String, String>();
            keyMap.put("principalName", key.getPrincipal().getName());
            keyMap.put("algorithm", key.getAlgorithm().toUpperCase());
            keyMap.put("realm", key.getPrincipal().getRealm());
            keyMap.put("keyType", String.valueOf(key.getKeyType()));
            keyMap.put("versionNumber", String.valueOf(key.getVersionNumber()));
            keyList.add(keyMap);
        }
        return keyList;
    }

    private static String nullsafe(Object param) {
        return param == null ? null : param.toString();
    }

    public String getPluginRootAbsoluteUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "/plugins/servlet/" + PluginKey.getPluginKeyBasepart();
    }

    public String getPluginRootUri() {
        return "/plugins/servlet/" + PluginKey.getPluginKeyBasepart();
    }

    public static Properties getBuildInfo() {
        Properties buildInfo = new Properties();
        try (InputStream is = KerbConfManager.class.getResourceAsStream("/build-info.properties");){
            buildInfo.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buildInfo;
    }

    public boolean isLicenseDefined() {
        return this.licenseManagerWrapper.isLicenseDefined();
    }

    public Stats getStats() {
        return this.stats;
    }

    public Subject getSubject(DecodedKerberosToken decodedKerberosToken) {
        if (decodedKerberosToken == null) {
            return null;
        }
        Keytab keytab = new Keytab(this.getKeytabInfos());
        String tokenPrincipal = this.getPrincipalForSubject(decodedKerberosToken, keytab);
        try {
            return (Subject)this.subjectCache.get((Object)tokenPrincipal, () -> (Subject)ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)ComponentLocator.class.getClassLoader(), () -> {
                JaasConfig config = new JaasConfig(this.getKeytabFile(), tokenPrincipal);
                CallbackHandler cbh = callbacks -> this.log.info("{} callbacks: {}", (Object)callbacks.length, (Object)callbacks);
                LoginContext ctx = new LoginContext(key, null, cbh, config);
                ctx.login();
                return ctx.getSubject();
            }));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to obtain Subject", e);
        }
    }

    public DecodedKerberosToken decodeKerberosToken(HttpServletRequest request) throws Exception {
        String atz = request.getHeader("Authorization");
        if (atz == null) {
            return null;
        }
        if (!atz.startsWith("Negotiate")) {
            return null;
        }
        return this.decodeKerberosToken(atz);
    }

    private String getPrincipalForSubject(DecodedKerberosToken decodedKerberosToken, Keytab keytab) {
        String tokenPrincipal = decodedKerberosToken.getService() + "/" + decodedKerberosToken.getHost() + "@" + decodedKerberosToken.getRealm();
        String oldConfiguredPrincipal = (String)this.settings.get(KEYS.PRINCIPAL.key);
        if (oldConfiguredPrincipal != null && keytab.getEntries().size() == 1 && !oldConfiguredPrincipal.equals(tokenPrincipal)) {
            return oldConfiguredPrincipal;
        }
        return tokenPrincipal;
    }

    public synchronized void flushKeytabCaches() {
        this.oneMinuteCache.invalidate((Object)KEYTAB_INFO_KEY);
        this.subjectCache.invalidateAll();
    }

    public static String getRestApiRestrictedFilename() {
        return restApiRestrictedFilename;
    }

    public boolean isUserNameAttributeLookupEnabled() {
        Object userNameAttributeLookupEnabled = this.settings.get(KEYS.USERNAME_ATTR_LOOKUP_ENABLED.key);
        return "true".equals(userNameAttributeLookupEnabled) || "true".equals(this.settings.get(KEYS.USER_PRINCIPAL_ATTR_LOOKUP_ENABLED.key));
    }

    public void setUserNameAttributeLookupEnabled(boolean userNameAttributeLookupEnabled) {
        this.settings.put(KEYS.USERNAME_ATTR_LOOKUP_ENABLED.key, (Object)Boolean.toString(userNameAttributeLookupEnabled));
        this.settings.remove(KEYS.USER_PRINCIPAL_ATTR_LOOKUP_ENABLED.key);
    }

    public boolean isUseLegacyKerberos() {
        return "true".equals(this.settings.get(KEYS.USE_LEGACY_KERBEROS.key));
    }

    public void setUseLegacyKerberos(boolean useLegacyKerberos) {
        this.settings.put(KEYS.USE_LEGACY_KERBEROS.key, (Object)Boolean.toString(useLegacyKerberos));
    }

    public boolean isKerberosEnabled() {
        return !"false".equals(this.settings.get(KEYS.KERBEROS_ENABLED.key));
    }

    public void setKerberosEnabled(boolean manualLoginLogEnabled) {
        this.settings.put(KEYS.KERBEROS_ENABLED.key, (Object)Boolean.toString(manualLoginLogEnabled));
    }

    public KerberosUserPermissionType getKerberosUserPermission() {
        try {
            String kerberosUserPermission = this.settings.get(KEYS.KERBEROS_USER_PERMISSION.key).toString();
            return KerberosUserPermissionType.valueOf(kerberosUserPermission);
        }
        catch (Exception e) {
            return KerberosUserPermissionType.ENABLE_ALL_USERS;
        }
    }

    public void setKerberosUserPermission(KerberosUserPermissionType kerberosUserPermission) {
        this.settings.put(KEYS.KERBEROS_USER_PERMISSION.key, (Object)kerberosUserPermission.toString());
    }

    public UserPermissionGroupDirectoryType getKerberosUserPermissionSome() {
        try {
            String kerberosUserPermission = this.settings.get(KEYS.KERBEROS_USER_PERMISSION_SOME.key).toString();
            return UserPermissionGroupDirectoryType.valueOf(kerberosUserPermission);
        }
        catch (Exception e) {
            return UserPermissionGroupDirectoryType.GROUP;
        }
    }

    public void setKerberosUserPermissionSome(UserPermissionGroupDirectoryType kerberosUserPermissionSome) {
        this.settings.put(KEYS.KERBEROS_USER_PERMISSION_SOME.key, (Object)kerberosUserPermissionSome.toString());
    }

    public UserPermissionGroupType getKerberosUserPermissionGroup() {
        try {
            String kerberosUserPermissionGroup = this.settings.get(KEYS.KERBEROS_USER_PERMISSION_GROUP.key).toString();
            return UserPermissionGroupType.valueOf(kerberosUserPermissionGroup);
        }
        catch (Exception e) {
            return UserPermissionGroupType.ENABLE_USERS_IN_GROUP;
        }
    }

    public void setKerberosUserPermissionGroup(UserPermissionGroupType kerberosUserPermissionGroup) {
        this.settings.put(KEYS.KERBEROS_USER_PERMISSION_GROUP.key, (Object)kerberosUserPermissionGroup.toString());
    }

    public boolean showWelcomeMessage() {
        return !"false".equals(this.settings.get(KEYS.SHOW_WELCOME_MESSAGE.key));
    }

    public void setShowWelcomeMessage(boolean showWelcomeMessage) {
        this.settings.put(KEYS.SHOW_WELCOME_MESSAGE.key, (Object)Boolean.toString(showWelcomeMessage));
    }

    public boolean isManualLoginLogEnabled() {
        return "true".equals(this.settings.get(KEYS.MANUAL_LOGIN_LOG_ENABLED.key));
    }

    public void setManualLoginLogEnabled(boolean manualLoginLogEnabled) {
        this.settings.put(KEYS.MANUAL_LOGIN_LOG_ENABLED.key, (Object)Boolean.toString(manualLoginLogEnabled));
    }

    public boolean isCollectUserAgentsEnabled() {
        return "true".equals(this.settings.get(KEYS.COLLECT_LAST_USER_AGENTS_LIST_ENABLED.key));
    }

    public void setCollectUserAgentsEnabled(boolean collectUserAgentsEnabled) {
        this.settings.put(KEYS.COLLECT_LAST_USER_AGENTS_LIST_ENABLED.key, (Object)Boolean.toString(collectUserAgentsEnabled));
    }

    public boolean isRequireLogin() {
        return "true".equals(this.settings.get(KEYS.REQUIRE_LOGIN_ENABLED.key));
    }

    public void setRequireLogin(boolean requireLogin) {
        this.settings.put(KEYS.REQUIRE_LOGIN_ENABLED.key, (Object)Boolean.toString(requireLogin));
    }

    public boolean isForceLogin() {
        return "true".equals(this.settings.get(KEYS.SEND_TO_LOGIN_ENABLED.key));
    }

    public void setForceLogin(boolean sendToLoginEnabledConfigured) {
        this.settings.put(KEYS.SEND_TO_LOGIN_ENABLED.key, (Object)Boolean.toString(sendToLoginEnabledConfigured));
    }

    public String getJsmCustomInfoBoxContent() {
        String message = (String)this.settings.get(KEYS.JSM_CUSTOM_INFO_BOX_CONTENT.key);
        if (message != null && !message.isEmpty()) {
            return message;
        }
        return this.getAllTraditionalLoginDisabledDefaultMessage();
    }

    public void setJsmCustomInfoBoxContent(String message) {
        this.settings.put(KEYS.JSM_CUSTOM_INFO_BOX_CONTENT.key, (Object)message);
    }

    public boolean isShowInfoBoxOnJsmLogin() {
        return "true".equals(this.settings.get(KEYS.SHOW_INFO_BOX_ON_JSM_LOGIN.key));
    }

    public void setShowInfoBoxOnJsmLogin(boolean showInfoBoxOnJsmLogin) {
        this.settings.put(KEYS.SHOW_INFO_BOX_ON_JSM_LOGIN.key, (Object)Boolean.toString(showInfoBoxOnJsmLogin));
    }

    @Deprecated
    public boolean oldIsTraditionalLoginDisabled() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginDisabled", () -> {
                File disableLoginFile = new File(this.homeDirectoryResolver.getHomeDirectory(), oldDisableLoginFileName);
                return disableLoginFile.exists() && disableLoginFile.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking username password disable status", e.getCause());
            return false;
        }
    }

    @Deprecated
    public boolean oldIsTraditionalLoginDisabledJSD() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginDisabledJSD", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), oldDisableLoginFileName);
                if (file.exists() && file.isFile()) {
                    String fileContents = FileUtils.readFileToString((File)file);
                    return !fileContents.contains(oldTraditionalLoginEnabledJsdContent);
                }
                return false;
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isTraditionalLoginDisabled status", e.getCause());
            return true;
        }
    }

    @Deprecated
    public boolean oldIsBasicAuthDisabled() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isBasicAuthDisabled", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), oldDisableLoginFileName);
                if (file.exists() && file.isFile()) {
                    String fileContents = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                    return fileContents.contains(oldBasicAuthDisabledContent);
                }
                return false;
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking old isBasicAuthDisabled status", e.getCause());
            return false;
        }
    }

    public boolean isTraditionalLoginPrevented() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginPrevented", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), disableTraditionalLoginFileName);
                return file.exists() && file.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isTraditionalLoginDisabled status", e.getCause());
            return true;
        }
    }

    public boolean isAllTraditionalLoginPrevented() {
        return this.isTraditionalLoginPrevented() && this.getAllowTraditionalLoginGroups().isEmpty();
    }

    public boolean isTraditionalLoginJsmPrevented() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginJsmPrevented", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), disableJsmLoginFileName);
                return file.exists() && file.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking disable traditional login jsm status", e.getCause());
            return true;
        }
    }

    public boolean isBasicAuthPreventedByFileExisting() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isBasicAuthPrevented", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), disableBasicAuthFileName);
                return file.exists() && file.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isBasicAuthPrevented status", e.getCause());
            return false;
        }
    }

    public BasicAuthUserPermissionType getBasicAuthPermissionType() {
        if (!this.isBasicAuthPreventedByFileExisting()) {
            return BasicAuthUserPermissionType.ENABLE_ALL_USERS;
        }
        try {
            String basicAuthPermission = this.settings.get(KEYS.BASIC_AUTH_PERMISSION_TYPE.key).toString();
            return BasicAuthUserPermissionType.valueOf(basicAuthPermission);
        }
        catch (Exception e) {
            return BasicAuthUserPermissionType.ENABLE_ALL_USERS;
        }
    }

    public void setBasicAuthPermissionType(BasicAuthUserPermissionType basicAuthPermissionType) {
        this.setBasicAuthPreventedByFile(basicAuthPermissionType != BasicAuthUserPermissionType.ENABLE_ALL_USERS);
        this.settings.put(KEYS.BASIC_AUTH_PERMISSION_TYPE.key, (Object)basicAuthPermissionType.toString());
    }

    public UserPermissionGroupDirectoryType getBasicAuthPermissionSomeUsersConfig() {
        try {
            String value = this.settings.get(KEYS.BASIC_AUTH_PERMISSION_SOME_USERS_CONFIG.key).toString();
            return UserPermissionGroupDirectoryType.valueOf(value);
        }
        catch (Exception e) {
            return UserPermissionGroupDirectoryType.DIRECTORY;
        }
    }

    public void setBasicAuthPermissionSome(UserPermissionGroupDirectoryType basicAuthPermissionSome) {
        this.settings.put(KEYS.BASIC_AUTH_PERMISSION_SOME_USERS_CONFIG.key, (Object)basicAuthPermissionSome.toString());
    }

    public UserPermissionGroupType getBasicAuthPermissionGroup() {
        try {
            String value = this.settings.get(KEYS.BASIC_AUTH_PERMISSION_GROUP.key).toString();
            return UserPermissionGroupType.valueOf(value);
        }
        catch (Exception e) {
            return UserPermissionGroupType.ENABLE_USERS_IN_GROUP;
        }
    }

    public void setBasicAuthPermissionGroup(UserPermissionGroupType basicAuthPermissionGroup) {
        this.settings.put(KEYS.BASIC_AUTH_PERMISSION_GROUP.key, (Object)basicAuthPermissionGroup.toString());
    }

    public boolean setTraditionalLoginPrevented(boolean traditionalLoginPrevented) {
        return this.addOrDeleteFile(traditionalLoginPrevented, disableTraditionalLoginFileName, traditionalLoginDisabledFileContent, "setTraditionalLoginPrevented");
    }

    public boolean setTraditionalLoginJsmPrevented(boolean traditionalLoginJsmPrevented) {
        return this.addOrDeleteFile(traditionalLoginJsmPrevented, disableJsmLoginFileName, traditionalLoginDisabledJsmContent, "setTraditionalLoginJsmPrevented");
    }

    public boolean setBasicAuthPreventedByFile(boolean basicAuthPrevented) {
        return this.addOrDeleteFile(basicAuthPrevented, disableBasicAuthFileName, basicAuthDisabledContent, "setBlockBasicAuth");
    }

    public boolean setBasicAuthEnabledByFile(boolean basicAuthEnabled) {
        return this.addOrDeleteFile(!basicAuthEnabled, disableBasicAuthFileName, basicAuthDisabledContent, "setBlockBasicAuth");
    }

    private boolean addOrDeleteFile(boolean shouldFileExist, String fileName, String fileContent, String method) {
        String action;
        String string = action = !shouldFileExist ? "create" : "delete";
        if (StringUtils.isBlank((CharSequence)fileName)) {
            this.log.error("No file to write to. Abort " + action + " file for " + method);
        }
        try {
            File file = new File(this.homeDirectoryResolver.getHomeDirectory(), fileName);
            if (shouldFileExist) {
                file.getParentFile().mkdirs();
                FileUtils.writeByteArrayToFile((File)file, (byte[])((String)Option.of((Object)fileContent).getOrElse((Object)"")).getBytes(StandardCharsets.UTF_8));
            } else {
                Files.deleteIfExists(Paths.get(file.getPath(), new String[0]));
            }
            this.oneMinuteCache.invalidateAll();
            return true;
        }
        catch (IOException e) {
            this.log.error("Unable to " + action + " file: " + fileName, (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("Something failed when trying to" + action + " file: " + fileName, (Throwable)e);
        }
        return false;
    }

    public boolean isCsrfOriginCheckEnabled() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isCsrfOriginCheckDisabled", () -> {
                File enableCsrfOriginCheckFile = new File(this.homeDirectoryResolver.getHomeDirectory(), enableCsrfOriginCheckFileName);
                return enableCsrfOriginCheckFile.exists() && enableCsrfOriginCheckFile.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking CSRF origin check status", e.getCause());
            return false;
        }
    }

    public boolean setCsrfOriginCheckEnabled(boolean csrfOriginCheckEnabled) {
        try {
            File file = new File(this.homeDirectoryResolver.getHomeDirectory(), enableCsrfOriginCheckFileName);
            if (csrfOriginCheckEnabled) {
                file.getParentFile().mkdirs();
                FileUtils.writeByteArrayToFile((File)file, (byte[])csrfOriginCheckFileContent.getBytes(StandardCharsets.UTF_8));
            } else {
                Files.deleteIfExists(Paths.get(file.getPath(), new String[0]));
            }
            this.oneMinuteCache.invalidateAll();
            return true;
        }
        catch (IOException e) {
            String action = csrfOriginCheckEnabled ? "create" : "delete";
            this.log.error("Unable to " + action + " file: enable_csrf_origin_check.txt", (Throwable)e);
        }
        catch (Exception e) {
            String action = csrfOriginCheckEnabled ? "create" : "delete";
            this.log.error("Something failed when trying to" + action + " file: enable_csrf_origin_check.txt", (Throwable)e);
        }
        return false;
    }

    public void setRestApiRestrictedToApiTokens(boolean restApiRestricted, boolean completeLockdown) {
        try {
            File file = new File(this.homeDirectoryResolver.getHomeDirectory(), restApiRestrictedFilename);
            if (restApiRestricted) {
                Object content = restApiRestrictedToApiTokenFileContent;
                if (completeLockdown) {
                    content = (String)content + "\n\ncompleteLockdown=true";
                }
                file.getParentFile().mkdirs();
                FileUtils.writeByteArrayToFile((File)file, (byte[])((String)content).getBytes(StandardCharsets.UTF_8));
            } else {
                Files.deleteIfExists(Paths.get(file.getPath(), new String[0]));
            }
            this.oneMinuteCache.invalidateAll();
        }
        catch (IOException e) {
            String action = restApiRestricted ? "create" : "delete";
            this.log.error("Unable to " + action + " file: restrict_rest_api_to_api_tokens.txt", (Throwable)e);
        }
        catch (Exception e) {
            String action = restApiRestricted ? "create" : "delete";
            this.log.error("Something failed when trying to" + action + " file: restrict_rest_api_to_api_tokens.txt", (Throwable)e);
        }
    }

    public void flushOneMinuteCache() {
        this.oneMinuteCache.invalidateAll();
    }

    public boolean isRestApiRestrictedToApiTokens() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isRestApiRestrictedToApiTokens", () -> {
                File restApiRestrictedFile = new File(this.homeDirectoryResolver.getHomeDirectory(), restApiRestrictedFilename);
                return restApiRestrictedFile.exists() && restApiRestrictedFile.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isRestApiRestrictedToTokens status", e.getCause());
            return false;
        }
    }

    public boolean isRestApiCompleteLockdown() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isRestApiCompleteLockdown", () -> {
                File restApiRestrictedFile = new File(this.homeDirectoryResolver.getHomeDirectory(), restApiRestrictedFilename);
                if (restApiRestrictedFile.exists() && restApiRestrictedFile.isFile()) {
                    String fileContents = FileUtils.readFileToString((File)restApiRestrictedFile, (Charset)StandardCharsets.UTF_8);
                    return fileContents.contains(completeLockdownContent);
                }
                return false;
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isRestApiCompleteLockdown status", e.getCause());
            return false;
        }
    }

    @Nullable
    public String getLockedRestApiErrorPageMessage() {
        return (String)this.settings.get(KEYS.LOCKED_REST_API_ERROR_PAGE_MESSAGE.key);
    }

    public void setLockedRestApiErrorPageMessage(String message) {
        Option.of((Object)message).peek(msg -> this.settings.put(KEYS.LOCKED_REST_API_ERROR_PAGE_MESSAGE.key, msg));
    }

    public String getTemplateLockedRestApiErrorPageMessage() {
        return String.format("REST URL <requested REST URL> has been blocked for non-API token access by your Administrator in Kantega SSO. To open this endpoint, either do so under Rest API access in Kantega SSO, or remove the file %s on the server", restApiRestrictedFilename);
    }

    public String getDefaultLockedRestApiErrorPageMessage(String maybeRequestUri) {
        String requestedUri = (String)Option.of((Object)maybeRequestUri).getOrElse((Object)"<REST API endpoint>");
        return String.format("The REST URL %s has been blocked for non-API token access by your Administrator in Kantega SSO. To open this endpoint, either do so under Rest API access in Kantega SSO, or remove the file '%s' on the server", requestedUri, restApiRestrictedFilename);
    }

    public String getKerberosHomeDirectoryPath() {
        if (this.homeDirectoryResolver != null && this.homeDirectoryResolver.getHomeDirectory() != null) {
            return this.homeDirectoryResolver.getHomeDirectory().getPath();
        }
        return "";
    }

    public String getErrorPageMessage() {
        if (this.settings.get(KEYS.ERROR_PAGE_MESSAGE.key) != null) {
            return (String)this.settings.get(KEYS.ERROR_PAGE_MESSAGE.key);
        }
        return this.getDefaultErrorPageMessage();
    }

    public void setErrorPageMessage(String message) {
        this.settings.put(KEYS.ERROR_PAGE_MESSAGE.key, (Object)message);
    }

    public String getTraditionalLoginDisabledDefaultMessage() {
        return "Username / password login is disabled for your account by your administrator";
    }

    public String getTraditionalLoginDisabledMessage() {
        if (this.settings.get(KEYS.TRADITIONAL_LOGIN_DISABLED_MESSAGE.key) != null) {
            return (String)this.settings.get(KEYS.TRADITIONAL_LOGIN_DISABLED_MESSAGE.key);
        }
        return this.getTraditionalLoginDisabledDefaultMessage();
    }

    public void setTraditionalLoginDisabledMessage(String message) {
        this.settings.put(KEYS.TRADITIONAL_LOGIN_DISABLED_MESSAGE.key, (Object)message);
    }

    public String getAllTraditionalLoginDisabledDefaultMessage() {
        return "Username / password login is disabled by your administrator";
    }

    public String getAllTraditionalLoginDisabledMessage() {
        if (this.settings.get(KEYS.ALL_TRADITIONAL_LOGIN_DISABLED_MESSAGE.key) != null) {
            return (String)this.settings.get(KEYS.ALL_TRADITIONAL_LOGIN_DISABLED_MESSAGE.key);
        }
        return this.getAllTraditionalLoginDisabledDefaultMessage();
    }

    public void setAllTraditionalLoginDisabledMessage(String message) {
        this.settings.put(KEYS.ALL_TRADITIONAL_LOGIN_DISABLED_MESSAGE.key, (Object)message);
    }

    public String getSamlLoginUsernamePlaceholder() {
        if (this.settings.get(KEYS.SAML_LOGIN_USERNAME_PLACEHOLDER.key) != null) {
            return (String)this.settings.get(KEYS.SAML_LOGIN_USERNAME_PLACEHOLDER.key);
        }
        return this.getDefaultSamlLoginUsernamePlaceholder();
    }

    public void setSamlLoginUsernamePlaceholder(String placeholder) {
        this.settings.put(KEYS.SAML_LOGIN_USERNAME_PLACEHOLDER.key, (Object)placeholder);
    }

    public String getUsernameFieldText() {
        if (this.settings.get(KEYS.USERNAME_FIELD_TEXT.key) != null) {
            return (String)this.settings.get(KEYS.USERNAME_FIELD_TEXT.key);
        }
        return this.getDefaultUsernameFieldText();
    }

    public void setUsernameFieldText(String usernameFieldText) {
        this.settings.put(KEYS.USERNAME_FIELD_TEXT.key, (Object)usernameFieldText);
    }

    public String getDefaultUsernameFieldText() {
        return "Username";
    }

    public String getNextButtonText() {
        if (this.settings.get(KEYS.NEXT_BUTTON_TEXT.key) != null) {
            return (String)this.settings.get(KEYS.NEXT_BUTTON_TEXT.key);
        }
        return this.getDefaultNextButtonText();
    }

    public void setNextButtonText(String nextButtonText) {
        this.settings.put(KEYS.NEXT_BUTTON_TEXT.key, (Object)nextButtonText);
    }

    public String getDefaultNextButtonText() {
        return "Next";
    }

    public String getIdpListTitleText() {
        if (this.settings.get(KEYS.IDP_LIST_TITLE_TEXT.key) != null) {
            return (String)this.settings.get(KEYS.IDP_LIST_TITLE_TEXT.key);
        }
        return this.getDefaultIdpListTitleText();
    }

    public void setIdpListTitleText(String idpListTitleText) {
        this.settings.put(KEYS.IDP_LIST_TITLE_TEXT.key, (Object)idpListTitleText);
    }

    public String getDefaultIdpListTitleText() {
        return "Log in with";
    }

    public String getDefaultSamlLoginUsernamePlaceholder() {
        return "user.name@example.com";
    }

    public String getDefaultErrorPageMessage() {
        return "This can occur for a variety of reasons, but most likely you just need to try logging in again. If this fails, please try closing your browser completely before trying again. If the issue persists, please contact your administrator.";
    }

    public String getSharedLoginTitle() {
        String customSharedLoginTitle = this.getCustomSharedLoginTitle();
        return StringUtils.isNotEmpty((CharSequence)customSharedLoginTitle) ? customSharedLoginTitle : this.getDefaultSharedLoginTitle();
    }

    public String getDefaultSharedLoginTitle() {
        return "Log in";
    }

    public String getCustomSharedLoginTitle() {
        if (this.settings.get(KEYS.SHARED_LOGIN_TITLE.key) != null) {
            return (String)this.settings.get(KEYS.SHARED_LOGIN_TITLE.key);
        }
        return "";
    }

    public void setCustomSharedLoginTitle(String loginTitle) {
        if (loginTitle == null) {
            this.settings.remove(KEYS.SHARED_LOGIN_TITLE.key);
        } else {
            this.settings.put(KEYS.SHARED_LOGIN_TITLE.key, (Object)loginTitle);
        }
    }

    public String getSharedLoginSubtitle() {
        String customSharedLoginSubtitle = this.getCustomSharedLoginSubtitle();
        return StringUtils.isNotEmpty((CharSequence)customSharedLoginSubtitle) ? customSharedLoginSubtitle : this.getDefaultSharedLoginSubtitle();
    }

    public String getDefaultSharedLoginSubtitle() {
        return "Log in with SSO";
    }

    public String getCustomSharedLoginSubtitle() {
        if (this.settings.get(KEYS.SHARED_LOGIN_SUBTITLE.key) != null) {
            return (String)this.settings.get(KEYS.SHARED_LOGIN_SUBTITLE.key);
        }
        return "";
    }

    public void setCustomSharedLoginSubtitle(String loginSubtitle) {
        if (loginSubtitle == null) {
            this.settings.remove(KEYS.SHARED_LOGIN_SUBTITLE.key);
        } else {
            this.settings.put(KEYS.SHARED_LOGIN_SUBTITLE.key, (Object)loginSubtitle);
        }
    }

    public String getSharedLoginAlternativeDivider() {
        String customSharedLoginAlternativeDivider = this.getCustomSharedLoginAlternativeDivider();
        return StringUtils.isNotEmpty((CharSequence)customSharedLoginAlternativeDivider) ? customSharedLoginAlternativeDivider : this.getDefaultSharedLoginAlternativeDivider();
    }

    public String getDefaultSharedLoginAlternativeDivider() {
        return "or";
    }

    public String getCustomSharedLoginAlternativeDivider() {
        if (this.settings.get(KEYS.SHARED_LOGIN_ALTERNATIVE_DIVIDER.key) != null) {
            return (String)this.settings.get(KEYS.SHARED_LOGIN_ALTERNATIVE_DIVIDER.key);
        }
        return "";
    }

    public void setCustomSharedLoginAlternativeDivider(String loginAlternativeDivider) {
        if (loginAlternativeDivider == null) {
            this.settings.remove(KEYS.SHARED_LOGIN_ALTERNATIVE_DIVIDER.key);
        } else {
            this.settings.put(KEYS.SHARED_LOGIN_ALTERNATIVE_DIVIDER.key, (Object)loginAlternativeDivider);
        }
    }

    public String getSharedCannotLoginText() {
        String customSharedLoginCannotLoginText = this.getCustomSharedCannotLoginText();
        return StringUtils.isNotEmpty((CharSequence)customSharedLoginCannotLoginText) ? customSharedLoginCannotLoginText : this.getDefaultSharedCannotLoginText();
    }

    public String getDefaultSharedCannotLoginText() {
        return "Can't log in?";
    }

    public String getCustomSharedCannotLoginText() {
        if (this.settings.get(KEYS.SHARED_CANNOT_LOGIN_TEXT.key) != null) {
            return (String)this.settings.get(KEYS.SHARED_CANNOT_LOGIN_TEXT.key);
        }
        return "";
    }

    public void setCustomSharedCannotLoginText(String cannotLoginText) {
        if (cannotLoginText == null) {
            this.settings.remove(KEYS.SHARED_CANNOT_LOGIN_TEXT.key);
        } else {
            this.settings.put(KEYS.SHARED_CANNOT_LOGIN_TEXT.key, (Object)cannotLoginText);
        }
    }

    public String getAutomaticTraditionalLoginButtonText() {
        String customAutomaticTraditionalLoginButtonText = this.getCustomAutomaticTraditionalLoginButtonText();
        return StringUtils.isNotEmpty((CharSequence)customAutomaticTraditionalLoginButtonText) ? customAutomaticTraditionalLoginButtonText : this.getDefaultAutomaticTraditionalLoginButtonText();
    }

    public String getDefaultAutomaticTraditionalLoginButtonText() {
        return "Log in with username and password";
    }

    public String getCustomAutomaticTraditionalLoginButtonText() {
        if (this.settings.get(KEYS.AUTOMATIC_TRADITIONAL_LOGIN_BUTTON_TEXT.key) != null) {
            return (String)this.settings.get(KEYS.AUTOMATIC_TRADITIONAL_LOGIN_BUTTON_TEXT.key);
        }
        return "";
    }

    public void setCustomAutomaticTraditionalLoginButtonText(String traditionalLoginButtonText) {
        if (traditionalLoginButtonText == null) {
            this.settings.remove(KEYS.AUTOMATIC_TRADITIONAL_LOGIN_BUTTON_TEXT.key);
        } else {
            this.settings.put(KEYS.AUTOMATIC_TRADITIONAL_LOGIN_BUTTON_TEXT.key, (Object)traditionalLoginButtonText);
        }
    }

    public String getManualUsernameLoginSubtitle() {
        String customManualUsernameLoginSubtitle = this.getCustomManualUsernameLoginSubtitle();
        return StringUtils.isNotEmpty((CharSequence)customManualUsernameLoginSubtitle) ? customManualUsernameLoginSubtitle : this.getDefaultManualUsernameLoginSubtitle();
    }

    public String getDefaultManualUsernameLoginSubtitle() {
        return "Enter your username";
    }

    public String getCustomManualUsernameLoginSubtitle() {
        if (this.settings.get(KEYS.MANUAL_USERNAME_LOGIN_SUBTITLE.key) != null) {
            return (String)this.settings.get(KEYS.MANUAL_USERNAME_LOGIN_SUBTITLE.key);
        }
        return "";
    }

    public void setCustomManualUsernameLoginSubtitle(String usernameLoginSubtitle) {
        if (usernameLoginSubtitle == null) {
            this.settings.remove(KEYS.MANUAL_USERNAME_LOGIN_SUBTITLE.key);
        } else {
            this.settings.put(KEYS.MANUAL_USERNAME_LOGIN_SUBTITLE.key, (Object)usernameLoginSubtitle);
        }
    }

    public String getManualUsernamePlaceholderText() {
        String customManualUsernamePlaceholderText = this.getCustomManualUsernamePlaceholderText();
        return StringUtils.isNotEmpty((CharSequence)customManualUsernamePlaceholderText) ? customManualUsernamePlaceholderText : this.getDefaultManualUsernamePlaceholderText();
    }

    public String getDefaultManualUsernamePlaceholderText() {
        return "Username";
    }

    public String getCustomManualUsernamePlaceholderText() {
        if (this.settings.get(KEYS.MANUAL_USERNAME_PLACEHOLDER_TEXT.key) != null) {
            return (String)this.settings.get(KEYS.MANUAL_USERNAME_PLACEHOLDER_TEXT.key);
        }
        return "";
    }

    public void setCustomManualUsernamePlaceholderText(String usernamePlaceholderText) {
        if (usernamePlaceholderText == null) {
            this.settings.remove(KEYS.MANUAL_USERNAME_PLACEHOLDER_TEXT.key);
        } else {
            this.settings.put(KEYS.MANUAL_USERNAME_PLACEHOLDER_TEXT.key, (Object)usernamePlaceholderText);
        }
    }

    public String getManualContinueButtonText() {
        String customManualContinueWithLoginButton = this.getCustomManualContinueButtonText();
        return StringUtils.isNotEmpty((CharSequence)customManualContinueWithLoginButton) ? customManualContinueWithLoginButton : this.getDefaultManualContinueButtonText();
    }

    public String getDefaultManualContinueButtonText() {
        return "Continue";
    }

    public String getCustomManualContinueButtonText() {
        if (this.settings.get(KEYS.MANUAL_CONTINUE_BUTTON_TEXT.key) != null) {
            return (String)this.settings.get(KEYS.MANUAL_CONTINUE_BUTTON_TEXT.key);
        }
        return "";
    }

    public void setCustomManualContinueButtonText(String continueButtonText) {
        if (continueButtonText == null) {
            this.settings.remove(KEYS.MANUAL_CONTINUE_BUTTON_TEXT.key);
        } else {
            this.settings.put(KEYS.MANUAL_CONTINUE_BUTTON_TEXT.key, (Object)continueButtonText);
        }
    }

    public String getRedirectRedirectionText() {
        String customRedirectRedirectionText = this.getCustomRedirectRedirectionText();
        return StringUtils.isNotEmpty((CharSequence)customRedirectRedirectionText) ? customRedirectRedirectionText : this.getDefaultRedirectRedirectionText();
    }

    public String getDefaultRedirectRedirectionText() {
        return "You are being redirected to";
    }

    public String getCustomRedirectRedirectionText() {
        if (this.settings.get(KEYS.REDIRECT_REDIRECTION_TEXT.key) != null) {
            return (String)this.settings.get(KEYS.REDIRECT_REDIRECTION_TEXT.key);
        }
        return "";
    }

    public void setCustomRedirectRedirectionText(String redirectionText) {
        if (redirectionText == null) {
            this.settings.remove(KEYS.REDIRECT_REDIRECTION_TEXT.key);
        } else {
            this.settings.put(KEYS.REDIRECT_REDIRECTION_TEXT.key, (Object)redirectionText);
        }
    }

    public String getRedirectCancelRedirectButtonText() {
        String customRedirectCancelButtonText = this.getCustomRedirectCancelRedirectButtonText();
        return StringUtils.isNotEmpty((CharSequence)customRedirectCancelButtonText) ? customRedirectCancelButtonText : this.getDefaultRedirectCancelRedirectButtonText();
    }

    public String getDefaultRedirectCancelRedirectButtonText() {
        return "Cancel (ESC)";
    }

    public String getCustomRedirectCancelRedirectButtonText() {
        if (this.settings.get(KEYS.REDIRECT_CANCEL_REDIRECT_BUTTON_TEXT.key) != null) {
            return (String)this.settings.get(KEYS.REDIRECT_CANCEL_REDIRECT_BUTTON_TEXT.key);
        }
        return "";
    }

    public void setCustomRedirectCancelButtonText(String cancelRedirectButtonText) {
        if (cancelRedirectButtonText == null) {
            this.settings.remove(KEYS.REDIRECT_CANCEL_REDIRECT_BUTTON_TEXT.key);
        } else {
            this.settings.put(KEYS.REDIRECT_CANCEL_REDIRECT_BUTTON_TEXT.key, (Object)cancelRedirectButtonText);
        }
    }

    public String getRedirectRedirectionHint() {
        String customRedirectRedirectionHint = this.getCustomRedirectRedirectionHint();
        return StringUtils.isNotEmpty((CharSequence)customRedirectRedirectionHint) ? customRedirectRedirectionHint : this.getDefaultRedirectRedirectionHint();
    }

    public String getDefaultRedirectRedirectionHint() {
        return "Hint: You can press Enter to immediately go to your identity provider or press Escape to cancel the redirect";
    }

    public String getCustomRedirectRedirectionHint() {
        if (this.settings.get(KEYS.REDIRECT_REDIRECTION_HINT.key) != null) {
            return (String)this.settings.get(KEYS.REDIRECT_REDIRECTION_HINT.key);
        }
        return "";
    }

    public void setCustomRedirectRedirectionHint(String redirectionHint) {
        if (redirectionHint == null) {
            this.settings.remove(KEYS.REDIRECT_REDIRECTION_HINT.key);
        } else {
            this.settings.put(KEYS.REDIRECT_REDIRECTION_HINT.key, (Object)redirectionHint);
        }
    }

    public String getAtlassianUseSsoButtonText() {
        String customAtlassianUseSsoButtonText = this.getCustomAtlassianUseSsoButtonText();
        return StringUtils.isNotEmpty((CharSequence)customAtlassianUseSsoButtonText) ? customAtlassianUseSsoButtonText : this.getDefaultAtlassianUseSsoButtonText();
    }

    public String getDefaultAtlassianUseSsoButtonText() {
        return "Log in with SSO";
    }

    public String getCustomAtlassianUseSsoButtonText() {
        if (this.settings.get(KEYS.ATLASSIAN_USE_SSO_BUTTON_TEXT.key) != null) {
            return (String)this.settings.get(KEYS.ATLASSIAN_USE_SSO_BUTTON_TEXT.key);
        }
        return "";
    }

    public void setCustomAtlassianUseSsoButtonText(String useSsoButtonText) {
        if (useSsoButtonText == null) {
            this.settings.remove(KEYS.ATLASSIAN_USE_SSO_BUTTON_TEXT.key);
        } else {
            this.settings.put(KEYS.ATLASSIAN_USE_SSO_BUTTON_TEXT.key, (Object)useSsoButtonText);
        }
    }

    public String getCustomTextBoxOnLoginPageContent() {
        if (this.settings.get(KEYS.CUSTOM_TEXT_ON_LOGIN_PAGE.key) != null) {
            return (String)this.settings.get(KEYS.CUSTOM_TEXT_ON_LOGIN_PAGE.key);
        }
        return "";
    }

    public Map<String, Object> populateModelWithCustomLoginTexts(Map<String, Object> model) {
        model.put("sharedLoginTitle", this.getSharedLoginTitle());
        model.put("sharedLoginSubtitle", this.getSharedLoginSubtitle());
        model.put("sharedLoginAlternativeDivider", this.getSharedLoginAlternativeDivider());
        model.put("sharedCannotLoginText", this.getSharedCannotLoginText());
        model.put("automaticTraditionalLoginButtonText", this.getAutomaticTraditionalLoginButtonText());
        model.put("manualUsernameLoginSubtitle", this.getManualUsernameLoginSubtitle());
        model.put("manualUsernamePlaceholderText", this.getManualUsernamePlaceholderText());
        model.put("manualContinueButtonText", this.getManualContinueButtonText());
        model.put("redirectRedirectionText", this.getRedirectRedirectionText());
        model.put("redirectCancelRedirectButtonText", this.getRedirectCancelRedirectButtonText());
        model.put("redirectRedirectionHint", this.getRedirectRedirectionHint());
        model.put("atlassianUseSsoButtonText", this.getAtlassianUseSsoButtonText());
        return model;
    }

    public void setCustomTextBoxOnLoginPageContent(String content) {
        this.settings.put(KEYS.CUSTOM_TEXT_ON_LOGIN_PAGE.key, (Object)content);
    }

    public boolean isCustomTextBoxOnLoginPageEnabled() {
        return "true".equals(this.settings.get(KEYS.SHOW_CUSTOM_TEXT_BOX_ON_LOGIN_PAGE.key));
    }

    public void setCustomTextBoxOnLoginPageEnabled(boolean enabled) {
        this.settings.put(KEYS.SHOW_CUSTOM_TEXT_BOX_ON_LOGIN_PAGE.key, (Object)Boolean.toString(enabled));
    }

    public String[] getHeaderUsernameIpUnblockedList() {
        return ListParseUtils.parseArrayFromNewlines((String)((String)this.settings.get(KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST.key)));
    }

    public void setHeaderUsernameIpUnblockedList(String unblockedlist) {
        if (unblockedlist != null && unblockedlist.isEmpty()) {
            unblockedlist = null;
        }
        this.settings.put(KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST.key, (Object)unblockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    public String getHeaderUsernameIpUnblockedListAsString() {
        return (String)this.settings.get(KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST.key);
    }

    public String getHeaderUsernameAttribute() {
        return (String)this.settings.get(KEYS.HEADER_USERNAME_ATTRIBUTE.key);
    }

    public void setHeaderUsernameAttribute(String username) {
        if (username != null && username.isEmpty()) {
            username = null;
        }
        this.settings.put(KEYS.HEADER_USERNAME_ATTRIBUTE.key, (Object)username);
        this.oneMinuteCache.invalidateAll();
    }

    public String getHeaderEmailAttribute() {
        return (String)this.settings.get(KEYS.HEADER_EMAIL_ATTRIBUTE.key);
    }

    public void setHeaderEmailAttribute(String email) {
        if (email != null && email.isEmpty()) {
            email = null;
        }
        this.settings.put(KEYS.HEADER_EMAIL_ATTRIBUTE.key, (Object)email);
        this.oneMinuteCache.invalidateAll();
    }

    public String getJsmSignupEmailUnblockedList() {
        return (String)this.settings.get(KEYS.JSM_SIGNUP_EMAIL_UNBLOCKEDLIST.key);
    }

    public void setJsmSignupEmailUnblockedList(String unblockedList) {
        if (unblockedList != null && unblockedList.isEmpty()) {
            unblockedList = null;
        }
        this.settings.put(KEYS.JSM_SIGNUP_EMAIL_UNBLOCKEDLIST.key, (Object)unblockedList);
        this.oneMinuteCache.invalidateAll();
    }

    public String getJsmSignupFormUrlparts() {
        return (String)this.settings.get(KEYS.JSM_SIGNUP_FORM_URLPARTS.key);
    }

    public void setJsmSignupFormUrlparts(String urlPart) {
        if (urlPart != null && urlPart.isEmpty()) {
            urlPart = null;
        }
        this.settings.put(KEYS.JSM_SIGNUP_FORM_URLPARTS.key, (Object)urlPart);
        this.oneMinuteCache.invalidateAll();
    }

    public boolean isHeaderauthUseXForwardedFor() {
        Object isHeaderauthUseXForwardedFor = this.settings.get(KEYS.HEADERAUTH_USE_X_FORWARDED_FOR.key);
        return "true".equals(isHeaderauthUseXForwardedFor);
    }

    public void setHeaderauthUseXForwardedFor(boolean headerauthUseXForwardedFor) {
        this.settings.put(KEYS.HEADERAUTH_USE_X_FORWARDED_FOR.key, (Object)Boolean.toString(headerauthUseXForwardedFor));
    }

    public void addPreemptiveAuthExcludedPaths(String url) {
        Set<String> urls = this.getRequireLoginExcludedPaths();
        urls.add(url);
        this.settings.put(KEYS.PREEMPTIVE_AUTH_EXCLUDED_PATHS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public void removePreemptiveAuthExcludedPaths(String url) {
        Set<String> urls = this.getRequireLoginExcludedPaths();
        urls.remove(url);
        this.settings.put(KEYS.PREEMPTIVE_AUTH_EXCLUDED_PATHS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public Set<String> getDefaultRequireLoginExcludedPaths() {
        LinkedHashSet<String> defaultExcludedPaths = new LinkedHashSet<String>();
        defaultExcludedPaths.add("/plugins/servlet/no.kantega.saml");
        defaultExcludedPaths.add("/plugins/servlet/" + PluginKey.getPluginKeyBasepart());
        defaultExcludedPaths.add("/ksso/");
        return defaultExcludedPaths;
    }

    public Set<String> getRequireLoginExcludedPaths() {
        Set excludedPaths = ListParseUtils.parseSetFromCommaSeparated((String)((String)this.settings.get(KEYS.PREEMPTIVE_AUTH_EXCLUDED_PATHS.key)));
        excludedPaths.addAll(this.getDefaultRequireLoginExcludedPaths());
        return excludedPaths;
    }

    public Set<String> getRestExcludedPaths() {
        String excludedPaths = (String)this.settings.get(KEYS.REST_EXCLUDED_PATHS.key);
        if (excludedPaths == null || excludedPaths.trim().isEmpty()) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Arrays.asList(excludedPaths.split(",")));
    }

    /*
     * WARNING - void declaration
     */
    public void setRestExcludedPaths(Set<String> excludedPaths) {
        StringBuilder sb = new StringBuilder();
        for (String string : excludedPaths) {
            void var4_4;
            if (!StringUtils.startsWith((CharSequence)string, (CharSequence)"/")) {
                String string2 = "/" + string;
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((String)var4_4);
        }
        this.settings.put(KEYS.REST_EXCLUDED_PATHS.key, (Object)sb.toString());
    }

    public boolean isBitbucketScmUrlsEnabled() {
        Object bitbucketScmUrlsEnabled = this.settings.get(KEYS.BITBUCKET_SCM_URLS_ENABLED.key);
        return "true".equals(bitbucketScmUrlsEnabled);
    }

    public void setBitbucketScmUrlsEnabled(boolean bitbucketScmUrlsEnabled) {
        this.settings.put(KEYS.BITBUCKET_SCM_URLS_ENABLED.key, (Object)Boolean.toString(bitbucketScmUrlsEnabled));
    }

    public boolean isBitbucketScmUrlsUsed() {
        Object bitbucketScmUrlsEnabled = this.settings.get(KEYS.BITBUCKET_SCM_URLS_ENABLED.key);
        return bitbucketScmUrlsEnabled != null;
    }

    public boolean isBitbucketKerberosScmUrlsDefault() {
        return "true".equals(this.settings.get(KEYS.BITBUCKET_SCM_URLS_DEFAULT.key));
    }

    public void setBitbucketKerberosScmUrlsDefault(boolean bitbucketKerberosScmUrlsDefault) {
        this.settings.put(KEYS.BITBUCKET_SCM_URLS_DEFAULT.key, (Object)Boolean.toString(bitbucketKerberosScmUrlsDefault));
    }

    public String getBitbucketKerberosScmUrlTypes() {
        return (String)this.settings.get(KEYS.BITBUCKET_SCM_URL_TYPES.key);
    }

    public void setBitbucketKerberosScmUrlTypes(String bitbucketKerberosScmUrlTypes) {
        this.settings.put(KEYS.BITBUCKET_SCM_URL_TYPES.key, (Object)bitbucketKerberosScmUrlTypes);
    }

    public boolean isKerberosRestAuthEnabled() {
        Object jiraRestAuthEnabled = this.settings.get(KEYS.JIRA_REST_AUTH_ENABLED.key);
        Object restAuthEnabled = this.settings.get(KEYS.REST_AUTH_ENABLED.key);
        return "true".equals(jiraRestAuthEnabled) || "true".equals(restAuthEnabled);
    }

    public boolean isKerberosRestFromBrowserEnabled() {
        Object restFromBrowser = this.settings.get(KEYS.KERBEROS_REST_FROM_BROWSER_ENABLED.key);
        return "true".equals(restFromBrowser);
    }

    public void setKerberosRestFromBrowserEnabled(boolean browserKerberosRestAuthEnabled) {
        this.settings.put(KEYS.KERBEROS_REST_FROM_BROWSER_ENABLED.key, (Object)Boolean.toString(browserKerberosRestAuthEnabled));
    }

    public void setKerberosRestAuthEnabled(boolean restAuthEnabled) {
        this.settings.put(KEYS.REST_AUTH_ENABLED.key, (Object)Boolean.toString(restAuthEnabled));
        this.settings.remove(KEYS.JIRA_REST_AUTH_ENABLED.key);
    }

    public boolean isBitbucketKerberosScmUrlsEnabled() {
        Object bitbucketScmUrlsEnabled = this.settings.get(KEYS.BITBUCKET_KERBEROS_SCM_URLS_ENABLED.key);
        return "true".equals(bitbucketScmUrlsEnabled);
    }

    public void setBitbucketKerberosScmUrlsEnabled(boolean bitbucketKerberosScmUrlsEnabled) {
        this.settings.put(KEYS.BITBUCKET_KERBEROS_SCM_URLS_ENABLED.key, (Object)Boolean.toString(bitbucketKerberosScmUrlsEnabled));
    }

    public boolean isWebdavEnabled() {
        return "true".equals(this.settings.get(KEYS.WEBDAV_ENABLED.key));
    }

    public void setWebdavEnabled(boolean webdavEnabled) {
        this.settings.put(KEYS.WEBDAV_ENABLED.key, (Object)Boolean.toString(webdavEnabled));
    }

    public String getCleanupRuleJSONString(CleanupMode cleanupMode) {
        if (cleanupMode.equals((Object)CleanupMode.USERS)) {
            return (String)this.settings.get(ConfigNameSpaces.USER_CLEANUP_SETTINGS.USER_CLEANUP_RULE.key);
        }
        return (String)this.settings.get(ConfigNameSpaces.USER_CLEANUP_SETTINGS.JSM_CLEANUP_RULE.key);
    }

    public void setCleanupRuleJSONString(String cleanupRuleJson, CleanupMode cleanupMode) {
        if (cleanupMode.equals((Object)CleanupMode.USERS)) {
            this.settings.put(KEYS.USER_CLEANUP_RULE.key, (Object)cleanupRuleJson);
        } else {
            this.settings.put(KEYS.JSM_CLEANUP_RULE.key, (Object)cleanupRuleJson);
        }
    }

    public boolean isClientFailureCollectionEnabled() {
        return "true".equals(this.settings.get(KEYS.FAILURE_COLLECTION.key));
    }

    public void setClientFailureCollectionEnabled(boolean enabled) {
        this.settings.put(KEYS.FAILURE_COLLECTION.key, (Object)Boolean.toString(enabled));
    }

    public void setHomeDirectoryResolver(HomeDirectoryResolver homeDirectoryResolver) {
        this.homeDirectoryResolver = homeDirectoryResolver;
    }

    public boolean isKeytabConfigured() {
        File keytabFile = this.getKeytabFile();
        if (keytabFile == null) {
            return false;
        }
        return keytabFile.exists() && keytabFile.isFile();
    }

    public boolean isKeytabUploaded() {
        return "true".equals(this.settings.get(KEYS.KEYTAB_UPLOADED.key));
    }

    public File getKeytabFile() {
        if (this.isKeytabUploaded()) {
            return this.getUploadedKeytabFile();
        }
        String keytabFile = KerbConfManager.nullsafe(this.settings.get(KEYS.KEYTAB_FILE.key));
        return keytabFile == null ? null : new File(keytabFile);
    }

    public void setKeytabFile(File path) {
        this.settings.put(KEYS.KEYTAB_FILE.key, (Object)path.getAbsolutePath());
        this.settings.put(KEYS.KEYTAB_UPLOADED.key, (Object)"false");
        this.settings.remove(KEYS.PRINCIPAL.key);
        this.flushKeytabCaches();
    }

    public Set<String> getRequiredGroups() {
        String requiredGroups = (String)this.settings.get(KEYS.REQUIRED_GROUP.key);
        if (StringUtils.isBlank((CharSequence)requiredGroups)) {
            return Collections.emptySet();
        }
        String[] groups = requiredGroups.trim().split("\\n");
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = groups[i].trim();
        }
        return new TreeSet<String>(Arrays.asList(groups));
    }

    public void setRequiredGroups(String requiredGroups) {
        if (StringUtils.isBlank((CharSequence)requiredGroups)) {
            this.settings.remove(KEYS.REQUIRED_GROUP.key);
        } else {
            this.settings.put(KEYS.REQUIRED_GROUP.key, (Object)requiredGroups);
        }
    }

    public String getCrowdAutoAddGroups() {
        return (String)this.settings.get(KEYS.CROWD_AUTO_ADD_GROUPS.key);
    }

    public void setCrowdAutoAddGroups(String crowdAutoAddGroups) {
        this.settings.put(KEYS.CROWD_AUTO_ADD_GROUPS.key, (Object)crowdAutoAddGroups);
    }

    public String getAdditionalUserSuffix() {
        return (String)this.settings.get(KEYS.ADDITIONAL_USER_SUFFIX.key);
    }

    public void setAdditionalUserSuffix(String additionalUserSuffix) {
        this.settings.put(KEYS.ADDITIONAL_USER_SUFFIX.key, (Object)additionalUserSuffix);
    }

    public String getKerberosMultiRegex() {
        return (String)this.settings.get(KEYS.KERBEROS_MULTI_REGEX.key);
    }

    public void setKerberosMultiRegex(String regex) {
        this.settings.put(KEYS.KERBEROS_MULTI_REGEX.key, (Object)regex);
    }

    public boolean isRegexLookupEnabled() {
        return "true".equals(this.settings.get(KEYS.REGEX_LOOKUP_ENABLED.key));
    }

    public boolean isOnlyRegexTransformationLookup() {
        return "true".equals(this.settings.get(KEYS.ONLY_REGEX_TRANSFORMATION_LOOKUP.key));
    }

    public void setOnlyRegexTransformationLookup(boolean enabled) {
        this.settings.put(KEYS.ONLY_REGEX_TRANSFORMATION_LOOKUP.key, (Object)Boolean.toString(enabled));
    }

    public boolean isLookupUsernameFromMappingFile() {
        return "true".equals(this.settings.get(KEYS.LOOKUP_USERNAME_FROM_MAPPING_FILE.key));
    }

    public void setLookupUsernameFromMappingFile(boolean enabled) {
        this.settings.put(KEYS.LOOKUP_USERNAME_FROM_MAPPING_FILE.key, (Object)Boolean.toString(enabled));
    }

    public void setRegexLookupEnabled(boolean enabled) {
        this.settings.put(KEYS.REGEX_LOOKUP_ENABLED.key, (Object)Boolean.toString(enabled));
    }

    public java.util.List<KeytabInfo> getKeytabInfos() {
        try {
            return (java.util.List)this.oneMinuteCache.get((Object)KEYTAB_INFO_KEY, () -> {
                File file = this.getKeytabFile();
                if (file != null && file.exists() && file.isFile()) {
                    try (FileInputStream is = new FileInputStream(file);){
                        java.util.List list = new KeytabParser().parse((InputStream)is);
                        return list;
                    }
                }
                return Collections.emptyList();
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed reading keytab info", e);
        }
    }

    public Map<String, String> getSettings() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (KEYS keys : KEYS.values()) {
            Object value = this.settings.get(keys.key);
            if (!(value instanceof String)) continue;
            result.put(keys.key, (String)value);
        }
        return result;
    }

    public void restoreSettings(Properties props, Set<ConfigNameSpaces.ConfigSubset> configOptions) {
        if (configOptions == null) {
            return;
        }
        if (configOptions.contains((Object)ConfigNameSpaces.ConfigSubset.KERBEROS)) {
            for (Enum enum_ : ConfigNameSpaces.KERBEROS_SETTINGS.values()) {
                this.restoreSettings(((ConfigNameSpaces.KERBEROS_SETTINGS)enum_).key, props);
            }
        }
        if (configOptions.contains((Object)ConfigNameSpaces.ConfigSubset.IDP)) {
            for (Enum enum_ : ConfigNameSpaces.IDP_SETTINGS.values()) {
                this.restoreSettings(((ConfigNameSpaces.IDP_SETTINGS)enum_).key, props);
            }
        }
        if (configOptions.contains((Object)ConfigNameSpaces.ConfigSubset.API_TOKENS)) {
            for (Enum enum_ : ConfigNameSpaces.API_TOKEN_SETTINGS.values()) {
                this.restoreSettings(((ConfigNameSpaces.API_TOKEN_SETTINGS)enum_).key, props);
            }
        }
        if (configOptions.contains((Object)ConfigNameSpaces.ConfigSubset.USER_CLEANUP)) {
            for (Enum enum_ : ConfigNameSpaces.USER_CLEANUP_SETTINGS.values()) {
                this.restoreSettings(((ConfigNameSpaces.USER_CLEANUP_SETTINGS)enum_).key, props);
            }
        }
        if (configOptions.contains((Object)ConfigNameSpaces.ConfigSubset.COMMON)) {
            for (Enum enum_ : ConfigNameSpaces.COMMON_SETTINGS.values()) {
                this.restoreSettings(((ConfigNameSpaces.COMMON_SETTINGS)enum_).key, props);
            }
        }
    }

    private void restoreSettings(String keys, Properties props) {
        this.settings.remove(keys);
        String value = props.getProperty(keys);
        if (value != null) {
            this.settings.put(keys, (Object)value);
        }
    }

    public synchronized void flushCaches() {
        this.oneMinuteCache.invalidateAll();
        this.flushKeytabCaches();
    }

    public static boolean settingsForKeyHasProperties(PluginSettings settingsForKey) {
        return settingsForKey.get(KEYS.KEYTAB_UPLOADED.key) != null || settingsForKey.get(KEYS.KEYTAB_FILE.key) != null;
    }

    public PluginLicenseManager getLicenseManager() {
        return this.licenseManagerWrapper.getLicenseManager();
    }

    public String getRemoteIpAddress(HttpServletRequest req) {
        String remoteAddr = req.getRemoteAddr();
        String forwardedFor = req.getHeader("x-forwarded-for");
        if (forwardedFor != null && !forwardedFor.equals(remoteAddr) && this.getPreferredProxyHeader() != null) {
            this.log.trace("Using x-forwarded-for IP address");
            String[] forwardedIps = forwardedFor.split(",");
            return forwardedIps[0].trim();
        }
        return remoteAddr;
    }

    public Set<String> getDisabledUserAgents() {
        IpRestrictionConfig restrictionCfg = this.getIpRestrictionConfig();
        HashSet<String> set = new HashSet<String>(Arrays.asList(defaultDisabledUserAgents));
        set.addAll(this.getCustomDisabledUserAgents());
        return set;
    }

    public void addCustomDisabledUserAgent(String userAgent) {
        Set<String> userAgents = this.getCustomDisabledUserAgents();
        userAgents.add(userAgent);
        this.settings.put(KEYS.CUSTOM_DISABLED_USER_AGENTS.key, ListParseUtils.iterableToLineSeparatedString.apply(userAgents));
    }

    public void removeCustomDisabledUserAgent(String userAgent) {
        Set<String> urls = this.getCustomDisabledUserAgents();
        urls.remove(userAgent);
        this.settings.put(KEYS.CUSTOM_DISABLED_USER_AGENTS.key, ListParseUtils.iterableToLineSeparatedString.apply(urls));
    }

    public Set<String> getCustomDisabledUserAgents() {
        return new TreeSet<String>(ListParseUtils.parseSetFromNewlines((String)((String)this.settings.get(KEYS.CUSTOM_DISABLED_USER_AGENTS.key))));
    }

    public void addIdpDisabledUserAgent(String userAgent) {
        Set<String> userAgents = this.getIdpDisabledUserAgents();
        userAgents.add(userAgent);
        this.settings.put(KEYS.IDP_DISABLED_USER_AGENTS.key, ListParseUtils.iterableToLineSeparatedString.apply(userAgents));
    }

    public void removeIdpDisabledUserAgent(String userAgent) {
        Set<String> urls = this.getIdpDisabledUserAgents();
        urls.remove(userAgent);
        this.settings.put(KEYS.IDP_DISABLED_USER_AGENTS.key, ListParseUtils.iterableToLineSeparatedString.apply(urls));
    }

    public Set<String> getIdpDisabledUserAgents() {
        return new TreeSet<String>(ListParseUtils.parseSetFromNewlines((String)((String)this.settings.get(KEYS.IDP_DISABLED_USER_AGENTS.key))));
    }

    public boolean isIdpDisabledUserAgent(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        for (String idpDisabledUserAgent : this.getIdpDisabledUserAgents()) {
            if (!userAgent.contains(idpDisabledUserAgent)) continue;
            return true;
        }
        return false;
    }

    public IpRestrictionConfig getIpRestrictionConfig() {
        try {
            return (IpRestrictionConfig)this.oneMinuteCache.get((Object)IpRestrictionConfig.class.getName(), () -> new IpRestrictionConfig(this.settings));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Couldn't read restriction configuration", e);
        }
    }

    public Object get(KEYS key) {
        return this.settings.get(key.key);
    }

    public Object get(String key) {
        return this.settings.get(key);
    }

    public void putAndInvalidateCache(KEYS key, Object value) {
        this.settings.put(key.key, value);
        this.oneMinuteCache.invalidateAll();
    }

    public void put(KEYS key, Object value) {
        this.settings.put(key.key, value);
    }

    public void put(String key, Object value) {
        this.settings.put(key, value);
    }

    public void removeUpdateFailures() {
        this.settings.remove(KEYS.CONFIG_UPDATE_FAILURES.key);
    }

    public PluginSettingsFactory getPluginSettingsFactory() {
        return this.pluginSettingsFactory;
    }

    public String getPreferredProxyHeader() {
        return (String)this.settings.get(KEYS.PREFERRED_PROXY_HEADER.key);
    }

    public void setPreferredProxyHeader(String preferredProxyHeader) {
        this.settings.put(KEYS.PREFERRED_PROXY_HEADER.key, (Object)preferredProxyHeader);
    }

    public void setGlobalIpUnblockedList(String unblockedlist) {
        if (unblockedlist != null && unblockedlist.isEmpty()) {
            unblockedlist = null;
        }
        this.settings.put(KEYS.GLOBAL_IP_UNBLOCKEDLIST.key, (Object)unblockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    public void setGlobalIpBlockedList(String blockedlist) {
        if (blockedlist != null && blockedlist.isEmpty()) {
            blockedlist = null;
        }
        this.settings.put(KEYS.GLOBAL_IP_BLOCKEDLIST.key, (Object)blockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    public void setGlobalIpRestrictionType(IpRestrictionType ipRestrictionType) {
        this.settings.put(KEYS.GLOBAL_IP_RESTRICTION_TYPE.key, (Object)ipRestrictionType.key);
        this.oneMinuteCache.invalidateAll();
    }

    public void setRestIpUnblockedList(String ipUnblockedlist) {
        if (ipUnblockedlist != null && ipUnblockedlist.isEmpty()) {
            ipUnblockedlist = null;
        }
        this.settings.put(KEYS.REST_IP_UNBLOCKEDLIST.key, (Object)ipUnblockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    public void setRestIpBlockedlist(String blockedlist) {
        if (blockedlist != null && blockedlist.isEmpty()) {
            blockedlist = null;
        }
        this.settings.put(KEYS.REST_IP_BLOCKEDLIST.key, (Object)blockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    public void setRestIpRestrictionType(IpRestrictionType type) {
        this.settings.put(KEYS.REST_IP_RESTRICTION_TYPE.key, (Object)type.key);
        this.oneMinuteCache.invalidateAll();
    }

    public void setCustomDisabledUserAgents(String[] userAgents) {
        if (userAgents != null && userAgents.length == 0) {
            userAgents = null;
        }
        this.settings.put(KEYS.CUSTOM_DISABLED_USER_AGENTS.key, (Object)StringUtils.join((Object[])userAgents, (String)"\n"));
        this.oneMinuteCache.invalidateAll();
    }

    public boolean isRemembermeCookieEnabled() {
        return "true".equals(this.settings.get(KEYS.REMEMBERME_COOKIE_ENABLED.key));
    }

    public void setRemembermeCookieEnabled(boolean value) {
        this.settings.put(KEYS.REMEMBERME_COOKIE_ENABLED.key, (Object)Boolean.toString(value));
    }

    public boolean isLdapFilterEncoding() {
        return !"false".equals(this.settings.get(KEYS.LDAP_FILTER_ENCODING.key));
    }

    public void setLdapFilterEncoding(boolean value) {
        this.settings.put(KEYS.LDAP_FILTER_ENCODING.key, (Object)Boolean.toString(value));
    }

    public Boolean isApiTokensEnabled() {
        return "true".equals(this.settings.get(KEYS.API_TOKENS_ENABLED.key));
    }

    public void setApiTokensEnabled(boolean value) {
        this.settings.put(KEYS.API_TOKENS_ENABLED.key, (Object)Boolean.toString(value));
    }

    public String getAdditionalBearerKey() {
        return (String)this.settings.get(KEYS.API_TOKENS_ADDITIONAL_BEARER_KEY.key);
    }

    public void setAdditionalBearerKey(String bearerKey) {
        if (StringUtils.isBlank((CharSequence)bearerKey)) {
            bearerKey = null;
        }
        this.settings.put(KEYS.API_TOKENS_ADDITIONAL_BEARER_KEY.key, (Object)bearerKey);
        this.oneMinuteCache.invalidateAll();
    }

    public ApiTokenUtil.TokenUserPermission getApiTokenUserPermission() {
        String tokenUserPermission = (String)this.settings.get(KEYS.API_TOKEN_USER_PERMISSION.key);
        if (tokenUserPermission != null) {
            return ApiTokenUtil.TokenUserPermission.valueOf(tokenUserPermission);
        }
        ApiTokenUtil.TokenUserPermission allUsers = this.checkOldConfigUserPermission();
        if (allUsers != null) {
            return allUsers;
        }
        return ApiTokenUtil.TokenUserPermission.NO_USERS;
    }

    public void setApiTokenUserPermission(ApiTokenUtil.TokenUserPermission value) {
        this.settings.put(KEYS.API_TOKEN_USER_PERMISSION.key, (Object)value.name());
    }

    @Nullable
    private ApiTokenUtil.TokenUserPermission checkOldConfigUserPermission() {
        String oldConfigTokenUserPermission = (String)this.settings.get(KEYS.USER_API_TOKEN_ENABLED.key);
        if (oldConfigTokenUserPermission != null && "true".equals(this.settings.get(KEYS.USER_API_TOKEN_ENABLED.key))) {
            return ApiTokenUtil.TokenUserPermission.ALL_USERS;
        }
        return null;
    }

    public java.util.List<String> getApiTokenAllowedUserGroups() {
        String commaSeparatedAllowedGroups = (String)this.settings.get(KEYS.API_TOKEN_ALLOWED_USER_GROUPS.key);
        return ListParseUtils.parseListFromCommaSeparated((String)commaSeparatedAllowedGroups);
    }

    public void setApiTokenAllowedUserGroups(String commaSeparatedAllowedGroups) {
        if (StringUtils.isBlank((CharSequence)commaSeparatedAllowedGroups)) {
            this.settings.remove(KEYS.API_TOKEN_ALLOWED_USER_GROUPS.key);
        } else {
            this.settings.put(KEYS.API_TOKEN_ALLOWED_USER_GROUPS.key, (Object)commaSeparatedAllowedGroups);
        }
    }

    public void setApiTokenIpUnblockedList(String unblockedlist) {
        this.settings.put(KEYS.API_TOKEN_IP_UNBLOCKEDLIST.key, (Object)StringUtils.trimToNull((String)unblockedlist));
        this.oneMinuteCache.invalidateAll();
    }

    public void setApiTokenIpBlockedList(String blockedlist) {
        this.settings.put(KEYS.API_TOKEN_IP_BLOCKEDLIST.key, (Object)StringUtils.trimToNull((String)blockedlist));
        this.oneMinuteCache.invalidateAll();
    }

    public void setApiTokenIpRestrictionType(IpRestrictionType ipRestrictionType) {
        this.settings.put(KEYS.API_TOKEN_IP_RESTRICTION_TYPE.key, (Object)ipRestrictionType.key);
        this.oneMinuteCache.invalidateAll();
    }

    public void setBasicAuthIpUnblockedList(String unblockedlist) {
        this.settings.put(KEYS.BASIC_AUTH_IP_UNBLOCKEDLIST.key, (Object)StringUtils.trimToNull((String)unblockedlist));
        this.oneMinuteCache.invalidateAll();
    }

    public void setBasicAuthIpBlockedList(String blockedlist) {
        this.settings.put(KEYS.BASIC_AUTH_IP_BLOCKEDLIST.key, (Object)StringUtils.trimToNull((String)blockedlist));
        this.oneMinuteCache.invalidateAll();
    }

    public void setBasicAuthIpStrictBlockedList(java.util.List<String> blockedlist) {
        this.settings.put(KEYS.BASIC_AUTH_IP_STRICT_BLOCKEDLIST.key, (Object)ListParseUtils.iterableToCommaSeparatedString(blockedlist));
        this.oneMinuteCache.invalidateAll();
    }

    public void removeBasicAuthIpStrictBlockedList(String ipRule) {
        IpRestrictionConfig restrictionCfg = this.getIpRestrictionConfig();
        String[] ipRules = restrictionCfg.getBasicAuthIpStrictBlockedList();
        ArrayList<String> ipRulesNew = new ArrayList<String>(Arrays.asList(ipRules));
        ipRulesNew.remove(ipRule);
        this.settings.put(KEYS.BASIC_AUTH_IP_STRICT_BLOCKEDLIST.key, (Object)ListParseUtils.iterableToCommaSeparatedString(ipRulesNew));
        this.oneMinuteCache.invalidateAll();
    }

    public void setBasicAuthIpOpenBlockedList(java.util.List<String> blockedlist) {
        this.settings.put(KEYS.BASIC_AUTH_IP_OPEN_BLOCKEDLIST.key, (Object)ListParseUtils.iterableToCommaSeparatedString(blockedlist));
        this.oneMinuteCache.invalidateAll();
    }

    public void removeBasicAuthIpOpenBlockedList(String ipRule) {
        IpRestrictionConfig restrictionCfg = this.getIpRestrictionConfig();
        String[] ipRules = restrictionCfg.getBasicAuthIpOpenBlockedList();
        ArrayList<String> ipRulesNew = new ArrayList<String>(Arrays.asList(ipRules));
        ipRulesNew.remove(ipRule);
        this.settings.put(KEYS.BASIC_AUTH_IP_OPEN_BLOCKEDLIST.key, (Object)ListParseUtils.iterableToCommaSeparatedString(ipRulesNew));
        this.oneMinuteCache.invalidateAll();
    }

    public void setBasicAuthIpStrictUnblockedList(java.util.List<String> unblockedlist) {
        this.settings.put(KEYS.BASIC_AUTH_IP_STRICT_UNBLOCKEDLIST.key, (Object)ListParseUtils.iterableToCommaSeparatedString(unblockedlist));
        this.oneMinuteCache.invalidateAll();
    }

    public void removeBasicAuthIpStrictUnblockedList(String ipRule) {
        IpRestrictionConfig restrictionCfg = this.getIpRestrictionConfig();
        String[] ipRules = restrictionCfg.getBasicAuthIpStrictUnblockedList();
        ArrayList<String> ipRulesNew = new ArrayList<String>(Arrays.asList(ipRules));
        ipRulesNew.remove(ipRule);
        this.settings.put(KEYS.BASIC_AUTH_IP_STRICT_UNBLOCKEDLIST.key, (Object)ListParseUtils.iterableToCommaSeparatedString(ipRulesNew));
        this.oneMinuteCache.invalidateAll();
    }

    public void setBasicAuthIpOpenUnblockedList(java.util.List<String> unblockedlist) {
        this.settings.put(KEYS.BASIC_AUTH_IP_OPEN_UNBLOCKEDLIST.key, (Object)ListParseUtils.iterableToCommaSeparatedString(unblockedlist));
        this.oneMinuteCache.invalidateAll();
    }

    public void removeBasicAuthIpOpenUnblockedList(String ipRule) {
        IpRestrictionConfig restrictionCfg = this.getIpRestrictionConfig();
        String[] ipRules = restrictionCfg.getBasicAuthIpOpenUnblockedList();
        ArrayList<String> ipRulesNew = new ArrayList<String>(Arrays.asList(ipRules));
        ipRulesNew.remove(ipRule);
        this.settings.put(KEYS.BASIC_AUTH_IP_OPEN_UNBLOCKEDLIST.key, (Object)ListParseUtils.iterableToCommaSeparatedString(ipRulesNew));
        this.oneMinuteCache.invalidateAll();
    }

    public void setBasicAuthIpRestrictionType(IpRestrictionType ipRestrictionType) {
        this.settings.put(KEYS.BASIC_AUTH_IP_RESTRICTION_TYPE.key, (Object)ipRestrictionType.key);
        this.oneMinuteCache.invalidateAll();
    }

    public long getApiTokensUserMaxTimeRestriction() {
        Try<Long> maybeRestriction = ApiTokenUtil.Validation.tryParseTokenTimeLimit((String)this.settings.get(KEYS.API_TOKEN_USER_MAX_TIME_RESTRICTION.key));
        return (Long)maybeRestriction.getOrElse((Object)-1L);
    }

    public void setApiTokensUserMaxTimeRestriction(String maxAllowedTime) {
        Try<Long> maxAllowed = ApiTokenUtil.Validation.tryParseTokenTimeLimit(maxAllowedTime);
        if (maxAllowed.isSuccess()) {
            this.settings.put(KEYS.API_TOKEN_USER_MAX_TIME_RESTRICTION.key, (Object)((Long)maxAllowed.get()).toString());
        }
    }

    public JSONArray getApiTokensGroupsTimeRestriction() {
        String apiTokensAGroupsTimeRestriction = (String)this.settings.get(String.valueOf(KEYS.API_TOKEN_GROUP_TIME_RESTRICTIONS.key));
        if (apiTokensAGroupsTimeRestriction != null) {
            return new JSONArray(apiTokensAGroupsTimeRestriction);
        }
        return new JSONArray();
    }

    public void setApiTokensGroupTimeRestriction(String userGroupName, String maxAllowedTime, boolean isCustomTime) {
        JSONArray originalTimeRestrictions = this.getApiTokensGroupsTimeRestriction();
        Try<Long> maxAllowed = ApiTokenUtil.Validation.tryParseTokenTimeLimit(maxAllowedTime);
        if (maxAllowed.isSuccess()) {
            JSONObject newObject = new JSONObject();
            newObject.put("groupName", (Object)userGroupName);
            newObject.put("maxAllowed", maxAllowed.get());
            newObject.put("isCustomTime", isCustomTime);
            originalTimeRestrictions.put((Object)newObject);
            this.settings.put(KEYS.API_TOKEN_GROUP_TIME_RESTRICTIONS.key, (Object)originalTimeRestrictions.toString());
        }
    }

    public void removeApiTokenGroupTimeRestriction(String userGroupName) {
        JSONArray originalTimeRestrictions = this.getApiTokensGroupsTimeRestriction();
        for (int i = originalTimeRestrictions.length() - 1; i >= 0; --i) {
            JSONObject originalTimeRestriction = originalTimeRestrictions.getJSONObject(i);
            if (!originalTimeRestriction.getString("groupName").equals(userGroupName)) continue;
            originalTimeRestrictions.remove(i);
        }
        this.settings.put(KEYS.API_TOKEN_GROUP_TIME_RESTRICTIONS.key, (Object)originalTimeRestrictions.toString());
    }

    public boolean isSSOEnabledForUserAvatar() {
        return "true".equals(this.settings.get(KEYS.SSO_ENABLED_FOR_USER_AVATAR.key));
    }

    public void setSSOEnabledForUserAvatar(boolean isSSOEnabledForUserAvatar) {
        this.settings.put(KEYS.SSO_ENABLED_FOR_USER_AVATAR.key, (Object)Boolean.toString(isSSOEnabledForUserAvatar));
    }

    public boolean isUserAgentEnabled(String userAgent) {
        return this.isUserAgentEnabled(userAgent, this.getDisabledUserAgents());
    }

    public boolean isUserAgentEnabledByCustomList(String userAgent) {
        return this.isUserAgentEnabled(userAgent, this.getCustomDisabledUserAgents());
    }

    public boolean isUserAgentEnabledByDefaultList(String userAgent) {
        return this.isUserAgentEnabled(userAgent, new HashSet<String>(Arrays.asList(defaultDisabledUserAgents)));
    }

    private boolean isUserAgentEnabled(String userAgent, Set<String> listOfDisabledUserAgentNames) {
        if (userAgent == null) {
            return false;
        }
        if (listOfDisabledUserAgentNames != null) {
            for (String disabledUserAgent : listOfDisabledUserAgentNames) {
                if (!userAgent.contains(disabledUserAgent)) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized void setKeytabContent(byte[] bytes) {
        File keytabFile = this.getUploadedKeytabFile();
        if (keytabFile.getParentFile().mkdirs()) {
            this.log.debug("Created new file for keytab content");
        }
        try {
            FileUtils.writeByteArrayToFile((File)keytabFile, (byte[])bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.settings.put(KEYS.KEYTAB_UPLOADED.key, (Object)"true");
        this.settings.remove(KEYS.KEYTAB_FILE.key);
        this.settings.remove(KEYS.PRINCIPAL.key);
        this.flushKeytabCaches();
    }

    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    public void resetConfiguration() {
        PluginSettings theSettings = this.settings;
        for (KEYS key : KEYS.values()) {
            this.settings.remove(key.key);
        }
    }

    private File getUploadedKeytabFile() {
        return new File(this.homeDirectoryResolver.getHomeDirectory(), keytabFileName);
    }

    public boolean isJsmInstalled() {
        if ("JIRA".equals(this.applicationProperties.getDisplayName())) {
            for (Plugin plugin : this.pluginAccessor.getPlugins()) {
                String key = plugin.getKey();
                if (key == null || !key.startsWith("com.atlassian.servicedesk")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isKerberosJsmEnabled() {
        Object kerberosJsmEnabled = this.settings.get(KEYS.KERBEROS_JSM_ENABLED.key);
        return "true".equals(kerberosJsmEnabled) || kerberosJsmEnabled == null;
    }

    public void setKerberosJsmEnabled(boolean kerberosJsmEnabled) {
        this.settings.put(KEYS.KERBEROS_JSM_ENABLED.key, (Object)Boolean.toString(kerberosJsmEnabled));
    }

    public boolean isKerberosKnowledgeBaseEnabled() {
        Object kerberosKnowledgeBaseEnabled = this.settings.get(KEYS.KERBEROS_KNOWLEDGEBASE_ENABLED.key);
        return "true".equals(kerberosKnowledgeBaseEnabled) || kerberosKnowledgeBaseEnabled == null;
    }

    public void setKerberosKnowledgeBaseEnabled(boolean kerberosKnowledgeBaseEnabled) {
        this.settings.put(KEYS.KERBEROS_KNOWLEDGEBASE_ENABLED.key, (Object)Boolean.toString(kerberosKnowledgeBaseEnabled));
    }

    public Option<String> getSavedHostappBaseUrl() {
        return Option.of((Object)((String)this.settings.get(KEYS.SAVED_HOSTAPP_SERVER_BASE_URL.key))).filter(StringUtils::isNotBlank);
    }

    public Option<String> getHostappBaseUrlChanged() {
        return Option.of((Object)((String)this.settings.get(KEYS.CHANGED_HOSTAPP_SERVER_BASE_URL.key))).filter(StringUtils::isNotBlank);
    }

    public void removeHostappBaseUrlChanged() {
        this.settings.remove(KEYS.CHANGED_HOSTAPP_SERVER_BASE_URL.key);
    }

    public void setHostappBaseUrlChanged(String hostappBaseUrl) {
        this.settings.put(KEYS.CHANGED_HOSTAPP_SERVER_BASE_URL.key, (Object)hostappBaseUrl);
    }

    public void setSavedHostappBaseUrl(String hostappBaseUrl) {
        this.settings.put(KEYS.SAVED_HOSTAPP_SERVER_BASE_URL.key, (Object)hostappBaseUrl);
    }

    public Option<Version> getSavedKssoConfigVersion() {
        return Option.of((Object)((String)this.settings.get(KEYS.KSSO_CONFIG_VERSION.key))).map(Version::new);
    }

    public static Version getRunningKssoVersion() {
        return Version.of((String)KerbConfManager.getBuildInfo().getProperty("build.version"));
    }

    public void setKssoConfigVersion(Version version) {
        if (version != null && StringUtils.isNotBlank((CharSequence)version.stringValue)) {
            this.log.debug("Setting KSSO config version from {} to {}", this.getSavedKssoConfigVersion().map(Version::stringValue).getOrElse((Object)"<unknown>"), (Object)version.stringValue);
            this.settings.put(KEYS.KSSO_CONFIG_VERSION.key, (Object)version.stringValue);
        }
    }

    public void darkFeatureRemoveKssoConfigVersion() {
        this.log.debug("Dark feature: remove the KSSO config version {} ", this.getSavedKssoConfigVersion().map(Version::stringValue).getOrElse((Object)"<unknown>"));
        this.settings.remove(KEYS.KSSO_CONFIG_VERSION.key);
    }

    public void upgradeKssoVersionInConfig() {
        this.setKssoConfigVersion(KerbConfManager.getRunningKssoVersion());
    }

    public boolean isAnySettingsConfigured() {
        return List.of((Object[])KEYS.values()).exists(key -> Option.of((Object)this.settings.get(key.key)).isDefined());
    }

    public boolean hasKerberosFolder() {
        return Files.exists(this.getHomeDirectoryResolver().getHomeDirectory().toPath(), new LinkOption[0]);
    }

    public boolean isUserdetailsInCommentsEnabled() {
        Object kerberosKnowledgeBaseEnabled = this.settings.get(KEYS.USER_DETAILS_IN_COMMENTS_ENABLED.key);
        return "true".equals(kerberosKnowledgeBaseEnabled);
    }

    public void setUserdetailsInCommentsEnabled(boolean userdetailsInComments) {
        this.settings.put(KEYS.USER_DETAILS_IN_COMMENTS_ENABLED.key, (Object)Boolean.toString(userdetailsInComments));
    }

    public Set<String> getAllowTraditionalLoginGroups() {
        try {
            String loginGroups = (String)this.oneMinuteCache.get((Object)"getAllowTraditionalLoginGroups", () -> Option.of((Object)this.settings.get(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key)).getOrElse((Object)""));
            return ListParseUtils.parseSetFromCommaSeparated((String)loginGroups);
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking getAllowTraditionalLoginGroups status", e.getCause());
            return new HashSet<String>();
        }
    }

    public void setAllowTraditionalLoginGroups(Set<String> groups) {
        this.settings.put(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void addAllowTraditionalLoginGroups(String group) {
        Set<String> groups = this.getAllowTraditionalLoginGroups();
        groups.add(group);
        this.settings.put(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void removeAllowTraditionalLoginGroups(String group) {
        Set<String> groups = this.getAllowTraditionalLoginGroups();
        groups.remove(group);
        this.settings.put(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public Set<String> emptyAllowTraditionalLoginGroups() {
        Set<String> groups = this.getAllowTraditionalLoginGroups();
        this.settings.remove(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key);
        this.oneMinuteCache.invalidateAll();
        return groups;
    }

    public Set<String> getAllowKerberosLoginGroups() {
        return ListParseUtils.parseSetFromCommaSeparated((String)((String)this.settings.get(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key)));
    }

    public void setAllowKerberosLoginGroups(Set<String> groups) {
        this.settings.put(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
    }

    public void removeAllowKerberosLoginGroups(String group) {
        Set<String> groups = this.getAllowKerberosLoginGroups();
        groups.remove(group);
        this.settings.put(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
    }

    public Set<String> emptyAllowKerberosLoginGroups() {
        Set<String> groups = this.getAllowKerberosLoginGroups();
        this.settings.remove(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key);
        return groups;
    }

    public Set<String> getDisallowTraditionalLoginGroups() {
        try {
            String loginGroups = (String)this.oneMinuteCache.get((Object)"getDisallowTraditionalLoginGroups", () -> Option.of((Object)this.settings.get(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key)).getOrElse((Object)""));
            return ListParseUtils.parseSetFromCommaSeparated((String)loginGroups);
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking getAllowTraditionalLoginGroups status", e.getCause());
            return new HashSet<String>();
        }
    }

    public Set<String> getDisallowKerberosLoginGroups() {
        return ListParseUtils.parseSetFromCommaSeparated((String)((String)this.settings.get(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key)));
    }

    public void setDisallowKerberosLoginGroups(Set<String> groups) {
        this.settings.put(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
    }

    public void removeDisallowKerberosLoginGroups(String group) {
        Set<String> groups = this.getDisallowKerberosLoginGroups();
        groups.remove(group);
        this.settings.put(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
    }

    public Set<String> emptyDisallowKerberosLoginGroups() {
        Set<String> urls = this.getDisallowKerberosLoginGroups();
        this.settings.remove(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key);
        return urls;
    }

    public void setDisallowTraditionalLoginGroups(Set<String> groups) {
        this.settings.put(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void addDisallowTraditionalLoginGroups(String group) {
        Set<String> groups = this.getDisallowTraditionalLoginGroups();
        groups.add(group);
        this.settings.put(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void removeDisallowTraditionalLoginGroups(String group) {
        Set<String> groups = this.getDisallowTraditionalLoginGroups();
        groups.remove(group);
        this.settings.put(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public Set<String> emptyDisallowTraditionalLoginGroups() {
        Set<String> urls = this.getDisallowTraditionalLoginGroups();
        this.settings.remove(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key);
        this.oneMinuteCache.invalidateAll();
        return urls;
    }

    public Set<String> getAllowBasicAuthGroups() {
        try {
            String loginGroups = (String)this.oneMinuteCache.get((Object)"getAllowBasicAuthGroups", () -> Option.of((Object)this.settings.get(KEYS.ALLOW_BASIC_AUTH_GROUPS.key)).getOrElse((Object)""));
            return ListParseUtils.parseSetFromCommaSeparated((String)loginGroups);
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking getAllowBasicAuthGroups status", e.getCause());
            return new HashSet<String>();
        }
    }

    public void setAllowBasicAuthGroups(Set<String> groups) {
        this.settings.put(KEYS.ALLOW_BASIC_AUTH_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void removeAllowBasicAuthGroups(String group) {
        Set<String> groups = this.getAllowBasicAuthGroups();
        groups.remove(group);
        this.settings.put(KEYS.ALLOW_BASIC_AUTH_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public Set<String> emptyAllowBasicAuthGroups() {
        Set<String> groups = this.getAllowBasicAuthGroups();
        this.settings.remove(KEYS.ALLOW_BASIC_AUTH_GROUPS.key);
        this.oneMinuteCache.invalidateAll();
        return groups;
    }

    public Set<String> getDisallowBasicAuthGroups() {
        try {
            String groups = (String)this.oneMinuteCache.get((Object)"getDisallowBasicAuthGroups", () -> Option.of((Object)this.settings.get(KEYS.DISALLOW_BASIC_AUTH_GROUPS.key)).getOrElse((Object)""));
            return ListParseUtils.parseSetFromCommaSeparated((String)groups);
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking getDisallowBasicAuthGroups status", e.getCause());
            return new HashSet<String>();
        }
    }

    public void setDisallowBasicAuthGroups(Set<String> groups) {
        this.settings.put(KEYS.DISALLOW_BASIC_AUTH_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void removeDisallowBasicAuthGroups(String group) {
        Set<String> groups = this.getDisallowBasicAuthGroups();
        groups.remove(group);
        this.settings.put(KEYS.DISALLOW_BASIC_AUTH_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public Set<String> emptyDisallowBasicAuthGroups() {
        Set<String> groups = this.getDisallowBasicAuthGroups();
        this.settings.remove(KEYS.DISALLOW_BASIC_AUTH_GROUPS.key);
        this.oneMinuteCache.invalidateAll();
        return groups;
    }

    public Set<String> getApiTokenAccessUrls() {
        return ListParseUtils.parseSetFromCommaSeparated((String)((String)this.settings.get(KEYS.API_TOKEN_ACCESS_URLS.key)));
    }

    public void addApiTokenAccessUrls(String url) {
        Set<String> urls = this.getApiTokenAccessUrls();
        urls.add(url);
        this.settings.put(KEYS.API_TOKEN_ACCESS_URLS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public void removeApiTokenAccessUrls(String url) {
        Set<String> urls = this.getApiTokenAccessUrls();
        urls.remove(url);
        url = url.replaceAll("\\?", "\ufffd");
        urls.remove(url);
        this.settings.put(KEYS.API_TOKEN_ACCESS_URLS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public Set<String> getForcedSsoUrls() {
        return ListParseUtils.parseSetFromCommaSeparated((String)((String)this.settings.get(KEYS.FORCED_SSO_URLS.key)));
    }

    public void addForcedSsoUrls(String url) {
        Set<String> urls = this.getForcedSsoUrls();
        urls.add(url);
        this.settings.put(KEYS.FORCED_SSO_URLS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public void removeForcedSsoUrls(String url) {
        Set<String> urls = this.getForcedSsoUrls();
        urls.remove(url);
        this.settings.put(KEYS.FORCED_SSO_URLS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public boolean isMsTeamsAuthenticationEnabled() {
        Object msTeamsAuthenticationEnabled = this.settings.get(KEYS.MS_TEAMS_AUTHENTICATION_ENABLED.key);
        return "true".equals(msTeamsAuthenticationEnabled);
    }

    public void setMsTeamsAuthenticationEnabled(boolean msTeamsAuthenticationEnabled) {
        this.settings.put(KEYS.MS_TEAMS_AUTHENTICATION_ENABLED.key, (Object)Boolean.toString(msTeamsAuthenticationEnabled));
    }

    public boolean isMsTeamsSecurityHeadersEnabled() {
        Object msTeamsSecurityHeadersEnabled = this.settings.get(KEYS.MS_TEAMS_SECURITY_HEADERS_ENABLED.key);
        return "true".equals(msTeamsSecurityHeadersEnabled);
    }

    public void setMsTeamsSecurityHeadersEnabled(boolean msTeamsSecurityHeadersEnabled) {
        this.settings.put(KEYS.MS_TEAMS_SECURITY_HEADERS_ENABLED.key, (Object)Boolean.toString(msTeamsSecurityHeadersEnabled));
    }

    public String getMsTeamsClientId() {
        return (String)this.settings.get(KEYS.MS_TEAMS_CLIENT_ID.key);
    }

    public void setMsTeamsClientId(String msTeamsClientId) {
        if (msTeamsClientId != null && msTeamsClientId.isEmpty()) {
            msTeamsClientId = null;
        }
        this.settings.put(KEYS.MS_TEAMS_CLIENT_ID.key, (Object)msTeamsClientId);
        this.oneMinuteCache.invalidateAll();
    }

    public String getMsTeamsSecret() {
        return (String)this.settings.get(KEYS.MS_TEAMS_SECRET.key);
    }

    public void setMsTeamsSecret(String msTeamsSecret) {
        if (msTeamsSecret != null && msTeamsSecret.isEmpty()) {
            msTeamsSecret = null;
        }
        this.settings.put(KEYS.MS_TEAMS_SECRET.key, (Object)msTeamsSecret);
        this.oneMinuteCache.invalidateAll();
    }

    public Set<String> getSecurityHeaderAllowedHostNames() {
        return ListParseUtils.parseSetFromCommaSeparated((String)((String)this.settings.get(KEYS.SECURITY_HEADER_ALLOWED_HOST_NAMES.key)));
    }

    public void removeSecurityHeaderAllowedHostNames(String url) {
        Set<String> urls = this.getSecurityHeaderAllowedHostNames();
        urls.remove(url);
        this.settings.put(KEYS.SECURITY_HEADER_ALLOWED_HOST_NAMES.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public void addSecurityHeaderAllowedHostNames(String url) {
        Set<String> urls = this.getSecurityHeaderAllowedHostNames();
        urls.add(url);
        this.settings.put(KEYS.SECURITY_HEADER_ALLOWED_HOST_NAMES.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public Set<String> getContentSecurityPolicyHostNames() {
        return ListParseUtils.parseSetFromCommaSeparated((String)((String)this.settings.get(KEYS.CONTENT_SECURITY_POLICY_HOST_NAMES.key)));
    }

    public void removeContentSecurityPolicyHostNames(String url) {
        Set<String> urls = this.getContentSecurityPolicyHostNames();
        urls.remove(url);
        this.settings.put(KEYS.CONTENT_SECURITY_POLICY_HOST_NAMES.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public void addContentSecurityPolicyHostNames(String url) {
        Set<String> urls = this.getContentSecurityPolicyHostNames();
        urls.add(url);
        this.settings.put(KEYS.CONTENT_SECURITY_POLICY_HOST_NAMES.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public void setSameSiteCookiePolicy(SameSiteCookiePolicy sameSiteCookiePolicy) {
        this.settings.put(KEYS.SAMESITE_COOKIE_POLICY.key, (Object)sameSiteCookiePolicy.value);
    }

    public SameSiteCookiePolicy getSameSiteCookiePolicy() {
        Object savedValue = this.settings.get(KEYS.SAMESITE_COOKIE_POLICY.key);
        return SameSiteCookiePolicy.parse(savedValue);
    }

    public HomeDirectoryResolver getHomeDirectoryResolver() {
        return this.homeDirectoryResolver;
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        JSONArray installedPlugins = new JSONArray((Collection)this.pluginAccessor.getPlugins().stream().filter(arg_0 -> ((PluginMetadataManager)this.pluginMetadataManager).isUserInstalled(arg_0)).filter(plugin -> !List.of((Object[])new String[]{"Atlassian", "Atlassian Community", "Atlassian Software Systems", "Atlassian Software Systems Pty Ltd", "OSGi Alliance", "The Apache Software Foundation"}).contains((Object)plugin.getPluginInformation().getVendorName())).map(plugin -> new JSONObject((Map)io.vavr.collection.HashMap.of((Object)"key", (Object)plugin.getKey(), (Object)"name", (Object)plugin.getName(), (Object)"version", (Object)plugin.getPluginInformation().getVersion(), (Object)"vendor", (Object)plugin.getPluginInformation().getVendorName(), (Object)"pluginState", (Object)plugin.getPluginState()).toJavaMap())).collect(Collectors.toList()));
        JSONObject statsJson = new JSONObject();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        statsJson.put("attempts", this.stats.getAttempts());
        statsJson.put("authFailed", this.stats.getAuthFailed());
        statsJson.put("failedDecodingToken", this.stats.getFailedDecodingToken());
        statsJson.put("failedParsingToken", this.stats.getFailedParsingToken());
        statsJson.put("kerberosLockout", (Object)this.stats.getKerberosLockout());
        statsJson.put("lacksPermission", this.stats.getLacksPermission());
        statsJson.put("lacksRequiredGroup", this.stats.getLacksRequiredGroup());
        statsJson.put("missingUsers", this.stats.getMissingUsers());
        statsJson.put("since", (Object)dateFormat.format(this.stats.getSince().getTime()));
        statsJson.put("successes", this.stats.getSuccesses());
        statsJson.put("wrongTokenBasic", this.stats.getWrongTokenBasic());
        statsJson.put("wrongTokenNotKerberos", this.stats.getWrongTokenNotKerberos());
        statsJson.put("wrongTokenNotNegotiate", this.stats.getWrongTokenNotNegotiate());
        statsJson.put("wrongTokenNtlm", this.stats.getWrongTokenNtlm());
        JSONObject settingsJson = new JSONObject();
        Try.run(() -> List.of((Object[])KEYS.values()).forEach(key -> settingsJson.put(key.name(), this.settings.get(key.key)))).onFailure(throwable -> this.log.debug("Could not provide settings for json: ", throwable));
        settingsJson.put("isTraditionalLoginPrevented", this.isTraditionalLoginPrevented());
        settingsJson.put("isTraditionalLoginJsmPrevented", this.isTraditionalLoginJsmPrevented());
        settingsJson.put("isBasicAuthPreventedByFileExisting", this.isBasicAuthPreventedByFileExisting());
        settingsJson.put("basicAuthPermissionType", (Object)this.getBasicAuthPermissionType());
        settingsJson.put("basicAuthPermissionSomeUsersConfig", (Object)this.getBasicAuthPermissionSomeUsersConfig());
        settingsJson.put("isCsrfOriginCheckEnabled", this.isCsrfOriginCheckEnabled());
        json.put("stats", (Object)statsJson);
        json.put("license", (Object)this.licenseManagerWrapper.asJson());
        json.put("installedPlugins", (Object)installedPlugins);
        json.put("settings", (Object)settingsJson);
        return json;
    }

    public void setSendToDashboardAfterLogin(boolean sendToDashboardAfterLogin) {
        this.settings.put(KEYS.SEND_TO_DASHBOARD_AFTER_LOGIN.key, (Object)Boolean.toString(sendToDashboardAfterLogin));
    }

    public boolean isSendToDashboardAfterLogin() {
        Object sendToDashboardAfterLogin = this.settings.get(KEYS.SEND_TO_DASHBOARD_AFTER_LOGIN.key);
        return !"false".equals(sendToDashboardAfterLogin);
    }

    public void setShouldHideUsernameField(boolean instantlyRedirectBasedOnRememberedUsername) {
        this.settings.put(KEYS.SHOULD_HIDE_USERNAME_FIELD.key, (Object)Boolean.toString(instantlyRedirectBasedOnRememberedUsername));
    }

    public boolean shouldHideUsernameField() {
        Object isInstantlyRedirectBasedOnRememberedUsername = this.settings.get(KEYS.SHOULD_HIDE_USERNAME_FIELD.key);
        return "true".equals(isInstantlyRedirectBasedOnRememberedUsername);
    }

    public String[] getDefaultDisabledUserAgents() {
        return defaultDisabledUserAgents;
    }

    public JSONArray getGroupAddMapping() {
        String groupAddMapping = (String)this.settings.get(KEYS.GROUP_ADD_MAPPING.key);
        if (groupAddMapping != null) {
            return new JSONArray(groupAddMapping);
        }
        return new JSONArray();
    }

    public void removeGroupAddMapping(String requiredGroup, String addedGroup) {
        JSONArray currentArray = this.getGroupAddMapping();
        JSONArray updatedArray = new JSONArray();
        for (int i = 0; i < currentArray.length(); ++i) {
            JSONObject obj = currentArray.getJSONObject(i);
            if (requiredGroup.equals(obj.getString("requiredGroup")) && addedGroup.equals(obj.getString("addedGroup"))) continue;
            updatedArray.put((Object)obj);
        }
        this.settings.put(KEYS.GROUP_ADD_MAPPING.key, (Object)updatedArray.toString());
    }

    public void addGroupAddMapping(String requiredGroup, String addedGroup) {
        this.removeGroupAddMapping(requiredGroup, addedGroup);
        JSONObject newGroupAddMapping = new JSONObject().put("requiredGroup", (Object)requiredGroup).put("addedGroup", (Object)addedGroup);
        this.settings.put(KEYS.GROUP_ADD_MAPPING.key, (Object)this.getGroupAddMapping().put((Object)newGroupAddMapping).toString());
    }

    public String getLdapPasswordEncryptionKey() {
        String encryptionKey = (String)this.settings.get(KEYS.LDAP_PASSWORD_ENCRYPTION_KEY.key);
        if (StringUtils.isBlank((CharSequence)encryptionKey)) {
            encryptionKey = this.generateSecureRandomKey();
        }
        this.settings.put(KEYS.LDAP_PASSWORD_ENCRYPTION_KEY.key, (Object)encryptionKey);
        return encryptionKey;
    }

    public JSONArray getPasswordLoginGroupAddMapping() {
        String groupAddMapping = (String)this.settings.get(KEYS.PASSWORD_LOGIN_GROUP_ADD_MAPPING.key);
        if (groupAddMapping != null) {
            return new JSONArray(groupAddMapping);
        }
        return new JSONArray();
    }

    public void removePasswordLoginGroupAddMapping(String requiredGroup, String addedGroup) {
        JSONArray currentArray = this.getPasswordLoginGroupAddMapping();
        JSONArray updatedArray = new JSONArray();
        for (int i = 0; i < currentArray.length(); ++i) {
            JSONObject obj = currentArray.getJSONObject(i);
            if (requiredGroup.equals(obj.getString("requiredGroup")) && addedGroup.equals(obj.getString("addedGroup"))) continue;
            updatedArray.put((Object)obj);
        }
        this.settings.put(KEYS.PASSWORD_LOGIN_GROUP_ADD_MAPPING.key, (Object)updatedArray.toString());
    }

    public void addPasswordGroupAddMapping(String requiredGroup, String addedGroup) {
        this.removePasswordLoginGroupAddMapping(requiredGroup, addedGroup);
        JSONObject newGroupAddMapping = new JSONObject().put("requiredGroup", (Object)requiredGroup).put("addedGroup", (Object)addedGroup);
        this.settings.put(KEYS.PASSWORD_LOGIN_GROUP_ADD_MAPPING.key, (Object)this.getPasswordLoginGroupAddMapping().put((Object)newGroupAddMapping).toString());
    }

    static {
        configSubsetFileNames.put(ConfigNameSpaces.ConfigSubset.COMMON, commonSettingsFileNames);
        configSubsetFileNames.put(ConfigNameSpaces.ConfigSubset.KERBEROS, kerberosSettingsFileNames);
        configSubsetFileNames.put(ConfigNameSpaces.ConfigSubset.USER_CLEANUP, usercleanupSettingsFilePaths);
        defaultDisabledUserAgents = Arrays.asList("HttpClient", "Java/", "JIRA-", "JIRA/", "Bitbucket-", "Confluence-", "Confluence/", "FishEye-", "Bamboo-", "Axis/", "Monitoring Agent", "BB10", "BlackBerry", "AtlassianMobileApp", "AtlassianCompanion", "GoEdit").toArray(new String[0]);
    }

    public static enum KEYS {
        USE_LEGACY_KERBEROS("usingLegacyKerberos"),
        ADDITIONAL_USER_SUFFIX("additionalUserSuffix"),
        BASIC_AUTH_PERMISSION_TYPE("basicAuthPermissionType"),
        BASIC_AUTH_PERMISSION_SOME_USERS_CONFIG("basicAuthPermissionSomeUsersConfig"),
        BASIC_AUTH_PERMISSION_GROUP("basicAuthPermissionGroup"),
        LEGACY_REGEX_LOOKUP("regexLookup"),
        LEGACY_REGEX_REPLACEMENT("regexReplacement"),
        KERBEROS_MULTI_REGEX("kerberosMultiRegex"),
        REGEX_LOOKUP_ENABLED("regexLookupEnabled"),
        ONLY_REGEX_TRANSFORMATION_LOOKUP("onlyRegexTransformationLookup"),
        LOOKUP_USERNAME_FROM_MAPPING_FILE("lookupUsernameFromMappingFile"),
        CROWD_AUTO_ADD_GROUPS("crowdAutoAddGroups"),
        LEGACY_GLOBAL_IP_BLOCKEDLIST("ipblacklist"),
        LEGACY_GLOBAL_IP_UNBLOCKEDLIST("ipwhitelist"),
        GLOBAL_IP_BLOCKEDLIST("version5ipBlockedlist"),
        GLOBAL_IP_UNBLOCKEDLIST("version5ipUnblockedlist"),
        GLOBAL_IP_RESTRICTION_TYPE("iprestrictiontype"),
        LEGACY_REST_IP_BLOCKEDLIST("restipblacklist"),
        LEGACY_REST_IP_UNBLOCKEDLIST("restipwhitelist"),
        REST_IP_BLOCKEDLIST("version5restIpBlockedlist"),
        REST_IP_UNBLOCKEDLIST("version5restIpUnblockedlist"),
        REST_IP_RESTRICTION_TYPE("restiprestrictiontype"),
        CUSTOM_DISABLED_USER_AGENTS("customDisabledUserAgents"),
        IDP_DISABLED_USER_AGENTS("idpDisabledUserAgents"),
        KEYTAB_FILE("keytabFile"),
        PREEMPTIVE_AUTH_EXCLUDED_PATHS("preemptiveAuthExcludedPaths"),
        REST_EXCLUDED_PATHS("RestExcludedPaths"),
        VALID_USER_GROUPS("ValidUserGroups"),
        PREFERRED_PROXY_HEADER("preferredproxyheader"),
        PRINCIPAL("principal"),
        REQUIRED_GROUP("requiredGroup"),
        BITBUCKET_SCM_URLS_DEFAULT("bitbucketScmUrlsDefault"),
        BITBUCKET_SCM_URLS_ENABLED("bitbucketScmUrlsEnabled"),
        BITBUCKET_KERBEROS_SCM_URLS_ENABLED("bitbucketKerberosScmUrlsEnabled"),
        BITBUCKET_SCM_URL_TYPES("bitbucketScmUrlTypes"),
        FAILURE_COLLECTION("failurecollection"),
        KERBEROS_ENABLED("kerberosEnabled"),
        KERBEROS_USER_PERMISSION("kerberosUserPermission"),
        KERBEROS_USER_PERMISSION_SOME("kerberosUserPermissionSome"),
        KERBEROS_USER_PERMISSION_GROUP("kerberosUserPermissionGroup"),
        KEYTAB_UPLOADED("uploaded"),
        MANUAL_LOGIN_LOG_ENABLED("manualLoginLogEnabled"),
        REQUIRE_LOGIN_ENABLED("preemptiveAuthEnabled"),
        SEND_TO_LOGIN_ENABLED("sendToLoginEnabled"),
        JIRA_REST_AUTH_ENABLED("jiraRestAuthEnabled"),
        KERBEROS_JSM_ENABLED("jiraKerberosJsmEnabled"),
        KERBEROS_KNOWLEDGEBASE_ENABLED("jiraKerberosKnowledgeBaseEnabled"),
        REST_AUTH_ENABLED("restAuthEnabled"),
        KERBEROS_REST_FROM_BROWSER_ENABLED("kerberosRestRequestFromBrowserEnabled"),
        USERNAME_ATTR_LOOKUP_ENABLED("userNameAttributeLookupEnabled"),
        USER_PRINCIPAL_ATTR_LOOKUP_ENABLED("userPrincipalNameLookupEnabled"),
        WEBDAV_ENABLED("webdavEnabled"),
        SHOW_WELCOME_MESSAGE("showWelcomeMessage"),
        ERROR_PAGE_MESSAGE("errorPageMessage"),
        TRADITIONAL_LOGIN_DISABLED_MESSAGE("traditionalLoginDisabledMessage"),
        JSM_CUSTOM_INFO_BOX_CONTENT("jsmTraditionalLoginDisabledMessage"),
        ALL_TRADITIONAL_LOGIN_DISABLED_MESSAGE("allTraditionalLoginDisabledMessage"),
        SHOW_INFO_BOX_ON_JSM_LOGIN("showInfoBoxOnJsmLogin"),
        BASIC_AUTH_IP_RESTRICTION_TYPE("basicAuthIpRestrictionType"),
        BASIC_AUTH_IP_BLOCKEDLIST("version5BasicAuthIpBlockedList"),
        BASIC_AUTH_IP_UNBLOCKEDLIST("version5BasicAuthnIpUnblockedList"),
        BASIC_AUTH_IP_STRICT_BLOCKEDLIST("BasicAuthIpStrictBlockedList"),
        BASIC_AUTH_IP_STRICT_UNBLOCKEDLIST("BasicAuthIpStrictUnblockedList"),
        BASIC_AUTH_IP_OPEN_BLOCKEDLIST("BasicAuthIpOpenBlockedList"),
        BASIC_AUTH_IP_OPEN_UNBLOCKEDLIST("BasicAuthnIpOpenUnblockedList"),
        ALLOW_TRADITIONAL_LOGIN_GROUPS("allowTraditionalLoginGroups"),
        DISALLOW_TRADITIONAL_LOGIN_GROUPS("disallowTraditionalLoginGroups"),
        ALLOW_BASIC_AUTH_GROUPS("allowBasicAuthGroups"),
        DISALLOW_BASIC_AUTH_GROUPS("disallowBasicAuthGroups"),
        SAML_LOGIN_USERNAME_PLACEHOLDER("samlLoginUsernamePlaceholder"),
        USERNAME_FIELD_TEXT("usernameFieldText"),
        NEXT_BUTTON_TEXT("nextButtonText"),
        IDP_LIST_TITLE_TEXT("idpListTitleText"),
        SHARED_LOGIN_TITLE("sharedLoginTitle"),
        SHARED_LOGIN_SUBTITLE("sharedLoginSubtitle"),
        SHARED_LOGIN_ALTERNATIVE_DIVIDER("sharedLoginAlternativeDivider"),
        SHARED_CANNOT_LOGIN_TEXT("sharedCannotLoginText"),
        AUTOMATIC_TRADITIONAL_LOGIN_BUTTON_TEXT("automaticTraditionalLoginButtonText"),
        MANUAL_USERNAME_LOGIN_SUBTITLE("manualUsernameLoginSubtitle"),
        MANUAL_USERNAME_PLACEHOLDER_TEXT("manualUsernamePlaceholderText"),
        MANUAL_CONTINUE_BUTTON_TEXT("manualContinueButtonText"),
        REDIRECT_REDIRECTION_TEXT("redirectRedirectionText"),
        REDIRECT_CANCEL_REDIRECT_BUTTON_TEXT("redirectCancelRedirectButtonText"),
        REDIRECT_REDIRECTION_HINT("redirectRedirectionHint"),
        ATLASSIAN_USE_SSO_BUTTON_TEXT("atlassianUseSsoButtonText"),
        LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST("headerUsernameIpWhitelist"),
        HEADER_USERNAME_IP_UNBLOCKEDLIST("version5headerUsernameIpWhitelist"),
        HEADER_USERNAME_ATTRIBUTE("headerUsernameAttribute"),
        HEADERAUTH_USE_X_FORWARDED_FOR("headerauthUseXForwardedFor"),
        HEADER_EMAIL_ATTRIBUTE("headerEmailAttribute"),
        JSM_SIGNUP_EMAIL_UNBLOCKEDLIST("jsmSignupEmailUnblockedlist"),
        JSM_SIGNUP_FORM_URLPARTS("jsmSignupFormUrlparts"),
        REMEMBERME_COOKIE_ENABLED("remembermeCookieEnabled"),
        API_TOKENS_ENABLED("apiTokensEnabled"),
        API_TOKENS_ADDITIONAL_BEARER_KEY("apiTokensAdditionalBearerKey"),
        USER_API_TOKEN_ENABLED("userApiTokenEnabled"),
        API_TOKEN_USER_PERMISSION("apiTokenUserPermission"),
        API_TOKEN_ALLOWED_USER_GROUPS("apiTokenAllowedUserGroups"),
        LEGACY_API_TOKEN_IP_BLOCKEDLIST("apiTokenIpBlacklist"),
        LEGACY_API_TOKEN_IP_UNBLOCKEDLIST("apiTokenIpWhitelist"),
        API_TOKEN_IP_BLOCKEDLIST("version5ApiTokenIpBlockedList"),
        API_TOKEN_IP_UNBLOCKEDLIST("version5ApiTokenIpUnblockedList"),
        API_TOKEN_IP_RESTRICTION_TYPE("apiTokenIpRestrictionType"),
        API_TOKEN_USER_MAX_TIME_RESTRICTION("apiTokensUserMaxTimeRestriction"),
        API_TOKEN_GROUP_TIME_RESTRICTIONS("apiTokenGroupsTimeRestrictions"),
        SSO_ENABLED_FOR_USER_AVATAR("SSOEnabledForUserAvatar"),
        KSSO_CONFIG_VERSION("kssoVersion"),
        SAVED_HOSTAPP_SERVER_BASE_URL("savedHostAppServerBaseUrl"),
        CHANGED_HOSTAPP_SERVER_BASE_URL("changedHostAppServerBaseUrl"),
        LOCKED_REST_API_ERROR_PAGE_MESSAGE("lockedRestApiErrorPageMessage"),
        USER_DETAILS_IN_COMMENTS_ENABLED("userdetailsInComments"),
        ALLOW_KERBEROS_LOGIN_GROUPS("allowKerberosLoginGroups"),
        DISALLOW_KERBEROS_LOGIN_GROUPS("disallowKerberosLoginGroups"),
        API_TOKEN_ACCESS_URLS("apiTokenAccessUrls"),
        FORCED_SSO_URLS("forcedSsoUrls"),
        CONFIG_UPDATE_FAILURES("upgradeFailures"),
        MS_TEAMS_AUTHENTICATION_ENABLED("msTeamsAuthenticationEnabled"),
        MS_TEAMS_SECURITY_HEADERS_ENABLED("msTeamsSecurityHeadersEnabled"),
        SECURITY_HEADER_ALLOWED_HOST_NAMES("securityHeaderAllowedHostNames"),
        CONTENT_SECURITY_POLICY_HOST_NAMES("contentSecurityPolicyHostNames"),
        SAMESITE_COOKIE_POLICY("samesiteCookiePolicy"),
        MS_TEAMS_CLIENT_ID("msTeamsClientId"),
        MS_TEAMS_SECRET("msTeamsSecret"),
        USER_CLEANUP_RULE("userCleanupRule"),
        JSM_CLEANUP_RULE("jsmCleanupRule"),
        LDAP_FILTER_ENCODING("ldapFilterEncoding"),
        LICENSE_EXPIRY_NOTIFICATIONS_SNOOZE("licenseExpiryNotificationsSnooze"),
        SEND_TO_DASHBOARD_AFTER_LOGIN("sendToDashboardAfterLogin"),
        COLLECT_LAST_USER_AGENTS_LIST_ENABLED("collectLastUserAgentsList"),
        SHOULD_HIDE_USERNAME_FIELD("shouldHideUsernameField"),
        SHOW_CUSTOM_TEXT_BOX_ON_LOGIN_PAGE("showCustomTextBoxOnLoginPage"),
        CUSTOM_TEXT_ON_LOGIN_PAGE("customTextOnLoginPage"),
        LDAP_PASSWORD_ENCRYPTION_KEY("ldapPasswordEncryptionKey"),
        GROUP_ADD_MAPPING("groupAddMapping"),
        PASSWORD_LOGIN_GROUP_ADD_MAPPING("passwordGroupAddMapping");

        public final String key;

        private KEYS(String key) {
            this.key = key;
        }

        public boolean hasAlias(String alias) {
            return this.key.equals(alias);
        }
    }

    public static enum KerberosUserPermissionType {
        ENABLE_ALL_USERS,
        ENABLE_SOME_USERS,
        DISABLE_ALL_USERS;

    }

    public static enum UserPermissionGroupDirectoryType {
        DIRECTORY,
        GROUP,
        DIRECTORY_AND_GROUP,
        DIRECTORY_OR_GROUP;

    }

    public static enum UserPermissionGroupType {
        ENABLE_USERS_IN_GROUP,
        ENABLE_USERS_NOT_IN_GROUP;

    }

    public static enum BasicAuthUserPermissionType {
        ENABLE_ALL_USERS,
        IP_ADDRESS,
        IP_ADDRESS_GROUP_DIRECTORY,
        GROUP_DIRECTORY,
        DISABLE_ALL_USERS;

    }

    public static enum IpRestrictionType {
        UNRESTRICTED("UNRESTRICTED", "UNRESTRICTED"),
        STRICT("UNBLOCKEDLIST", "WHITELIST"),
        OPEN("BLOCKEDLIST", "BLACKLIST");

        public final String key;
        private final String legacyKey;

        private IpRestrictionType(String key, String legacyKey) {
            this.key = key;
            this.legacyKey = legacyKey;
        }

        public static IpRestrictionType parseConfigValue(String value) {
            return Arrays.stream(IpRestrictionType.values()).filter(m -> m.key.equals(value) || m.legacyKey.equals(value)).findAny().orElseThrow(IllegalArgumentException::new);
        }

        public String stringValue() {
            switch (this) {
                case STRICT: {
                    return "Strict";
                }
                case OPEN: {
                    return "Open";
                }
                case UNRESTRICTED: {
                    return "Unrestricted";
                }
            }
            throw new IllegalArgumentException("Bad type");
        }
    }
}

