/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.dircopy.CopyDirectoryServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSMSignupEmailServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(CopyDirectoryServlet.class);
    private final TemplateRenderer renderer;
    private final KerbConfManager kerbConfManager;

    @Inject
    public JSMSignupEmailServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.kerbConfManager = bucket.getKerbConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.modelAndRender(req, resp);
    }

    private void modelAndRender(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "jsmSignupEmail");
        model.put("contextPath", req.getContextPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("headerEmailAttributeEnabled", this.kerbConfManager.getHeaderEmailAttribute() != null);
        model.put("emailDomainUnblockedList", this.kerbConfManager.getJsmSignupEmailUnblockedList());
        model.put("jsmUrlFormUrlparts", this.kerbConfManager.getJsmSignupFormUrlparts());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/jsmSignupEmail.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String jsmUrlFormUrlparts;
        super.doPost(req, resp);
        String emailDomainUnblockedList = req.getParameter("emailDomainUnblockedList");
        if (emailDomainUnblockedList != null) {
            this.kerbConfManager.setJsmSignupEmailUnblockedList(emailDomainUnblockedList.trim());
        }
        if ((jsmUrlFormUrlparts = req.getParameter("jsmUrlFormUrlparts")) != null) {
            this.kerbConfManager.setJsmSignupFormUrlparts(jsmUrlFormUrlparts.trim());
        }
        JSMSignupEmailServlet.sendSuccess(resp);
    }

    private static void sendSuccess(HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.getWriter().print("<html>Settings was saved</html>");
    }
}

