/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.upgrade.data.UpgradePluginSettingsEntryResult;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final Logger log = LoggerFactory.getLogger(BasicAuthServlet.class);

    @Inject
    public BasicAuthServlet(RequireAdminServletDependencyBucket bucket, @ComponentImport PluginAccessor pluginAccessor) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.buildModelAndRenderTemplate(req, resp, new HashMap<String, Object>());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        HashMap<Object, Object> basicAuthLoginIpRestrictions = new HashMap();
        if (!Objects.equals(req.getParameter("enableUsernameFromHeader"), "on")) {
            this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.DISABLE_ALL_USERS);
        } else if ("DO_NOT_USE".equals(req.getParameter("basicAuthIpRestrictionType")) && "directoryNotActivated".equals(req.getParameter("directoryChoice")) && "doNotUseGroups".equals(req.getParameter("usersInGroups"))) {
            this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.ENABLE_ALL_USERS);
        } else if ("DO_NOT_USE".equals(req.getParameter("basicAuthIpRestrictionType"))) {
            this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.GROUP_DIRECTORY);
        } else if ("directoryNotActivated".equals(req.getParameter("directoryChoice")) && "doNotUseGroups".equals(req.getParameter("usersInGroups"))) {
            this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.IP_ADDRESS);
        } else {
            this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.IP_ADDRESS_GROUP_DIRECTORY);
        }
        if (!"DO_NOT_USE".equals(req.getParameter("basicAuthIpRestrictionType"))) {
            basicAuthLoginIpRestrictions = this.setBasicAuthIpRestrictions(req);
        }
        if (!"directoryNotActivated".equals(req.getParameter("directoryChoice")) || !"doNotUseGroups".equals(req.getParameter("usersInGroups"))) {
            this.setBasicAuthDirectoryGroupRestrictions(req);
        }
        if (basicAuthLoginIpRestrictions.containsKey("basicAuthRegexFailedOpenBlockedList") || basicAuthLoginIpRestrictions.containsKey("basicAuthRegexFailedOpenUnblockedList") || basicAuthLoginIpRestrictions.containsKey("basicAuthRegexFailedStrictUnblockedList") || basicAuthLoginIpRestrictions.containsKey("basicAuthRegexFailedStrictBlockedList")) {
            this.buildModelAndRenderTemplate(req, resp, basicAuthLoginIpRestrictions);
            return;
        }
        resp.sendRedirect("basic-auth");
    }

    private boolean hasUpgradeFailures() {
        return this.kssoUpgradeManager.getUpgradeFailures().exists(upgradeConfigResult -> upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.BASIC_AUTH_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.BASIC_AUTH_IP_UNBLOCKEDLIST);
    }

    void updatePermissionGroups(HttpServletRequest req, String[] addGroups, String[] deleteGroups) {
        if ("usersInGroup".equals(req.getParameter("usersInGroups"))) {
            this.kerbConfManager.setBasicAuthPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_IN_GROUP);
            Set<String> groups = this.kerbConfManager.getAllowBasicAuthGroups();
            groups.addAll(Arrays.asList(addGroups));
            Arrays.asList(deleteGroups).forEach(groups::remove);
            this.kerbConfManager.setAllowBasicAuthGroups(groups);
        } else {
            this.kerbConfManager.setBasicAuthPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_NOT_IN_GROUP);
            Set<String> groups = this.kerbConfManager.getDisallowBasicAuthGroups();
            groups.addAll(Arrays.asList(addGroups));
            Arrays.asList(deleteGroups).forEach(groups::remove);
            this.kerbConfManager.setDisallowBasicAuthGroups(groups);
        }
    }

    void updatePermissionDirectory(HttpServletRequest req) {
        for (Directory directory : this.userLookupService.getActiveUserDirectories()) {
            String enableButton = req.getParameter("loginEnable" + directory.getId());
            try {
                ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
                HashMap<String, String> attrs = new HashMap<String, String>(directory.getAttributes());
                if ("on".equals(enableButton)) {
                    attrs.put("ksso.basic.auth.allowed", "true");
                } else {
                    attrs.put("ksso.basic.auth.allowed", "false");
                }
                builder.setAttributes(attrs);
                this.hostApp.getCrowdDirectoryService().updateDirectory(builder.toDirectory());
            }
            catch (UnsupportedOperationException u) {
                this.log.error(ErrorUtils.createErrorMessage((String)"KSSO-X7O8L3EC10", (String)("Unable to update directory " + directory.getName())), (Throwable)u);
            }
        }
    }

    private Map<String, List<String>> processIpLists(String[] savedIpRules, String[] ipRulesToRemove, String[] ipRulesToAdd) {
        ArrayList<String> newIpList = new ArrayList<String>(Arrays.asList(savedIpRules));
        if (ipRulesToRemove.length != 0) {
            newIpList.removeAll(Arrays.asList(ipRulesToRemove));
        }
        HashMap<String, List<String>> finalListAndNotValidList = new HashMap<String, List<String>>();
        if (ipRulesToAdd == null) {
            finalListAndNotValidList.put("finalList", newIpList);
            finalListAndNotValidList.put("notValidList", new ArrayList());
            return finalListAndNotValidList;
        }
        ArrayList<String> notValidIpList = new ArrayList<String>();
        for (String maybeValidString : ipRulesToAdd) {
            String normalizedString = InternetAddressUtils.softNormalizeSingleIpRestriction((String)maybeValidString);
            if (InternetAddressUtils.isValidNewPermission((String)normalizedString) && !normalizedString.isEmpty()) {
                newIpList.add(normalizedString);
                continue;
            }
            notValidIpList.add(normalizedString);
        }
        finalListAndNotValidList.put("finalList", newIpList);
        finalListAndNotValidList.put("notValidList", notValidIpList);
        return finalListAndNotValidList;
    }

    private void setBasicAuthDirectoryGroupRestrictions(HttpServletRequest req) {
        String[] addInGroups = StringUtils.split((String)req.getParameter("addInGroup"), (char)',');
        String[] removeInGroups = StringUtils.split((String)req.getParameter("removeInGroup"), (char)',');
        String[] addNotInGroups = StringUtils.split((String)req.getParameter("addNotInGroup"), (char)',');
        String[] removeNotInGroups = StringUtils.split((String)req.getParameter("removeNotInGroup"), (char)',');
        if ("directoryActivated".equals(req.getParameter("directoryChoice")) && ("usersInGroup".equals(req.getParameter("usersInGroups")) || "usersNotInGroup".equals(req.getParameter("usersInGroups")))) {
            this.updatePermissionDirectory(req);
            if ("usersInGroup".equals(req.getParameter("usersInGroups"))) {
                this.updatePermissionGroups(req, addInGroups, removeInGroups);
                if ("OR".equals(req.getParameter("criteriaLogic"))) {
                    this.kerbConfManager.setBasicAuthPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_OR_GROUP);
                } else {
                    this.kerbConfManager.setBasicAuthPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_AND_GROUP);
                }
            } else {
                this.updatePermissionGroups(req, addNotInGroups, removeNotInGroups);
                if ("OR".equals(req.getParameter("criteriaLogicDisabled"))) {
                    this.kerbConfManager.setBasicAuthPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_OR_GROUP);
                } else {
                    this.kerbConfManager.setBasicAuthPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_AND_GROUP);
                }
            }
        } else if ("directoryActivated".equals(req.getParameter("directoryChoice")) && !"usersInGroup".equals(req.getParameter("usersInGroups")) && !"usersInGroup".equals(req.getParameter("usersNotInGroups"))) {
            this.kerbConfManager.setBasicAuthPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY);
            this.updatePermissionDirectory(req);
        } else {
            this.kerbConfManager.setBasicAuthPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.GROUP);
            if ("usersInGroup".equals(req.getParameter("usersInGroups"))) {
                this.updatePermissionGroups(req, addInGroups, removeInGroups);
            } else {
                this.updatePermissionGroups(req, addNotInGroups, removeNotInGroups);
            }
        }
    }

    private HashMap<String, Object> setBasicAuthIpRestrictions(HttpServletRequest req) {
        HashMap<String, Object> additionalData = new HashMap<String, Object>();
        String basicAuthIpRestrictionType = req.getParameter("basicAuthIpRestrictionType");
        IpRestrictionConfig restrictionCfg = this.kerbConfManager.getIpRestrictionConfig();
        if ("OPEN".equals(basicAuthIpRestrictionType)) {
            String[] basicAuthIpUnblockedList = ListParseUtils.parseArrayFromCommaSeparated((String)req.getParameter("addAllowedListOpen"));
            String[] basicAuthIpBlockedList = ListParseUtils.parseArrayFromCommaSeparated((String)req.getParameter("addDenyListOpen"));
            String[] removeBasicAuthIpUnblockedList = ListParseUtils.parseArrayFromCommaSeparated((String)req.getParameter("removeAllowedListOpen"));
            String[] removeBasicAuthIpBlockedList = ListParseUtils.parseArrayFromCommaSeparated((String)req.getParameter("removeDenyListOpen"));
            Map<String, List<String>> finalListAndNotValidBlockedList = this.processIpLists(restrictionCfg.getBasicAuthIpOpenBlockedList(), removeBasicAuthIpBlockedList, basicAuthIpBlockedList);
            this.kerbConfManager.setBasicAuthIpOpenBlockedList(finalListAndNotValidBlockedList.get("finalList"));
            List<String> notValidList = finalListAndNotValidBlockedList.get("notValidList");
            if (basicAuthIpBlockedList == null && basicAuthIpUnblockedList == null) {
                return additionalData;
            }
            if (!notValidList.isEmpty()) {
                additionalData.put("basicAuthRegexFailedOpenBlockedList", true);
                additionalData.put("errorBasicAuthIpOpenBlockedList", notValidList);
                additionalData.put("basicAuthIpRegexError", true);
            }
            Map<String, List<String>> finalListAndNotValidUnblockedList = this.processIpLists(restrictionCfg.getBasicAuthIpOpenUnblockedList(), removeBasicAuthIpUnblockedList, basicAuthIpUnblockedList);
            this.kerbConfManager.setBasicAuthIpOpenUnblockedList(finalListAndNotValidUnblockedList.get("finalList"));
            List<String> notValidUnblockedList = finalListAndNotValidUnblockedList.get("notValidList");
            if (!notValidUnblockedList.isEmpty()) {
                additionalData.put("basicAuthRegexFailedOpenUnblockedList", true);
                additionalData.put("errorBasicAuthIpOpenUnblockedList", notValidUnblockedList);
                additionalData.put("basicAuthIpRegexError", true);
            }
        } else {
            String[] basicAuthIpUnblockedList = ListParseUtils.parseArrayFromCommaSeparated((String)req.getParameter("addAllowedListStrict"));
            String[] basicAuthIpBlockedList = ListParseUtils.parseArrayFromCommaSeparated((String)req.getParameter("addDenyListStrict"));
            String[] removeBasicAuthIpUnblockedList = ListParseUtils.parseArrayFromCommaSeparated((String)req.getParameter("removeAllowedListStrict"));
            String[] removeBasicAuthIpBlockedList = ListParseUtils.parseArrayFromCommaSeparated((String)req.getParameter("removeDenyListStrict"));
            Map<String, List<String>> finalListAndNotValidBlockedList = this.processIpLists(restrictionCfg.getBasicAuthIpStrictBlockedList(), removeBasicAuthIpBlockedList, basicAuthIpBlockedList);
            this.kerbConfManager.setBasicAuthIpStrictBlockedList(finalListAndNotValidBlockedList.get("finalList"));
            List<String> notValidList = finalListAndNotValidBlockedList.get("notValidList");
            if (basicAuthIpBlockedList == null || basicAuthIpUnblockedList == null) {
                return additionalData;
            }
            if (!notValidList.isEmpty()) {
                additionalData.put("basicAuthRegexFailedStrictBlockedList", true);
                additionalData.put("errorBasicAuthIpStrictBlockedList", notValidList);
                additionalData.put("basicAuthIpStrictRegexError", true);
            }
            Map<String, List<String>> finalListAndNotValidUnblockedList = this.processIpLists(restrictionCfg.getBasicAuthIpStrictUnblockedList(), removeBasicAuthIpUnblockedList, basicAuthIpUnblockedList);
            this.kerbConfManager.setBasicAuthIpStrictUnblockedList(finalListAndNotValidUnblockedList.get("finalList"));
            List<String> notValidUnblockedList = finalListAndNotValidUnblockedList.get("notValidList");
            if (!notValidUnblockedList.isEmpty()) {
                additionalData.put("basicAuthRegexFailedStrictUnblockedList", true);
                additionalData.put("errorBasicAuthIpStrictUnblockedList", notValidUnblockedList);
                additionalData.put("basicAuthIpRegexError", true);
            }
        }
        Option.of((Object)basicAuthIpRestrictionType).filter(StringUtils::isNotBlank).toTry().mapTry(KerbConfManager.IpRestrictionType::valueOf).onFailure(t -> this.log.debug("Couldn't save IP restriction type " + basicAuthIpRestrictionType, t)).peek(this.kerbConfManager::setBasicAuthIpRestrictionType);
        return additionalData;
    }

    private void addDataFromConfigUpdate(Map<String, Object> model) {
        io.vavr.collection.List<UpgradePluginSettingsEntryResult> updateFailures = this.kssoUpgradeManager.getUpgradeFailures();
        model.putIfAbsent("upgradedUnblockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, KerbConfManager.KEYS.BASIC_AUTH_IP_UNBLOCKEDLIST));
        model.putIfAbsent("unblockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, KerbConfManager.KEYS.BASIC_AUTH_IP_UNBLOCKEDLIST));
        model.putIfAbsent("upgradedBlockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, KerbConfManager.KEYS.BASIC_AUTH_IP_BLOCKEDLIST));
        model.putIfAbsent("blockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, KerbConfManager.KEYS.BASIC_AUTH_IP_BLOCKEDLIST));
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> additionalData) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        model.putAll(additionalData);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/basic-auth.vm", model, (Writer)resp.getWriter());
    }

    private Map<String, Object> buildModel(HttpServletRequest req) {
        Map<String, Object> model = this.newModel(req);
        IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
        this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "basic-auth");
        model.put("userPermission", (Object)this.kerbConfManager.getBasicAuthPermissionType());
        if (KerbConfManager.BasicAuthUserPermissionType.IP_ADDRESS_GROUP_DIRECTORY.equals((Object)this.kerbConfManager.getBasicAuthPermissionType()) || KerbConfManager.BasicAuthUserPermissionType.GROUP_DIRECTORY.equals((Object)this.kerbConfManager.getBasicAuthPermissionType())) {
            model.put("userPermissionSome", (Object)this.kerbConfManager.getBasicAuthPermissionSomeUsersConfig());
            if (!KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY.equals((Object)this.kerbConfManager.getBasicAuthPermissionSomeUsersConfig())) {
                model.put("userPermissionGroup", (Object)this.kerbConfManager.getBasicAuthPermissionGroup());
            }
            if (!KerbConfManager.UserPermissionGroupDirectoryType.GROUP.equals((Object)this.kerbConfManager.getBasicAuthPermissionSomeUsersConfig())) {
                model.put("directoryAccess", true);
            } else {
                model.put("directoryAccess", false);
            }
        }
        model.put("groupDirectoryRequired", KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_AND_GROUP.equals((Object)this.kerbConfManager.getBasicAuthPermissionSomeUsersConfig()));
        model.put("basicAuthIpStrictUnblockedList", Arrays.asList(ipRestrictionConfig.getBasicAuthIpStrictUnblockedList()));
        model.put("basicAuthIpOpenUnblockedList", Arrays.asList(ipRestrictionConfig.getBasicAuthIpOpenUnblockedList()));
        model.put("basicAuthIpStrictBlockedList", Arrays.asList(ipRestrictionConfig.getBasicAuthIpStrictBlockedList()));
        model.put("basicAuthIpOpenBlockedList", Arrays.asList(ipRestrictionConfig.getBasicAuthIpOpenBlockedList()));
        model.put("basicAuthIpRestrictionType", (Object)ipRestrictionConfig.getBasicAuthIpRestrictionType());
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        model.put("homeDirectory", this.kerbConfManager.getKerberosHomeDirectoryPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("KSSO_DIRECTORY_ALLOWED", "ksso.basic.auth.allowed");
        model.put("directories", this.userLookupService.getVelocityCompatibleActiveUserDirectories());
        model.put("enabledGroups", this.kerbConfManager.getAllowBasicAuthGroups());
        model.put("disabledGroups", this.kerbConfManager.getDisallowBasicAuthGroups());
        model.putIfAbsent("hasBasicAuthIpUpdateFailures", this.hasUpgradeFailures());
        if (this.hasUpgradeFailures()) {
            this.addDataFromConfigUpdate(model);
        }
        return model;
    }
}

