/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.kantegasso.oidc.OidcData;
import io.vavr.collection.HashMap;
import io.vavr.control.Either;
import io.vavr.control.Option;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitiateOidcLogout {
    private static final Logger log = LoggerFactory.getLogger(InitiateOidcLogout.class);

    public static String run(OidcIdpConfiguration oidcIdpConfiguration, ApplicationProperties appProps, OidcLibWrapper oidcLibWrapper, HostApp hostApp, String idTokenFromSession) {
        Either maybeInitiateSingleLogout = oidcLibWrapper.createOidcData((HashMap<String, Object>)HashMap.of((Object)"client_id", (Object)oidcIdpConfiguration.getClientId(), (Object)"client_secret", (Object)oidcIdpConfiguration.getClientSecret(), (Object)"workaround", (Object)oidcIdpConfiguration.getOidcLibRepresentation(), (Object)"discovery_url", (Object)oidcIdpConfiguration.getDiscoveryUrl(), (Object)"post_logout_redirect_uri", (Object)oidcIdpConfiguration.getSingleLogoutReturnURL(), (Object)"id_token_hint", (Object)idTokenFromSession)).flatMap(data -> data.get("discovery_url").filter(StringUtils::isNotBlank).isDefined() ? oidcLibWrapper.discover((OidcData)data) : Either.right((Object)data)).peekLeft(errorMessage -> log.error(ErrorUtils.createErrorMessage((String)"KSSO-AZC6ZA9DOY", (String)("Encountered an error during Single Logout. Error message trying to do discovery: " + errorMessage)))).flatMap(oidcLibWrapper::initiateSingleLogout).peekLeft(errorMessage -> log.error(ErrorUtils.createErrorMessage((String)"KSSO-YCEOOA9BJF", (String)("Error during Single Logout, something went wrong contacting the IdP: " + errorMessage))));
        if (maybeInitiateSingleLogout.isLeft()) {
            return appProps.getBaseUrl(UrlMode.ABSOLUTE) + hostApp.getMainLogoutPage();
        }
        Option maybeLogoutUri = ((OidcData)maybeInitiateSingleLogout.get()).getLogoutUri();
        if (maybeLogoutUri.isEmpty()) {
            log.error(ErrorUtils.createErrorMessage((String)"KSSO-3GE7FDW3ZC", (String)"Single logout: Could not find logout URI."));
            return appProps.getBaseUrl(UrlMode.ABSOLUTE) + hostApp.getMainLogoutPage();
        }
        if (!HttpUrlUtils.isValidAndNonEmptyUri((String)((String)maybeLogoutUri.get()))) {
            log.error(ErrorUtils.createErrorMessage((String)"KSSO-EOEMVOWFUJ", (String)("Single logout: Invalid logout URI: " + (String)maybeLogoutUri.get())));
            return appProps.getBaseUrl(UrlMode.ABSOLUTE) + "/Secure/Logout!default.jspa";
        }
        return (String)maybeLogoutUri.get();
    }
}

