/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc;

import com.kantegasso.oidc.OidcStringLiterals;
import com.kantegasso.oidc.Workaround;
import io.vavr.API;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.enums.UsernameAttribute;
import org.kantega.atlaskerb.identityproviders.model.AssignGroupRule;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpUtil;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.login.RedirectProperties;
import org.kantega.atlaskerb.saml.util.JitGroupRule;

public class OidcIdpConfiguration
extends IdpConfiguration {
    public static final String OIDC_ID_TOKEN_SESSION_KEY = "ksso.oidc.idtoken";
    public static final String SESSION_USER = "ksso.oidc.session.user";
    private final String clientId;
    private final String clientSecret;
    private final Long clientSecretExpiry;
    private final String discoveryUrl;
    private final Set<String> scopes;
    private final String[] issuerAllowList;

    public OidcIdpConfiguration(boolean mfaRequired, String mfaAttribute, Set<AssignGroupRule> assignGroupRules, boolean autoUpdateKnownDomains, String customEmailAttribute, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, boolean enabled, String id, Optional<Long> jitDirectory, IdpConfiguration.Kind kind, LinkedHashSet<String> knownDomains, boolean createAllIncomingGroups, boolean removeNonIdpGroupsFromUser, List<ManagedGroup> managedGroups, List<ManagedGroup> autoGroups, List<JitGroupRule> advancedGroupRules, boolean managedGroupsRequiredForJITCreation, String name, String notificationEmails, List<Pair<String, String>> userTransformationRegexes, List<Pair<UsernameAttribute, String>> usernameAttributePriority, boolean singleLogoutEnabled, String singleLogoutReturnURL, IdpConfiguration.UserActivatePolicy userActivatePolicy, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, IdpConfiguration.UsernamePolicy usernamePolicy, IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy, IdpConfiguration.UserUpdateNamePolicy userUpdateNamePolicy, IdpConfiguration.UserUpdateEmailPolicy userUpdateEmailPolicy, IdpConfiguration.AutoCreateUserPolicy autoCreateUserPolicy, boolean hostedDomain, Set<String> idpGroupsAttribute, Map<String, String> userProfileKeyMapping, boolean authenticatedAnonymousBrowsingEnabled, String tlsFingerprint, int idpPriority, int loginPageDisplayOrder, String clientId, String clientSecret, Long clientSecretExpiry, String discoveryUrl, Set<String> scopes, String[] issuerAllowList, RedirectProperties redirectProperties, RedirectProperties jsmRedirectProperties, JSONArray storedUserAttributes, boolean removeUnusedUserAttributes) {
        super(mfaRequired, mfaAttribute, assignGroupRules, autoUpdateKnownDomains, customEmailAttribute, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, enabled, id, jitDirectory, kind, knownDomains, createAllIncomingGroups, removeNonIdpGroupsFromUser, managedGroups, autoGroups, advancedGroupRules, managedGroupsRequiredForJITCreation, name, notificationEmails, userTransformationRegexes, usernameAttributePriority, singleLogoutEnabled, userActivatePolicy, userLookupAttribute, userLookupTransform, usernamePolicy, userNotFoundPolicy, userUpdateNamePolicy, userUpdateEmailPolicy, autoCreateUserPolicy, hostedDomain, idpGroupsAttribute, singleLogoutReturnURL, userProfileKeyMapping, authenticatedAnonymousBrowsingEnabled, redirectProperties, jsmRedirectProperties, tlsFingerprint, idpPriority, loginPageDisplayOrder, storedUserAttributes, removeUnusedUserAttributes);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.clientSecretExpiry = clientSecretExpiry;
        this.discoveryUrl = discoveryUrl;
        this.scopes = scopes;
        this.issuerAllowList = issuerAllowList;
    }

    public static String getOidcLibRepresentation(IdpConfiguration.Kind kind) {
        return (String)API.Match((Object)((Object)kind)).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Object)((Object)IdpConfiguration.Kind.ADFS)), (Object)Workaround.ADFS.toString()), API.Case((API.Match.Pattern0)API.$((Object)((Object)IdpConfiguration.Kind.AZURE_AD)), (Object)OidcStringLiterals.AZURE_AD), API.Case((API.Match.Pattern0)API.$((Object)((Object)IdpConfiguration.Kind.GITHUB)), (Object)OidcStringLiterals.GITHUB), API.Case((API.Match.Pattern0)API.$((Object)((Object)IdpConfiguration.Kind.GOOGLE)), (Object)OidcStringLiterals.GOOGLE), API.Case((API.Match.Pattern0)API.$(), (Object)"")});
    }

    public static String extractOidcWorkaround(String kind) {
        return (String)Option.of((Object)kind).filter(StringUtils::isNotBlank).map(IdpConfiguration.Kind::valueOf).map(OidcIdpConfiguration::getOidcLibRepresentation).getOrElse((Object)"");
    }

    public static Try<IdpConfiguration.Kind> extractKind(String kind) {
        return Option.of((Object)kind).filter(StringUtils::isNotBlank).toTry().mapTry(IdpConfiguration.Kind::valueOf);
    }

    @Override
    public IdpConfiguration.SSOProtocol getProtocol() {
        return IdpConfiguration.SSOProtocol.OIDC;
    }

    @Override
    public boolean isOidc() {
        return true;
    }

    @Override
    public boolean isSaml() {
        return false;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Long getClientSecretExpiry() {
        return this.clientSecretExpiry;
    }

    public String getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    public String[] getIssuerAllowList() {
        return (String[])Option.of((Object)this.issuerAllowList).getOrElse((Object)new String[0]);
    }

    public Set<String> getScope() {
        return this.scopes;
    }

    public String getOidcLibRepresentation() {
        return OidcIdpConfiguration.getOidcLibRepresentation(this.getKind());
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public JSONObject asJson(OidcIdpUtil oidcIdpUtil) {
        JSONObject json = super.asJson();
        json.put("clientId", (Object)this.getClientId());
        json.put("clientSecret", (Object)oidcIdpUtil.getClientSecretProcessEnv(this));
        json.put("clientSecretExpiry", (Object)this.getClientSecretExpiry());
        json.put("discoveryUrl", (Object)this.getDiscoveryUrl());
        json.put("scopes", (Object)new JSONArray(this.getScope()));
        json.put("issuerAllowList", (Object)new JSONArray((Object)this.getIssuerAllowList()));
        return json;
    }
}

