/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserMappingUtils;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.enums.UsernameAttribute;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.userlookup.CheckTransformationHelper;
import org.kantega.atlaskerb.userlookup.regextransformation.RegexTransformationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpUserLookupServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(IdpUserLookupServlet.class);
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private IdpConfiguration configuration;
    private String requestId;

    @Inject
    public IdpUserLookupServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostApp();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.requestId = IdpConfManager.IdpServletUtil.getId(req);
        this.configuration = this.idpConfManager.getIdentityProviderById(this.requestId);
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        if (this.configuration == null) {
            resp.sendError(404);
            return;
        }
        this.configuration = this.idpConfManager.getIdentityProviderById(IdpConfManager.IdpServletUtil.getId(req));
        JSONArray regexTransformations = new JSONArray();
        List<Pair<String, String>> regexTuples = this.configuration.getUserTransformationRegexes();
        List<RegexTransformationResult> validations = UserMappingUtils.regexTransformations("john.doe@example.com", regexTuples);
        validations.forEach(result -> regexTransformations.put((Object)result.toJson()));
        List<Pair<UsernameAttribute, String>> usernameAttributePriority = this.configuration.getUsernameAttributePriority();
        for (int i = 0; i < usernameAttributePriority.size(); ++i) {
            model.put("usernameAttribute" + (i + 1), usernameAttributePriority.get(i).getLeft());
            model.put("customUsernameAttributeName" + (i + 1), usernameAttributePriority.get(i).getRight());
        }
        Optional<String> transformedUsername = UserMappingUtils.transformUsername("john.doe@example.com", regexTuples);
        model.put("regexTransformationsWithHtml", regexTransformations.toString());
        model.put("userPrincipalName", "john.doe@example.com");
        model.put("regexTuples", regexTuples);
        model.put("noTransformation", IdpConfiguration.UserLookupTransform.NONE.toString());
        model.put("namePartTransformation", IdpConfiguration.UserLookupTransform.NAME_PART.toString());
        model.put("regexTransformation", IdpConfiguration.UserLookupTransform.REGEX.toString());
        model.put("selectedUserLookupTransform", this.configuration.getUserLookupTransform().toString());
        model.put("transformedUsername", transformedUsername.orElse("<no match>"));
        model.put("topMenu", "SAML");
        model.put("menuItem", "userLookupSettings");
        model.put("usernameAttributes", UsernameAttribute.getValues());
        model.put("idp", this.configuration);
        model.put("samlConfigURL", this.idpConfManager.getIdpConfigUrl(req));
        model.put("serviceURL", this.idpConfManager.getServiceProviderLoginUrl(req, this.requestId));
        model.put("testingURL", this.idpConfManager.getServiceProviderTestUrl(req, this.requestId));
        model.put("metadataURL", this.idpConfManager.getServiceProviderMetadataUrl(req, this.requestId));
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("canAddUser", this.hostApp.canAddUser());
        model.put("serverName", req.getServerName());
        model.put("test", req.getParameter("test"));
        this.getTemplateRenderer().render("templates/saml/idp-user-lookup.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("checkTransformation") != null) {
            CheckTransformationHelper.checkTransformation(req, resp);
            return;
        }
        String id = IdpConfManager.IdpServletUtil.getId(req);
        String action = req.getParameter("action");
        if ("editUserLookupSettings".equals(action)) {
            IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(this.idpConfManager.getIdentityProviderById(id));
            ArrayList<Pair<UsernameAttribute, String>> usernameAttributePriority = new ArrayList<Pair<UsernameAttribute, String>>();
            for (int i = 0; i < 3; ++i) {
                String attr = req.getParameter("usernameAttr" + (i + 1));
                if (!StringUtils.isNotBlank((CharSequence)attr)) continue;
                UsernameAttribute userAttr = UsernameAttribute.valueOf(attr);
                usernameAttributePriority.add((Pair<UsernameAttribute, String>)Pair.of((Object)((Object)userAttr), (Object)StringUtils.trim((String)req.getParameter("customUsernameAttributeName" + (i + 1)))));
            }
            builder.setUsernameAttributePriority(usernameAttributePriority);
            Optional.ofNullable(req.getParameter("userLookupAttribute")).map(StringUtils::trim).map(IdpConfiguration.UserLookupAttribute::valueOf).ifPresent(builder::setUserLookupAttribute);
            IdpConfiguration.UserLookupTransform userLookupTransform = IdpConfiguration.UserLookupTransform.valueOf(StringUtils.trim((String)req.getParameter("userLookupTransform")));
            builder.setUserLookupTransform(userLookupTransform);
            List regexTuples = CheckTransformationHelper.processRegexTuples(req).filter(tuple -> StringUtils.isNotBlank((CharSequence)((CharSequence)tuple._1)) && StringUtils.isNotBlank((CharSequence)((CharSequence)tuple._2))).map(tuple -> Pair.of((Object)((String)tuple._1), (Object)((String)tuple._2))).asJava();
            if (userLookupTransform == IdpConfiguration.UserLookupTransform.REGEX) {
                builder.setUserTransformationRegexes(regexTuples);
            }
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        }
        Map<String, Object> model = this.newModel(req);
        this.renderPage(req, resp, model);
    }
}

