/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.util;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.jsonmapping.JsonMapping;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.kantega.atlaskerb.rest.util.ResponseWrapper;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseUtils {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtils.class);

    public static Response ok() {
        return Response.ok().build();
    }

    public static ResponseWrapper<UserProfile> sysadminOnly(HttpServletRequest request, UserManager salUserManager) {
        return block -> {
            UserProfile userProfile = salUserManager.getRemoteUser(request);
            boolean isSystemAdmin = UserManagerUtils.isSystemAdmin((UserProfile)userProfile, (UserManager)salUserManager);
            if (isSystemAdmin) {
                try {
                    return (Response)block.apply((Object)userProfile);
                }
                catch (Throwable throwable) {
                    log.error("Encountered an error in KSSO admin REST API", throwable);
                    return Response.serverError().build();
                }
            }
            String username = (String)UserManagerUtils.extractUsername((UserProfile)userProfile).getOrElse((Object)"<unknown>");
            log.debug("Admin only request to KSSO admin REST API unauthorized. Requested by " + username);
            return Response.status((int)403).build();
        };
    }

    public static ResponseWrapper<UserProfile> user(HttpServletRequest request, UserManager salUserManager) {
        return block -> {
            UserProfile userProfile = salUserManager.getRemoteUser(request);
            if (userProfile != null) {
                try {
                    return (Response)block.apply((Object)userProfile);
                }
                catch (Throwable throwable) {
                    log.error("Encountered an error during request to KSSO API: ", throwable);
                    return Response.serverError().build();
                }
            }
            log.error("Remote user key not found.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        };
    }

    public static Response jsonDeprecated(Object object) {
        return (Response)JsonMapping.Write.objectAsJson((Object)object).map(json -> Response.ok((Object)json.toString(4), (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(t -> log.error("Failed to build JSON: ", t)).getOrElse((Object)Response.serverError().build());
    }

    public static Response errorWithMessageInJson(Response.Status status, String message) {
        JSONObject json = new JSONObject();
        json.put("error", (Object)message);
        return Response.status((Response.Status)status).entity((Object)json.toString(4)).build();
    }
}

