/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.msteams;

import com.atlassian.annotations.security.UnrestrictedAccess;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public final class MsTeamsSecurityHeadersFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(MsTeamsSecurityHeadersFilter.class);
    private final HostApp hostApp;

    @Inject
    public MsTeamsSecurityHeadersFilter(RequireAdminServletDependencyBucket bucket) {
        this.hostApp = bucket.getHostApp();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (response != null && this.hostApp.isMsTeamsSecurityHeadersEnabled()) {
            if (response.getHeader("Content-Security-Policy") != null) {
                response.setHeader("Content-Security-Policy", response.getHeader("Content-Security-Policy") + " https://teams.microsoft.com");
            }
            if (StringUtils.equals((CharSequence)"DENY", (CharSequence)response.getHeader("X-Frame-Options"))) {
                response.setHeader("X-Frame-Options", "SAMEORIGIN");
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

