/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.sal.api.ApplicationProperties;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;
import org.kantega.atlaskerb.wrapper.crowd.CrowdDirectoryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpJITServlet
extends RequireAdminServlet {
    private static final String USER_PROFILE_PREFIX = "profile-";
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private final Logger log = LoggerFactory.getLogger(IdpJITServlet.class);
    private final ConnectorConfManager connectorConfManager;
    private final ScimConfManager scimConfManager;
    private IdpConfiguration configuration;

    public IdpJITServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostApp();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.scimConfManager = bucket.getScimConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String requestId = IdpConfManager.IdpServletUtil.getId(req);
        this.configuration = this.idpConfManager.getIdentityProviderById(requestId);
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        if (this.configuration == null) {
            resp.sendError(404);
            return;
        }
        this.configuration = this.idpConfManager.getIdentityProviderById(IdpConfManager.IdpServletUtil.getId(req));
        List userProfileKeys = this.hostApp.getUserProfileKeys().toJavaList();
        Map<String, String> userProfileKeyMap = this.configuration.getUserProfileKeyMap();
        for (String key : this.hostApp.getUserProfileKeys().toJavaList()) {
            if (userProfileKeyMap.containsKey(key)) continue;
            userProfileKeyMap.put(key, "");
        }
        boolean authenticatedAnonymousBrowsingAndCreateEnabledSimultaneously = this.configuration.isSsoProtectedAnonymousBrowsingEnabled() && this.configuration.getUserNotFoundPolicy().equals((Object)IdpConfiguration.UserNotFoundPolicy.CREATE);
        model.put("infoAuthenticatedAnonymousBrowsingEnabled", authenticatedAnonymousBrowsingAndCreateEnabledSimultaneously);
        model.put("idp", this.configuration);
        model.put("jitDirectory", this.configuration.getJitDirectory().orElse(-1L));
        Directory configuredJitDirectory = this.hostApp.getCrowdDirectoryService().findDirectoryById(this.configuration.getJitDirectory().orElse(-1L).longValue());
        if (configuredJitDirectory != null) {
            model.put("jitDirectoryNotWritableWarning", !this.hostApp.isDirectoryCanUpdateUser(configuredJitDirectory));
            model.put("jitDirectoryType", configuredJitDirectory.getType());
            model.put("jitDirectoryName", configuredJitDirectory.getName());
            model.put("jitDirectoryUsernameFormat", configuredJitDirectory.getAttributes().get("ldap.user.username"));
        }
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("canAddUser", this.hostApp.canAddUser());
        model.put("userProfilePrefix", USER_PROFILE_PREFIX);
        model.put("userProfileKeys", userProfileKeys);
        model.put("userProfileKeyMap", userProfileKeyMap);
        Set<Directory> writableAndActiveUserDirectories = this.hostApp.getWritableAndActiveUserDirectories();
        Set jitUserDirectories = io.vavr.collection.List.ofAll(writableAndActiveUserDirectories).append((Object)configuredJitDirectory).map(Option::of).filter(Option::isDefined).map(Option::get).distinctBy(Directory::getId).filter(directory -> directory.getType() != DirectoryType.CONNECTOR || directory.getType() == DirectoryType.CONNECTOR && "sAMAccountName".equals(directory.getAttributes().get("ldap.user.username"))).map(CrowdDirectoryWrapper::new).toJavaSet();
        HashSet<CrowdDirectoryWrapper> possibleJitUserDirectories = new HashSet<CrowdDirectoryWrapper>();
        for (CrowdDirectoryWrapper directory2 : jitUserDirectories) {
            ScimDirectory dir = (ScimDirectory)this.scimConfManager.getScimDirectories().find(scimDir -> scimDir.getDirectoryId() == directory2.getId()).getOrNull();
            if (dir != null && !dir.getConfig().isLinkUsersOnCreate()) continue;
            possibleJitUserDirectories.add(directory2);
        }
        model.put("possibleJitUserDirectories", possibleJitUserDirectories);
        if (configuredJitDirectory != null) {
            boolean selectedDirectoryInPossibleDirectories = false;
            for (CrowdDirectoryWrapper directory3 : possibleJitUserDirectories) {
                if (directory3.getId() != configuredJitDirectory.getId().longValue()) continue;
                selectedDirectoryInPossibleDirectories = true;
                break;
            }
            if (!selectedDirectoryInPossibleDirectories) {
                model.put("selectedDirectoryNotInPossibleDirectories", true);
            }
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "jit");
        model.put("matchingConnectors", this.connectorConfManager.findMatchingConnectors(this.configuration.getKind()));
        this.getTemplateRenderer().render("templates/saml/idp-jit.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String testId;
        String id = IdpConfManager.IdpServletUtil.getId(req);
        String action = req.getParameter("action");
        if ("editUserLookupSettings".equals(action)) {
            IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy = StringUtils.isNotEmpty((CharSequence)req.getParameter("createJITUsers")) ? IdpConfiguration.UserNotFoundPolicy.CREATE : IdpConfiguration.UserNotFoundPolicy.REJECT;
            IdpConfiguration.UserUpdateNamePolicy userUpdateNamePolicy = StringUtils.isNotEmpty((CharSequence)req.getParameter("updateJitName")) ? IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME : IdpConfiguration.UserUpdateNamePolicy.NONE;
            IdpConfiguration.UserUpdateEmailPolicy userUpdateEmailPolicy = StringUtils.isNotEmpty((CharSequence)req.getParameter("updateJITEmail")) ? IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL : IdpConfiguration.UserUpdateEmailPolicy.NONE;
            IdpConfiguration.UserActivatePolicy userActivatePolicy = StringUtils.isNotEmpty((CharSequence)req.getParameter("activateJITUsers")) ? IdpConfiguration.UserActivatePolicy.ACTIVATE : IdpConfiguration.UserActivatePolicy.NONE;
            String customNameAttribute = StringUtils.trimToNull((String)req.getParameter("customNameAttribute"));
            String customGivenNameAttribute = StringUtils.trimToNull((String)req.getParameter("customGivenNameAttribute"));
            String customSurnameAttribute = StringUtils.trimToNull((String)req.getParameter("customSurnameAttribute"));
            String customEmailAttribute = StringUtils.trimToNull((String)req.getParameter("customEmailAttribute"));
            IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping = "FIRST_AND_LAST_NAME".equals(StringUtils.trimToNull((String)req.getParameter("nameAttributeMapping"))) ? IdpConfManager.NAME_ATTRIBUTE_MAPPING.FIRST_AND_LAST_NAME : IdpConfManager.NAME_ATTRIBUTE_MAPPING.FULL_NAME;
            Map userProfileKeyMapping = this.hostApp.getUserProfileKeys().toMap(key -> key, key -> USER_PROFILE_PREFIX + key).mapValues(arg_0 -> ((HttpServletRequest)req).getParameter(arg_0)).mapValues(Option::of).mapValues(maybeVal -> (String)maybeVal.getOrElse((Object)"")).filterValues(StringUtils::isNotBlank).toJavaMap();
            IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(this.idpConfManager.getIdentityProviderById(id));
            builder.setUserNotFoundPolicy(userNotFoundPolicy);
            builder.setUserUpdateNamePolicy(userUpdateNamePolicy);
            builder.setUserUpdateEmailPolicy(userUpdateEmailPolicy);
            builder.setUserActivatePolicy(userActivatePolicy);
            builder.setCustomNameAttribute(customNameAttribute);
            builder.setCustomGivenNameAttribute(customGivenNameAttribute);
            builder.setCustomSurnameAttribute(customSurnameAttribute);
            builder.setCustomEmailAttribute(customEmailAttribute);
            builder.setUserProfileKeyMapping(userProfileKeyMapping);
            builder.setNameAttributeMapping(nameAttributeMapping);
            Option.of((Object)req.getParameter("JITDirectory")).toTry().mapTry(Long::parseLong).onFailure(throwable -> this.log.error(throwable.getMessage())).peek(builder::setJitDirectory);
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        }
        if ((testId = req.getParameter("test")) != null) {
            resp.sendRedirect(this.idpConfManager.getServiceProviderEvaluateTestUrl(req, id) + "/" + testId + "/result");
        } else {
            resp.sendRedirect("jit");
        }
    }
}

