/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.web.context.HttpContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.wrapper.web.ConditionWrapper;
import org.springframework.stereotype.Component;

@Component
public class SSOScriptLoginHookCondition
extends ConditionWrapper {
    private final HttpContext httpContext;
    private final HostApp hostApp;
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;
    private Set<String> products;

    @Inject
    public SSOScriptLoginHookCondition(@ComponentImport HttpContext httpContext, HostAppFactory hostApp, IdpConfManager idpConfManager, KerbConfManager kerbConfManager) {
        this.httpContext = httpContext;
        this.hostApp = hostApp.getInstance();
        this.idpConfManager = idpConfManager;
        this.kerbConfManager = kerbConfManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String products = params.get("products");
        if (products != null) {
            this.products = new HashSet<String>();
            for (String product : products.split(",")) {
                if ((product = product.trim()).isEmpty()) continue;
                this.products.add(product);
            }
        }
    }

    public boolean shouldDisplayInternal(Map<String, Object> parameters) {
        HttpServletRequest request = this.httpContext.getRequest();
        return this.shouldAddLoginScripts(request);
    }

    public boolean shouldDoFederatedSSO(HttpServletRequest request) {
        return !SSOScriptLoginHookCondition.queryStringHasNoSso(request) && !this.hostApp.isRestApi(HttpUrlUtils.getInternalPath((HttpServletRequest)request)) && this.isProductMatch() && this.idpConfManager.isFederatedSsoEnabled() && this.idpConfManager.isLicenseValid() && this.idpConfManager.countActiveProviders() > 0;
    }

    private boolean querystringHasNosaml(HttpServletRequest req) {
        return StringUtils.contains((CharSequence)req.getQueryString(), (CharSequence)"nosaml");
    }

    public boolean shouldAddLoginScripts(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        String requestAddress = HttpUrlUtils.getInternalPath((HttpServletRequest)request);
        boolean isLoginPage = this.hostApp.isPageWithLoginForm(request);
        boolean isLogoutPage = this.hostApp.isLogoutPage(request);
        return (isLogoutPage || isLoginPage) && this.shouldDoFederatedSSO(request);
    }

    public boolean shouldAddMSTeamsScripts(HttpServletRequest request) {
        return this.hostApp.isPageWithLoginForm(request) && this.kerbConfManager.isMsTeamsAuthenticationEnabled();
    }

    private static boolean querystringHasNoSaml(HttpServletRequest req) {
        return StringUtils.contains((CharSequence)req.getQueryString(), (CharSequence)"nosaml");
    }

    private static boolean queryStringHasNoSso(HttpServletRequest req) {
        return StringUtils.contains((CharSequence)req.getQueryString(), (CharSequence)"nosso");
    }

    public static boolean shouldAbortSso(HttpServletRequest req) {
        return SSOScriptLoginHookCondition.querystringHasNoSaml(req) || SSOScriptLoginHookCondition.queryStringHasNoSso(req) || SSOScriptLoginHookCondition.querystringHasNoredirect(req);
    }

    public static boolean querystringHasNoredirect(HttpServletRequest req) {
        return StringUtils.contains((CharSequence)req.getQueryString(), (CharSequence)"noredirect");
    }

    private boolean isProductMatch() {
        if (this.products == null) {
            return true;
        }
        for (String product : this.products) {
            if (!this.hostApp.isProductMatch(product)) continue;
            return true;
        }
        return false;
    }
}

