/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import java.security.Principal;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.CleanupLogAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserCleanupResult;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserSummary;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="get-cleanup-logs")
@PublicApi
public class GetCleanupLogs {
    private static final Logger log = LoggerFactory.getLogger(GetCleanupLogs.class);
    private final UserManager userManager;
    private final HostApp hostApp;
    private final JsonWrapper jsonWrapper;

    @Inject
    public GetCleanupLogs(@ComponentImport UserManager userManager, HostAppFactory hostAppFactory, JsonWrapper jsonWrapper) {
        this.userManager = userManager;
        this.hostApp = hostAppFactory.getInstance();
        this.jsonWrapper = jsonWrapper;
    }

    private Response run(UserProfile userProfile, UserManager userManager, CleanupLogAttributes cleanupLogAttributes, HttpServletRequest req) {
        if (!userManager.isSystemAdmin(userProfile.getUserKey())) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.FORBIDDEN, "Missing access privileges");
        }
        UserCleanupResult[] cleanupLog = this.hostApp.getInactiveUserCleaner().getCleanupLog(cleanupLogAttributes);
        if (!cleanupLogAttributes.isFetchCurrentData()) {
            return (Response)this.jsonWrapper.tryBuildJsonString(cleanupLog).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
        }
        CrowdService crowdService = this.hostApp.getCrowdService();
        for (UserCleanupResult res : cleanupLog) {
            for (UserSummary summary : res.getAffectedUsers()) {
                UserWithAttributes userWithAttributes = this.hostApp.getCrowdService().getUserWithAttributes(summary.getUsername());
                if (userWithAttributes == null) continue;
                Principal principal = () -> userWithAttributes.getName();
                summary.setIsLicensedGroupMember(this.hostApp.canLogin(principal, req));
                summary.setIsActive(userWithAttributes.isActive());
                summary.setInGroup(this.hostApp.isUserInGroup(userWithAttributes.getName(), res.getGroupToRemove()));
            }
        }
        return (Response)this.jsonWrapper.tryBuildJsonString(cleanupLog).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, CleanupLogAttributes cleanupLogAttributes) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager, cleanupLogAttributes, request)).onFailure(e -> log.error("Encountered an exception while atempting to GET cleanup rule. ", e)).getOrElse((Object)Response.serverError().build()));
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request) {
        return this.doPost(request, new CleanupLogAttributes(10, false, false, true, false, false));
    }
}

