/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="get-user-last-logged-in-date")
@PublicApi
public class GetUserLastLoggedInDate {
    private static final Logger log = LoggerFactory.getLogger(GetUserLastLoggedInDate.class);
    UserManager userManager;
    HostApp hostApp;

    @Inject
    public GetUserLastLoggedInDate(@ComponentImport UserManager userManager, HostAppFactory hostApp) {
        this.userManager = userManager;
        this.hostApp = hostApp.getInstance();
    }

    private Response run(UserProfile userProfile, UserManager userManager, String username) {
        UserWithAttributes userWithAttributes = this.hostApp.getCrowdService().getUserWithAttributes(username);
        if (userWithAttributes == null) {
            log.warn("The user " + username + " was not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("The user " + username + " was not found")).build();
        }
        return Response.ok((Object)this.hostApp.getLastLoginMillisFromUserWithAttributes(userWithAttributes)).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request, @QueryParam(value="username") String username) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager, username)).onFailure(e -> log.error("Encountered an exception while atempting to GET cleanup rule. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

