/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.cleanup.CleanupUtilsShared;
import org.kantega.atlaskerb.cleanup.InactiveUserCleaner;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.DryRunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserCleanupResult;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserSummary;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="execute")
@PublicApi
public class Execute {
    private static final Logger log = LoggerFactory.getLogger(Execute.class);
    private final UserManager userManager;
    private final HostApp hostApp;
    private final JsonWrapper jsonWrapper;

    @Inject
    public Execute(@ComponentImport UserManager userManager, HostAppFactory hostAppFactory, JsonWrapper jsonWrapper) {
        this.userManager = userManager;
        this.hostApp = hostAppFactory.getInstance();
        this.jsonWrapper = jsonWrapper;
    }

    private void setSameCleanupModeLastRunId(CleanupMode cleanupMode, String runId) {
        if (cleanupMode.equals((Object)CleanupMode.JSM)) {
            this.hostApp.setJsmCleanupLastRunId(runId);
        } else {
            this.hostApp.setUserCleanupLastRunId(runId);
        }
    }

    private void setSameCleanupModeExecuteStatus(CleanupMode cleanupMode, InactiveUserCleaner.CleanupStatus newStatus) {
        if (cleanupMode.equals((Object)CleanupMode.JSM)) {
            this.hostApp.setJsmCleanupExecuteStatus(newStatus);
        } else {
            this.hostApp.setUserCleanupExecuteStatus(newStatus);
        }
    }

    private boolean isSameCleanupModeRunning(DryRunAttributes dryRunAttributes) {
        CleanupMode cleanupMode = CleanupUtilsShared.getCleanupMode(dryRunAttributes);
        if (cleanupMode.equals((Object)CleanupMode.JSM)) {
            return this.hostApp.getJsmCleanupExecuteStatus().equals((Object)InactiveUserCleaner.CleanupStatus.RUNNING);
        }
        return this.hostApp.getUserCleanupExecuteStatus().equals((Object)InactiveUserCleaner.CleanupStatus.RUNNING);
    }

    private Response run(UserProfile userProfile, UserManager userManager, DryRunAttributes dryRunAttributes) {
        UUID runUUID = UUID.randomUUID();
        DateTime runStartTime = DateTime.now();
        boolean dryRun = dryRunAttributes.isDryRun();
        String username = userProfile.getUsername();
        if (!this.isSameCleanupModeRunning(dryRunAttributes)) {
            this.hostApp.getInactiveUserCleaner().getWorkers().submit(new CleanupRunnable(runUUID, runStartTime, dryRunAttributes, username));
            UserCleanupResult result = new UserCleanupResult(runUUID.toString(), runUUID.toString(), runStartTime.toString(), dryRun, dryRunAttributes.isSimulateCronDate(), new UserSummary[0], null, null, -1);
            return (Response)this.jsonWrapper.tryBuildJsonString(result).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Conflict: cleanup mode already running").build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, DryRunAttributes dryRunAttributes) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager, dryRunAttributes)).onFailure(e -> log.error("Encountered an exception while atempting to cleanup users. ", e)).getOrElse((Object)Response.serverError().build()));
    }

    class CleanupRunnable
    implements Runnable {
        private final UUID runId;
        private final DateTime runStartTime;
        private final DryRunAttributes dryRunAttributes;
        private final String username;
        private final CleanupMode cleanupMode;

        public CleanupRunnable(UUID runId, DateTime runStartTime, DryRunAttributes dryRunAttributes, String username) {
            this.runId = runId;
            this.runStartTime = runStartTime;
            this.dryRunAttributes = dryRunAttributes;
            this.username = username;
            this.cleanupMode = CleanupUtilsShared.getCleanupMode(dryRunAttributes);
        }

        @Override
        public void run() {
            try {
                String threadName = Thread.currentThread().getName();
                long threadId = Thread.currentThread().getId();
                log.info(String.format("User cleanup thread starting at %s %s %d %s", this.runStartTime.toString(), threadName, threadId, this.runId));
                Execute.this.setSameCleanupModeExecuteStatus(this.cleanupMode, InactiveUserCleaner.CleanupStatus.RUNNING);
                Execute.this.setSameCleanupModeLastRunId(this.cleanupMode, this.runId.toString());
                Execute.this.hostApp.cleanupInactiveUsers(this.username, this.dryRunAttributes != null ? this.dryRunAttributes : new DryRunAttributes(false, false, false), this.runStartTime, this.runId.toString());
                Execute.this.setSameCleanupModeExecuteStatus(this.cleanupMode, InactiveUserCleaner.CleanupStatus.SUCCESS);
            }
            catch (Exception e) {
                log.error("User cleanup failed", (Throwable)e);
                Execute.this.setSameCleanupModeExecuteStatus(this.cleanupMode, InactiveUserCleaner.CleanupStatus.FAILED);
            }
        }
    }
}

