/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.upgrade.configuration;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.upgrade.data.UpgradeMessage;
import org.kantega.atlaskerb.utils.Version;

public class ApiTokenConfigurationUpgrade {
    private final KerbConfManager kerbConfManager;

    public ApiTokenConfigurationUpgrade(KerbConfManager kerbConfManager) {
        this.kerbConfManager = kerbConfManager;
    }

    public io.vavr.collection.List<UpgradeMessage> run() {
        return io.vavr.collection.List.of((Object)this.updateAPITokenConfigurations());
    }

    public void updateApiTokenGroupRestrictions() {
        List<String> deprecatedGroups = this.kerbConfManager.getApiTokenAllowedUserGroups();
        JSONArray newGroupRestriction = this.kerbConfManager.getApiTokensGroupsTimeRestriction();
        long maximumApiRestriction = this.kerbConfManager.getApiTokensUserMaxTimeRestriction();
        if (newGroupRestriction.isEmpty() && !deprecatedGroups.isEmpty()) {
            for (String group : deprecatedGroups) {
                this.kerbConfManager.setApiTokensGroupTimeRestriction(group, String.valueOf(maximumApiRestriction), false);
            }
        }
    }

    @NotNull
    public UpgradeMessage updateAPITokenConfigurations() {
        if (this.isBreakingChangesForApiTokenGroupConfiguration()) {
            this.updateApiTokenGroupRestrictions();
            new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "Successfully upgraded Kantega SSO Enterprise API token configurations.");
        }
        return new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "Nothing to update");
    }

    public boolean isBreakingChanges() {
        return this.isBreakingChangesForApiTokenGroupConfiguration();
    }

    private boolean isBreakingChangesForApiTokenGroupConfiguration() {
        Version versionWithRefactoredApiTokenGroupConfiguration = new Version("6.35.0");
        Version platform7VersionWithRefactoredApiTokenGroupConfiguration = new Version("7.35.0");
        Version v = (Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrNull();
        if (v == null) {
            return true;
        }
        return v.isLowerThan(versionWithRefactoredApiTokenGroupConfiguration) || v.isHigherThanOrEqualTo(Version.of((String)"7.0.0")) && v.isLowerThan(platform7VersionWithRefactoredApiTokenGroupConfiguration);
    }
}

