/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import java.security.Principal;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.cleanup.InactiveUserCleaner;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.ExecuteSingleUserAttributes;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="execute-single-user")
@PublicApi
public class ExecuteSingleUser {
    private static final Logger log = LoggerFactory.getLogger(ExecuteSingleUser.class);
    private final UserManager userManager;
    private final HostApp hostApp;

    @Inject
    public ExecuteSingleUser(@ComponentImport UserManager userManager, HostAppFactory hostAppFactory) {
        this.userManager = userManager;
        this.hostApp = hostAppFactory.getInstance();
    }

    private Response activateUser(Directory userDirectory, User user) {
        try {
            this.hostApp.updateUser(userDirectory, user.getName(), user.getDisplayName(), user.getEmailAddress(), true);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Failed to activate user");
        }
    }

    private Response deactivateUser(Directory userDirectory, User user) {
        if (!this.hostApp.getInactiveUserCleaner().deactivateUser(userDirectory, user)) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Failed to deactivate user");
        }
        return Response.ok().build();
    }

    private Directory getUserDirectory(User user) {
        Optional<Directory> dirStream = this.hostApp.getCrowdDirectoryService().findAllDirectories().stream().filter(directory -> directory.getId().longValue() == user.getDirectoryId()).findFirst();
        return dirStream.orElse(null);
    }

    private Response run(UserProfile userProfile, UserManager userManager, ExecuteSingleUserAttributes executeSingleUserAttributes) {
        User user = this.hostApp.getCrowdService().getUser(executeSingleUserAttributes.getUser());
        String group = executeSingleUserAttributes.getGroup();
        if (!userManager.isSystemAdmin(userProfile.getUserKey())) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.FORBIDDEN, "Missing access privileges");
        }
        if (this.hostApp.getUserCleanupExecuteStatus() == InactiveUserCleaner.CleanupStatus.RUNNING) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Cleanup in progress");
        }
        if (user == null) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Unspecified user");
        }
        if (group == null || group.equals("")) {
            Directory userDirectory = this.getUserDirectory(user);
            if (userDirectory == null) {
                return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Unable to find user directory");
            }
            return user.isActive() ? this.deactivateUser(userDirectory, user) : this.activateUser(userDirectory, user);
        }
        if (this.hostApp.isUserInGroup(user.getName(), group)) {
            if (!this.hostApp.removeUserFromGroup((Principal)user, group)) {
                return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Failed to remove user " + user.getName() + " from group " + group);
            }
            return Response.ok().build();
        }
        if (!this.hostApp.addUserToGroup((Principal)user, group)) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Failed to remove user " + user.getName() + " from group " + group);
        }
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, ExecuteSingleUserAttributes executeSingleUserAttributes) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager, executeSingleUserAttributes)).onFailure(e -> log.error("Encountered an exception while attempting to cleanup user. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

