/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.intercept.filter;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.AvoidNameEmailChange;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraAvoidEditProfileAdminFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    HostApp hostApp;
    ScimConfManager scimConfManager;
    ConnectorConfManager connectorConfManager;
    UserManager userManager;

    public JiraAvoidEditProfileAdminFilter(RequireAdminServletDependencyBucket bucket) {
        this.hostApp = bucket.getHostApp();
        this.scimConfManager = bucket.getScimConfManager();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.userManager = bucket.getUserManager();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse res = (HttpServletResponse)response;
        HttpServletResponseWrapper wrapper = new HttpServletResponseWrapper(res){

            public PrintWriter getWriter() throws IOException {
                return new PrintWriter(new Writer(){

                    @Override
                    public void write(@NotNull char[] cbuf, int off, int len) throws IOException {
                        String formContent = new String(cbuf, off, len);
                        try {
                            String username;
                            if (formContent.contains(">Edit user profile") && (username = JiraAvoidEditProfileAdminFilter.this.getUsernameFromForm(formContent)) != null && JiraAvoidEditProfileAdminFilter.this.userManager.getUserProfile(username) != null) {
                                JiraAvoidEditProfileAdminFilter.this.log.debug("Edit profile page is set to read-only");
                                UserProfile userEdited = JiraAvoidEditProfileAdminFilter.this.userManager.getUserProfile(username);
                                if (userEdited != null && AvoidNameEmailChange.isUserInCloudDirectory(userEdited, JiraAvoidEditProfileAdminFilter.this.hostApp, JiraAvoidEditProfileAdminFilter.this.scimConfManager, JiraAvoidEditProfileAdminFilter.this.connectorConfManager)) {
                                    formContent = formContent.replace("<form ", "<div style=\"margin-left:20px;margin-right:20px\" class=\"aui-message aui-message-info\">You cannot edit properties as they are stored in a read-only user directory.</div><form ");
                                    formContent = formContent.replace("name=\"username\"", "name=\"username\" readonly style=\"background-color: var(--aui-form-disabled-field-bg-color, lightgray)\"");
                                    formContent = formContent.replace("name=\"fullname\"", "name=\"fullname\" readonly style=\"background-color: var(--aui-form-disabled-field-bg-color, lightgray)\"");
                                    formContent = formContent.replace("name=\"email\"", "name=\"email\" readonly style=\"background-color: var(--aui-form-disabled-field-bg-color, lightgray)\"");
                                }
                            }
                        }
                        catch (Exception e) {
                            JiraAvoidEditProfileAdminFilter.this.log.error("Error in JiraAvoidEditProfileAdminFilter", (Throwable)e);
                        }
                        this.getResponse().getOutputStream().write(formContent.getBytes(StandardCharsets.UTF_8));
                    }

                    @Override
                    public void flush() throws IOException {
                        JiraAvoidEditProfileAdminFilter.this.log.debug("Flushing requested");
                    }

                    @Override
                    public void close() throws IOException {
                        JiraAvoidEditProfileAdminFilter.this.log.debug("Closing requested");
                    }
                });
            }
        };
        chain.doFilter(request, (ServletResponse)wrapper);
    }

    private String getUsernameFromForm(String content) {
        String username = null;
        Pattern pattern = Pattern.compile("<input[^>]*name=\"username\"[^>]*value=\"([^\"]*)\"[^>]*>");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            username = matcher.group(1);
            this.log.debug("Found username: " + username);
        } else {
            this.log.debug("Username not found");
        }
        return username;
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private class EditOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream out;

        public EditOutputStream(ServletOutputStream outputStream) {
            this.out = outputStream;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void print(String s) throws IOException {
            this.out.print(s);
        }

        public void print(boolean b) throws IOException {
            this.out.print(b);
        }

        public void print(char c) throws IOException {
            this.out.print(c);
        }

        public void print(int i) throws IOException {
            this.out.print(i);
        }

        public void print(long l) throws IOException {
            this.out.print(l);
        }

        public void print(float f) throws IOException {
            this.out.print(f);
        }

        public void print(double d) throws IOException {
            this.out.print(d);
        }

        public void println() throws IOException {
            this.out.println();
        }

        public void println(String s) throws IOException {
            this.out.println(s);
        }

        public void println(boolean b) throws IOException {
            this.out.println(b);
        }

        public void println(char c) throws IOException {
            this.out.println(c);
        }

        public void println(int i) throws IOException {
            this.out.println(i);
        }

        public void println(long l) throws IOException {
            this.out.println(l);
        }

        public void println(float f) throws IOException {
            this.out.println(f);
        }

        public void println(double d) throws IOException {
            this.out.println(d);
        }

        public boolean isReady() {
            return this.out.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.out.setWriteListener(writeListener);
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

