/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectoryProperties;
import com.atlassian.crowd.directory.loader.DbCachingRemoteDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.kantegasso.oidc.OidcData;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.FederatedIdentityResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.oidc.OidcDataCache;
import org.kantega.atlaskerb.identityproviders.oidc.OidcDataWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.OidcFactory;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcResponseEvaluator;
import org.kantega.atlaskerb.identityproviders.postprocessing.SsoLoginPostProcessor;
import org.kantega.atlaskerb.identityproviders.postprocessing.SsoPostProcessingResult;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.util.ErrorPageRenderer;
import org.kantega.atlaskerb.utils.CookieUtil;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.TestUtils;
import org.kantega.atlaskerb.websudo.WebSudoServlet;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ResumeOidcLoginServlet
extends HttpServlet {
    private static final String RELATIVE_SERVLET_URL = "/plugins/servlet/" + PluginKey.getPluginKeyBasepart() + "/callback";
    private static final Logger log = LoggerFactory.getLogger(ResumeOidcLoginServlet.class);
    private final ApplicationProperties applicationProperties;
    private final KerbConfManager kerbConfManager;
    private final UserManager userManager;
    private final OidcDataCache oidcDataCache;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final AuditLogFacade auditLogFacade;
    private final OidcResponseEvaluator responseEvaluator;
    private final ConnectorConfManager connectorConfManager;
    private final OidcLibWrapper oidcLibWrapper;
    private final String USERNAME_ATTR = ServiceProviderSpi.class.getName() + "_username";
    private final SafeRedirect safeRedirect;
    private final ErrorPageRenderer errorPageRenderer;
    private final SsoLoginPostProcessor ssoLoginPostProcessor;

    @Inject
    public ResumeOidcLoginServlet(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport UserManager userManager, OidcDataCache oidcDataCache, IdpConfManager idpConfManager, AuditLogFacade auditLogFacade, KerbConfManager kerbConfManager, OidcResponseEvaluator responseEvaluator, ConnectorConfManager connectorConfManager, SafeRedirect safeRedirect, HostAppFactory hostAppFactory, JsonWrapper jsonWrapper, OidcFactory oidcFactory, ErrorPageRenderer errorPageRenderer, SsoLoginPostProcessor ssoLoginPostProcessor) {
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
        this.oidcDataCache = oidcDataCache;
        this.idpConfManager = idpConfManager;
        this.kerbConfManager = kerbConfManager;
        this.auditLogFacade = auditLogFacade;
        this.connectorConfManager = connectorConfManager;
        this.responseEvaluator = responseEvaluator;
        this.safeRedirect = safeRedirect;
        this.hostApp = hostAppFactory.getInstance();
        this.oidcLibWrapper = oidcFactory.createOidcLibWrapper(jsonWrapper);
        this.errorPageRenderer = errorPageRenderer;
        this.ssoLoginPostProcessor = ssoLoginPostProcessor;
    }

    public static String getCallbackUrl(ApplicationProperties applicationProperties) {
        String baseUrl = applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        return ResumeOidcLoginServlet.getCallbackUrl(baseUrl);
    }

    public static String getCallbackUrl(String baseUrl) {
        return URI.create(baseUrl + RELATIVE_SERVLET_URL).toString();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        String state = req.getParameter("state");
        String code = req.getParameter("code");
        String error = req.getParameter("error");
        String errorDescription = req.getParameter("error_description");
        if (StringUtils.isBlank((CharSequence)state) || StringUtils.isBlank((CharSequence)code)) {
            if (error != null) {
                errors.add(error);
            }
            if (errorDescription != null) {
                errors.add(errorDescription);
            }
            if (errors.isEmpty()) {
                errors.add(ErrorUtils.createErrorMessage((String)"KSSO-B7O6HYJBLH", (String)"Did not retrieve a valid state and code pair from OpenID Connect provider."));
            }
            this.errorPageRenderer.renderErrors(Response.Status.BAD_REQUEST, Collections.singletonList(StringUtils.join(errors, (String)"; ")), null, resp);
            return;
        }
        Option maybeOidcResumeDataWrapper = this.oidcDataCache.pop(state).filter(oidcDataWrapper -> (Boolean)oidcDataWrapper.getOidcData().get("state").map(restoredState -> restoredState.equals(state)).getOrElse((Object)false));
        if (maybeOidcResumeDataWrapper.isEmpty()) {
            this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, ErrorUtils.createErrorMessage((String)" KSSO-CIK2G41VZA", (String)"Unable to resume login. Try logging in again."), null, resp);
            return;
        }
        OidcDataWrapper oidcResumeDataWrapper = (OidcDataWrapper)maybeOidcResumeDataWrapper.get();
        OidcData oidcResumeData = oidcResumeDataWrapper.getOidcData();
        String idpConfigurationId = oidcResumeDataWrapper.getIdpId();
        String targetUrl = oidcResumeDataWrapper.getTargetUrl();
        boolean isTest = oidcResumeDataWrapper.isTest();
        OidcIdpConfiguration idpConfiguration = (OidcIdpConfiguration)this.idpConfManager.getIdentityProviderById(idpConfigurationId);
        Either maybeResumed = this.oidcLibWrapper.resume(oidcResumeData, state, code).peekLeft(leftMessage -> {
            ErrorUtils.KssoError kssoError = ErrorUtils.createKssoError((String)"KSSO-I54BMS31JV", (String)("Failed OIDC resume login: " + leftMessage));
            log.error(kssoError.asMessage());
            if (isTest) {
                TestUtils.recordTestFailedAfterResponse(idpConfiguration, this.idpConfManager, oidcResumeData, kssoError, ResponseEvaluationCode.FAILED_OIDC_RESUME_LOGIN).onFailure(throwable -> log.warn(ErrorUtils.createErrorMessage((String)"KSSO-TP7XLL997P", (String)("Error recording test result: " + throwable.getMessage())), throwable));
            }
        });
        if (maybeResumed.isLeft()) {
            if (isTest) {
                TestUtils.renderTestResult(req, resp, idpConfiguration, this.idpConfManager, this.userManager, state);
            } else {
                String message = ErrorUtils.createErrorMessage((String)"KSSO-I54BMS31JV", (String)("Failed OIDC resume login: " + (String)maybeResumed.getLeft()));
                this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, message, null, resp);
            }
            return;
        }
        OidcData oidcDataAfterResume = (OidcData)maybeResumed.get();
        Option maybeProfileJson = oidcDataAfterResume.getProfile();
        if (maybeProfileJson.isEmpty()) {
            ErrorUtils.KssoError kssoError = ErrorUtils.createKssoError((String)"KSSO-5B9PSJG932", (String)"profile is empty.");
            log.error(kssoError.asMessage());
            if (isTest) {
                TestUtils.recordTestFailedAfterResponse(idpConfiguration, this.idpConfManager, (OidcData)maybeResumed.get(), kssoError, ResponseEvaluationCode.FAILED_OIDC_RESUME_LOGIN).onFailure(throwable -> log.warn(ErrorUtils.createErrorMessage((String)"KSSO-PS9T75D3O2", (String)("Error recording test result: " + throwable.getMessage())), throwable));
                TestUtils.renderTestResult(req, resp, idpConfiguration, this.idpConfManager, this.userManager, state);
            } else {
                this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, kssoError.asMessage(), null, resp);
            }
            return;
        }
        JSONObject profileJson = (JSONObject)maybeProfileJson.get();
        OidcResponseEvaluationResult evaluationResult = this.responseEvaluator.evaluate(idpConfiguration, profileJson, true);
        if (evaluationResult.isFailed()) {
            ErrorUtils.KssoError kssoError = ErrorUtils.createKssoError((String)"KSSO-W7OR4T3R8R", (String)("Response evaluation failed: " + evaluationResult.getErrorMessage()));
            log.error(kssoError.asMessage());
            if (isTest) {
                this.idpConfManager.recordOidcTestResult(idpConfigurationId, state, OidcResponseEvaluationResult.Builder.of(evaluationResult).setErrorMessage(kssoError.asMessage()).setCode(ResponseEvaluationCode.FAILED_OIDC_RESUME_LOGIN).build(), profileJson);
                TestUtils.recordTestFailedAfterResponse(idpConfiguration, this.idpConfManager, (OidcData)maybeResumed.get(), kssoError, ResponseEvaluationCode.FAILED_OIDC_RESUME_LOGIN).onFailure(throwable -> log.warn(ErrorUtils.createErrorMessage((String)"KSSO-9G5KATZURV", (String)("Error recording test result: " + throwable.getMessage())), throwable));
                TestUtils.renderTestResult(req, resp, idpConfiguration, this.idpConfManager, this.userManager, state);
            } else {
                this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, kssoError.asMessage(), null, resp);
            }
            return;
        }
        if (isTest) {
            this.idpConfManager.recordOidcTestResult(idpConfigurationId, state, evaluationResult, profileJson);
            TestUtils.recordTestProcedureAfterResponse(idpConfiguration, this.idpConfManager, (OidcData)maybeResumed.get(), evaluationResult.getCode());
            TestUtils.renderTestResult(req, resp, idpConfiguration, this.idpConfManager, this.userManager, state);
        } else {
            this.performAtlassianLogin(oidcDataAfterResume, targetUrl, evaluationResult, idpConfiguration, req, resp);
        }
    }

    private void performAtlassianLogin(OidcData oidcData, String requestedUrl, FederatedIdentityResponseEvaluationResult evaluationResult, OidcIdpConfiguration idpConfiguration, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!idpConfiguration.isEnabled()) {
            ErrorUtils.KssoError notEnabledError = ErrorUtils.createKssoError((String)"KSSO-W1SI9BE0KO", (String)String.format("Failed to resume OIDC login. Identity provider %s (%s) is not enabled.", idpConfiguration.getName(), idpConfiguration.getId()));
            log.warn(notEnabledError.asMessage());
            this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, notEnabledError.asMessage(), null, res);
            return;
        }
        if (!this.idpConfManager.isLicenseValid()) {
            this.errorPageRenderer.renderError(Response.Status.UNAUTHORIZED, "Kantega SSO Plugin license is not valid. Please contact your administrator.", requestedUrl, res);
            return;
        }
        SsoPostProcessingResult processingResult = this.ssoLoginPostProcessor.processSsoLoginAttempt(idpConfiguration, evaluationResult, requestedUrl);
        switch (processingResult.getExitCondition()) {
            case ANONYMOUS_BROWSING: {
                this.addSsoProtectedAnonymousBrowsingSession(idpConfiguration, req, res, evaluationResult.getSearchedUsername(), requestedUrl);
                break;
            }
            case SSO_LOGIN: {
                this.finishAtlassianLogin(oidcData, requestedUrl, evaluationResult, idpConfiguration, req, res);
                break;
            }
            default: {
                List<String> errors = Arrays.asList(processingResult.getMessage());
                this.errorPageRenderer.renderErrors(Response.Status.BAD_REQUEST, errors, requestedUrl, res);
            }
        }
    }

    private void finishAtlassianLogin(OidcData oidcData, String requestedUrl, FederatedIdentityResponseEvaluationResult evaluationResult, OidcIdpConfiguration idpConfiguration, HttpServletRequest req, HttpServletResponse res) throws IOException {
        PrincipalEntry principalEntry = evaluationResult.getResolvedPrincipalEntry();
        ArrayList<String> errors = new ArrayList<String>();
        String username = evaluationResult.getSearchedUsername();
        if (principalEntry != null && principalEntry.getPrincipal().isPresent()) {
            boolean canLogin;
            boolean isPrincipalFound;
            Principal principal = principalEntry.getPrincipal().get();
            Directory userDirectory = evaluationResult.getResolvedUserDirectory();
            if (userDirectory != null && userDirectory.getType() == DirectoryType.CROWD) {
                try {
                    this.authenticateUserInCrowdSSO(principal, userDirectory);
                }
                catch (OperationFailedException e) {
                    this.errorPageRenderer.renderError(Response.Status.UNAUTHORIZED, "Failed to authenticate user in remote Crowd directory", requestedUrl, res);
                    this.auditLogFacade.loginFailed(principal.getName(), "OIDC", "Failed to authenticate user in remote Crowd directory.");
                    return;
                }
            }
            boolean bl = isPrincipalFound = principalEntry.getUserState() == PrincipalEntry.UserState.FOUND;
            if (isPrincipalFound) {
                this.hostApp.publishUserAuthenticatedEvent(principalEntry.getPrincipal().get(), req, res);
            }
            if ((canLogin = this.hostApp.canLogin(principal, req)) && isPrincipalFound) {
                CookieUtil.setLastIdpAccountCookie(idpConfiguration.getId(), req, res);
                req.getSession().setAttribute("ksso.oidc.idtoken", oidcData.get("id_token").get());
                req.getSession().setAttribute("ksso.oidc.session.user", (Object)username);
                req.getSession().setAttribute("ksso.idp.id.session.key", (Object)idpConfiguration.getId());
                this.hostApp.authenticateWithProduct(req, res, principal);
                WebSudoServlet.setForcedAuthSessionId(req, idpConfiguration.getId());
                if (this.kerbConfManager.isRemembermeCookieEnabled()) {
                    this.hostApp.setRememberMeCookie(req, res, principal.getName());
                }
                this.safeRedirect.sendRedirect(ResumeOidcLoginServlet.prepareTargetUrl(requestedUrl, req.getContextPath()), req, res, this.hostApp);
                this.auditLogFacade.loginSuccess(principal.getName(), "OIDC with IdP: " + idpConfiguration.getName() + ", id: " + idpConfiguration.getId());
                return;
            }
            if (!canLogin) {
                if (ResumeOidcLoginServlet.tryDoubleRedirect(ResumeOidcLoginServlet.prepareTargetUrl(requestedUrl, req.getContextPath()), idpConfiguration, req, res, principalEntry, principal, this.hostApp, this.idpConfManager, this.safeRedirect)) {
                    return;
                }
                errors.add(String.format("Account does not have permission to use %s", this.applicationProperties.getDisplayName()));
                this.auditLogFacade.loginFailed(principal.getName(), "OIDC", String.format("Account does not have permission to use %s", this.applicationProperties.getDisplayName()));
            }
            if (principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) {
                errors.add(String.format("User %s is not active", principal.getName()));
                this.auditLogFacade.loginFailed(principal.getName(), "OIDC", "User is not active.");
            }
        }
        if (!errors.isEmpty()) {
            this.errorPageRenderer.renderErrors(Response.Status.UNAUTHORIZED, errors, requestedUrl, res);
        }
    }

    private static String prepareTargetUrl(String targetUrl, String contextPath) {
        if (StringUtils.isBlank((CharSequence)targetUrl) || StringUtils.startsWith((CharSequence)targetUrl, (CharSequence)(contextPath + "/plugins/servlet/" + PluginKey.getPluginKeyBasepart() + "/callback"))) {
            targetUrl = contextPath + "/";
        }
        return targetUrl;
    }

    public static boolean tryDoubleRedirect(String requestedUrl, IdpConfiguration idpConfiguration, HttpServletRequest req, HttpServletResponse res, PrincipalEntry principalEntry, Principal principal, HostApp hostApp, IdpConfManager idpConfManager, SafeRedirect safeRedirect) throws IOException {
        if (PrincipalEntry.UserState.FOUND.equals((Object)principalEntry.getUserState()) && hostApp.isUserInGroup(principal.getName(), hostApp.getDefaultLicenseGroup()) && idpConfManager.shouldUserBeDoubleRedirected(principal.getName())) {
            idpConfManager.setDoubleRedirectedUser(principal.getName());
            safeRedirect.sendRedirect(req.getContextPath() + "/plugins/servlet/no.kantega.saml/sp/" + idpConfiguration.getId() + "/login?target=" + HttpUrlUtils.urlEncode((String)requestedUrl), req, res, hostApp);
            return true;
        }
        return false;
    }

    private void addSsoProtectedAnonymousBrowsingSession(OidcIdpConfiguration idpConfiguration, HttpServletRequest req, HttpServletResponse resp, String username, String targetUrl) throws IOException {
        this.hostApp.addSsoProtectedAnonymousBrowsingSession(username, idpConfiguration, req, resp, targetUrl);
        log.debug("Added SSO-Verified Anonymous Access session after verified OIDC login for: " + (String)Option.of((Object)username).getOrElse((Object)"[anonymous]"));
        this.auditLogFacade.loginSuccess((String)Option.of((Object)username).getOrElse((Object)"[anonymous]"), "SSO-Verified Anonymous Access OIDC with IdP: " + idpConfiguration.getName() + ", id: " + idpConfiguration.getId());
    }

    private void authenticateUserInCrowdSSO(Principal principal, Directory userDirectory) throws OperationFailedException {
        String appName = (String)userDirectory.getAttributes().get("application.name");
        if (appName != null && this.connectorConfManager.getDirectory(appName) == null) {
            try {
                SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth groupSyncMode = SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.forDirectory((Attributes)userDirectory);
                if (groupSyncMode == SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.ALWAYS) {
                    DbCachingRemoteDirectoryInstanceLoader instanceLoader = (DbCachingRemoteDirectoryInstanceLoader)ComponentLocator.getComponent(DbCachingRemoteDirectoryInstanceLoader.class);
                    DbCachingRemoteDirectory directory = (DbCachingRemoteDirectory)instanceLoader.getDirectory(userDirectory);
                    RemoteCrowdDirectory crowdDirectory = (RemoteCrowdDirectory)this.hostApp.getAuthorativeDirectory(directory);
                    try {
                        String token = crowdDirectory.getCrowdClient().authenticateSSOUserWithoutValidatingPassword(new UserAuthenticationContext(principal.getName(), null, new ValidationFactor[0], null));
                        crowdDirectory.getCrowdClient().invalidateSSOToken(token);
                    }
                    catch (OperationFailedException e) {
                        log.debug("REST-call failed. Likely because of a remote jira");
                    }
                    catch (ApplicationAccessDeniedException | ApplicationPermissionException | InactiveAccountException | InvalidAuthenticationException e) {
                        log.error("Error authenticating user remotely", e);
                    }
                }
            }
            catch (NoClassDefFoundError e) {
                log.debug("Unable to perform user sync on login since Crowd API is too old and not compatible with triggering this. Sync will happen on next scheduled synchronisation");
            }
        }
    }
}

