/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.ValidationUtils;

public class CustomizableTextsAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final IdpConfManager idpConfManager;

    public CustomizableTextsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.idpConfManager = bucket.getIdpConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        this.renderView(resp, model);
    }

    private void renderView(HttpServletResponse resp, Map<String, Object> model) throws IOException {
        model.put("topMenu", "dashboard");
        model.put("menuItem", "customizable-texts");
        model.put("traditionalLoginDisabledMessage", this.kerbConfManager.getTraditionalLoginDisabledMessage());
        model.put("allTraditionalLoginDisabledMessage", this.kerbConfManager.getAllTraditionalLoginDisabledMessage());
        model.put("defaultTraditionalLoginDisabledMessage", this.kerbConfManager.getTraditionalLoginDisabledDefaultMessage());
        model.put("defaultAllTraditionalLoginDisabledMessage", this.kerbConfManager.getAllTraditionalLoginDisabledDefaultMessage());
        model.put("isJsmInstalled", this.kerbConfManager.isJsmInstalled());
        model.put("showInfoBoxOnJsmLogin", this.kerbConfManager.isShowInfoBoxOnJsmLogin());
        model.put("jsmCustomInfoBoxContentWithHtml", this.kerbConfManager.getJsmCustomInfoBoxContent());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/customizableTexts.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String traditionalLoginDisabledMessage = StringUtils.trim((String)req.getParameter("traditionalLoginDisabledMessage"));
        this.kerbConfManager.setTraditionalLoginDisabledMessage(StringUtils.isBlank((CharSequence)traditionalLoginDisabledMessage) ? this.kerbConfManager.getTraditionalLoginDisabledDefaultMessage() : traditionalLoginDisabledMessage);
        String allTraditionalLoginDisabledMessage = StringUtils.trim((String)req.getParameter("allTraditionalLoginDisabledMessage"));
        this.kerbConfManager.setAllTraditionalLoginDisabledMessage(StringUtils.isBlank((CharSequence)allTraditionalLoginDisabledMessage) ? this.kerbConfManager.getAllTraditionalLoginDisabledDefaultMessage() : allTraditionalLoginDisabledMessage);
        String isEnableJsmInfoBox = req.getParameter("showInfoBoxOnJsmLogin");
        this.kerbConfManager.setShowInfoBoxOnJsmLogin("on".equals(isEnableJsmInfoBox));
        String jsmCustomInfoBoxContent = StringUtils.trim((String)req.getParameter("jsmCustomInfoBoxContent"));
        boolean skipHtmlValidation = StringUtils.isNotBlank((CharSequence)req.getParameter("skipHtmlValidation"));
        if (!this.kerbConfManager.getJsmCustomInfoBoxContent().equals(StringUtils.trim((String)jsmCustomInfoBoxContent))) {
            if (ValidationUtils.isValidHtml((String)StringUtils.trim((String)jsmCustomInfoBoxContent)) || skipHtmlValidation) {
                this.kerbConfManager.setJsmCustomInfoBoxContent(StringUtils.trim((String)jsmCustomInfoBoxContent));
            } else {
                model.put("invalidHtmlDoNotRender", jsmCustomInfoBoxContent);
            }
        }
        this.renderView(resp, model);
    }
}

