/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.apitokens.latest.user;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.control.Option;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.apitokens.ApiTokenEntity;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetExpiryStatus {
    private static final Logger log = LoggerFactory.getLogger(GetExpiryStatus.class);

    public static Response run(HttpServletRequest request, String id, UserProfile userProfile, ApiTokenService apiTokenService, UserManager userManager) {
        block7: {
            Option maybeApiTokenObject;
            Option maybeSecret;
            block6: {
                maybeSecret = HttpUrlUtils.extractApiTokenFromBasicAuthHeader((HttpServletRequest)request);
                if (maybeSecret.isDefined()) break block6;
                if (id == null) break block7;
            }
            if ((maybeApiTokenObject = Option.of((Object)apiTokenService.findTokenById(id)).orElse(maybeSecret.flatMap(apiTokenService::findReadOnlyApiToken))).isDefined()) {
                ApiTokenEntity apiTokenObject = (ApiTokenEntity)maybeApiTokenObject.get();
                if (!StringUtils.equals((CharSequence)apiTokenObject.getUsername(), (CharSequence)userProfile.getUsername()) && !userManager.isSystemAdmin(userProfile.getUserKey())) {
                    log.warn("Forbidden: tried to check status on other user's API token");
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
                long timeUntilExpiryMillis = ApiTokenUtil.Time.calculateTimeUntilExpiry(apiTokenObject);
                JSONObject json = new JSONObject();
                json.put("id", apiTokenObject.getID());
                json.put("tokenName", (Object)apiTokenObject.getTokenName());
                json.put("description", (Object)apiTokenObject.getDescription());
                json.put("expiresAt", (Object)ApiTokenUtil.Time.getExpiryDateTime(apiTokenObject.getCreatedAt(), apiTokenObject.getValidFor()));
                if (timeUntilExpiryMillis >= 0L) {
                    json.put("timeUntilExpiryMillis", timeUntilExpiryMillis);
                    json.put("timeUntilExpiryDays", (Object)ApiTokenUtil.Time.convertMillisToDays(timeUntilExpiryMillis));
                }
                return Response.ok((Object)json.toString(4)).build();
            }
            String message = "Could not find API token in system to check expiry status";
            log.debug("Could not find API token in system to check expiry status");
            return ResponseUtils.errorWithMessageInJson(Response.Status.NOT_FOUND, "Could not find API token in system to check expiry status");
        }
        String message = "API Token or API token ID was not present in the request to check expiry status.";
        log.debug("API Token or API token ID was not present in the request to check expiry status.");
        return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "API Token or API token ID was not present in the request to check expiry status.");
    }
}

