/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.model;

import com.atlassian.crowd.embedded.api.Directory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DirectoryDto {
    private final Long id;
    private final String name;
    private final boolean active;
    private final String description;
    private final String type;
    private final Map<String, String> attributes;
    private final Set<String> allowedOperations;
    private final Date createdDate;
    private final Date updatedDate;

    private DirectoryDto(Long id, String name, boolean active, String description, String type, Map<String, String> attributes, Set<String> allowedOperations, Date createdDate, Date updatedDate) {
        this.id = id;
        this.name = name;
        this.active = active;
        this.description = description;
        this.type = type;
        this.attributes = attributes;
        this.allowedOperations = allowedOperations;
        this.createdDate = createdDate;
        this.updatedDate = updatedDate;
    }

    public static DirectoryDto from(Directory directory) {
        if (directory != null) {
            return new DirectoryDto(directory.getId(), directory.getName(), directory.isActive(), directory.getDescription(), directory.getType().name(), new HashMap<String, String>(directory.getAttributes()), directory.getAllowedOperations().stream().map(Enum::name).collect(Collectors.toSet()), directory.getCreatedDate(), directory.getUpdatedDate());
        }
        return null;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Set<String> getAllowedOperations() {
        return this.allowedOperations;
    }

    public Date getCreatedDate() {
        return Date.from(this.createdDate.toInstant());
    }

    public String getFormattedCreatedDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(this.createdDate);
    }

    public Date getUpdatedDate() {
        return Date.from(this.updatedDate.toInstant());
    }

    public String getFormattedUpdatedDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(this.updatedDate);
    }

    public static List<DirectoryDto> getVelocityCompatibleUserDirectories(List<Directory> directories) {
        return directories.stream().map(DirectoryDto::from).collect(Collectors.toList());
    }
}

