/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class TargetUrlParameterServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;

    public TargetUrlParameterServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostApp();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dark-features");
        model.put("menuItem", "targetUrlParameter");
        model.put("configuredUrlParameters", this.kerbConfManager.getConfiguredTargetUrlParameters());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/target-parameter-configuration.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String addUrl;
        String removeUrl = req.getParameter("removeParameter");
        if (StringUtils.isNotBlank((CharSequence)removeUrl)) {
            this.kerbConfManager.removeConfiguredTargetUrlParameters(removeUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)(addUrl = req.getParameter("addParameter")))) {
            addUrl = addUrl.trim();
            this.kerbConfManager.addConfiguredTargetUrlParameters(addUrl);
        }
        resp.sendRedirect("target-url-parameters");
    }
}

