/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.model.DirectoryDto;
import org.kantega.atlaskerb.utils.CookieUtil;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.GroupSearchUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableTraditionalLoginServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    public static final String HAS_USED_TRADITIONAL_LOGIN = "hasUsedTraditionalLogin";
    private final Logger log = LoggerFactory.getLogger(DisableTraditionalLoginServlet.class);

    @Inject
    public DisableTraditionalLoginServlet(RequireAdminServletDependencyBucket bucket, @ComponentImport PluginAccessor pluginAccessor) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String query = req.getParameter("query");
        if (query != null) {
            GroupSearchUtil.printGroupsAsJson(resp, query, this.userManager);
        } else {
            this.buildModelAndRenderTemplate(req, resp, new HashMap<String, Object>());
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        this.kerbConfManager.setTraditionalLoginPrevented(StringUtils.equals((CharSequence)"on", (CharSequence)req.getParameter("licensedTraditionalLoginPrevented")));
        this.kerbConfManager.setTraditionalLoginJsmPrevented(StringUtils.equals((CharSequence)"on", (CharSequence)req.getParameter("unlicensedTraditionalLoginPrevented")));
        String addGroup = StringUtils.trim((String)req.getParameter("addGroup"));
        String removeGroup = req.getParameter("removeGroup");
        if ("usersInGroupsSelected".equals(req.getParameter("usersInGroups"))) {
            if (!this.kerbConfManager.getDisallowTraditionalLoginGroups().isEmpty()) {
                this.kerbConfManager.setAllowTraditionalLoginGroups(this.kerbConfManager.emptyDisallowTraditionalLoginGroups());
            }
            if (StringUtils.isNotBlank((CharSequence)addGroup)) {
                this.kerbConfManager.addAllowTraditionalLoginGroups(addGroup);
            }
            if (StringUtils.isNotBlank((CharSequence)removeGroup)) {
                this.kerbConfManager.removeAllowTraditionalLoginGroups(removeGroup);
            }
        } else {
            if (!this.kerbConfManager.getAllowTraditionalLoginGroups().isEmpty()) {
                this.kerbConfManager.setDisallowTraditionalLoginGroups(this.kerbConfManager.emptyAllowTraditionalLoginGroups());
            }
            if (StringUtils.isNotBlank((CharSequence)addGroup)) {
                this.kerbConfManager.addDisallowTraditionalLoginGroups(addGroup);
            }
            if (StringUtils.isNotBlank((CharSequence)removeGroup)) {
                this.kerbConfManager.removeDisallowTraditionalLoginGroups(removeGroup);
            }
        }
        this.userLookupService.invalidateDirectoriesCache();
        for (Directory directory : this.userLookupService.getActiveUserDirectories()) {
            String enableButton = req.getParameter("traditionalLoginEnable" + directory.getId());
            try {
                ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
                HashMap<String, String> attrs = new HashMap<String, String>(directory.getAttributes());
                if ("on".equals(enableButton)) {
                    attrs.put("ksso.traditional.login.allowed", "true");
                } else {
                    attrs.put("ksso.traditional.login.allowed", "false");
                }
                builder.setAttributes(attrs);
                this.hostApp.getCrowdDirectoryService().updateDirectory(builder.toDirectory());
            }
            catch (UnsupportedOperationException u) {
                this.log.error(ErrorUtils.createErrorMessage((String)"KSSO-X7O8L3EC10", (String)("Unable to update directory " + directory.getName())), (Throwable)u);
            }
        }
        resp.sendRedirect("disableLogin");
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> additionalData) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        model.putAll(additionalData);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/disableLogin.vm", model, (Writer)resp.getWriter());
    }

    private Map<String, Object> buildModel(HttpServletRequest req) {
        Map<String, Object> model = this.newModel(req);
        this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "disableLogin");
        model.put("licensedTraditionalLoginPrevented", this.kerbConfManager.isTraditionalLoginPrevented());
        model.put("unlicensedTraditionalLoginPrevented", this.kerbConfManager.isTraditionalLoginJsmPrevented());
        model.put("homeDirectory", this.kerbConfManager.getKerberosHomeDirectoryPath());
        model.put("isJsmInstalled", this.kerbConfManager.isJsmInstalled());
        model.put("showInfoBoxOnJsmLogin", this.kerbConfManager.isShowInfoBoxOnJsmLogin());
        model.put("directories", this.userLookupService.getVelocityCompatibleActiveUserDirectories());
        model.put("KSSO_TRADITIONAL_LOGIN_ALLOWED", "ksso.traditional.login.allowed");
        if (!this.kerbConfManager.getDisallowTraditionalLoginGroups().isEmpty()) {
            model.put("allowGroupsSelected", false);
            model.put("groups", this.kerbConfManager.getDisallowTraditionalLoginGroups());
        } else {
            model.put("allowGroupsSelected", true);
            model.put("groups", this.kerbConfManager.getAllowTraditionalLoginGroups());
        }
        this.prepareAdminWarningIfUsernameLoginWasUsed(req, model);
        return model;
    }

    private void prepareAdminWarningIfUsernameLoginWasUsed(HttpServletRequest req, Map<String, Object> model) {
        boolean currentAdminInAnyEnabledGroup;
        String loggedInUsername = (String)Option.of((Object)this.userManager.getRemoteUser(req)).map(UserProfile::getUsername).getOrNull();
        boolean currentAdminInAnyEnabledDir = false;
        Directory userDir = null;
        if (loggedInUsername != null) {
            for (Directory dir : this.userLookupService.getActiveUserDirectories()) {
                if (!this.userLookupService.resolveUserInDirectory(dir, loggedInUsername, true).getPrincipal().isPresent()) continue;
                currentAdminInAnyEnabledDir = Objects.equals(dir.getAttributes().get("ksso.traditional.login.allowed"), "true");
                userDir = dir;
                break;
            }
        }
        if (!this.kerbConfManager.getDisallowTraditionalLoginGroups().isEmpty()) {
            model.put("allowGroupsSelected", false);
            model.put("groups", this.kerbConfManager.getDisallowTraditionalLoginGroups());
            currentAdminInAnyEnabledGroup = this.kerbConfManager.getDisallowTraditionalLoginGroups().stream().noneMatch(g -> this.hostApp.isUserInGroup(loggedInUsername, (String)g));
        } else {
            model.put("allowGroupsSelected", true);
            model.put("groups", this.kerbConfManager.getAllowTraditionalLoginGroups());
            currentAdminInAnyEnabledGroup = this.kerbConfManager.getAllowTraditionalLoginGroups().stream().anyMatch(g -> this.hostApp.isUserInGroup(loggedInUsername, (String)g));
        }
        List userGroups = this.hostApp.getAllGroups().stream().map(Group::getName).filter(group -> this.hostApp.isUserInGroup(loggedInUsername, (String)group)).collect(Collectors.toList());
        boolean hasUsedTraditionalLogin = Option.of((Object)req.getSession(false).getAttribute(HAS_USED_TRADITIONAL_LOGIN)).orElse(Option.of((Object)CookieUtil.getCookie(req, HAS_USED_TRADITIONAL_LOGIN))).isDefined();
        model.put("displayPreventTraditionalLoginWarning", !currentAdminInAnyEnabledGroup && !currentAdminInAnyEnabledDir);
        model.put("userDir", DirectoryDto.from(userDir));
        model.put("userGroups", userGroups);
        model.put(HAS_USED_TRADITIONAL_LOGIN, hasUsedTraditionalLogin);
    }
}

