/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.upgrade.configuration;

import io.vavr.collection.List;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.upgrade.data.UpgradeMessage;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.Version;

public class KerberosSettingsUpgrade {
    private final KerbConfManager kerbConfManager;
    private final UserLookupService userLookupService;

    public KerberosSettingsUpgrade(KerbConfManager kerbConfManager, UserLookupService userLookupService) {
        this.kerbConfManager = kerbConfManager;
        this.userLookupService = userLookupService;
    }

    public List<UpgradeMessage> run() {
        return List.of((Object)this.upgradeKerberosSettingsConfigurations());
    }

    public void updateKerberosUserPermission() {
        if (this.kerbConfManager.isKerberosEnabled()) {
            this.kerbConfManager.setKerberosUserPermission(KerbConfManager.KerberosUserPermissionType.ENABLE_ALL_USERS);
            this.kerbConfManager.setKerberosUserPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_IN_GROUP);
            this.kerbConfManager.setKerberosUserPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_OR_GROUP);
        } else if (!this.kerbConfManager.getAllowKerberosLoginGroups().isEmpty() && !this.userLookupService.getDirectoriesAllowingKerberosLogin().isEmpty()) {
            this.kerbConfManager.setKerberosUserPermission(KerbConfManager.KerberosUserPermissionType.ENABLE_SOME_USERS);
            this.kerbConfManager.setKerberosUserPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_IN_GROUP);
            this.kerbConfManager.setKerberosUserPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_OR_GROUP);
            this.kerbConfManager.setKerberosEnabled(true);
        } else if (!this.kerbConfManager.getDisallowKerberosLoginGroups().isEmpty() && !this.userLookupService.getDirectoriesAllowingKerberosLogin().isEmpty()) {
            this.kerbConfManager.setKerberosUserPermission(KerbConfManager.KerberosUserPermissionType.ENABLE_SOME_USERS);
            this.kerbConfManager.setKerberosUserPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_NOT_IN_GROUP);
            this.kerbConfManager.setKerberosUserPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_OR_GROUP);
            this.kerbConfManager.setKerberosEnabled(true);
        } else if (!this.kerbConfManager.getAllowKerberosLoginGroups().isEmpty()) {
            this.kerbConfManager.setKerberosUserPermission(KerbConfManager.KerberosUserPermissionType.ENABLE_SOME_USERS);
            this.kerbConfManager.setKerberosUserPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.GROUP);
            this.kerbConfManager.setKerberosUserPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_IN_GROUP);
            this.kerbConfManager.setKerberosEnabled(true);
        } else if (!this.kerbConfManager.getDisallowKerberosLoginGroups().isEmpty()) {
            this.kerbConfManager.setKerberosUserPermission(KerbConfManager.KerberosUserPermissionType.ENABLE_SOME_USERS);
            this.kerbConfManager.setKerberosUserPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.GROUP);
            this.kerbConfManager.setKerberosUserPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_NOT_IN_GROUP);
            this.kerbConfManager.setKerberosEnabled(true);
        } else if (!this.userLookupService.getDirectoriesAllowingKerberosLogin().isEmpty()) {
            this.kerbConfManager.setKerberosUserPermission(KerbConfManager.KerberosUserPermissionType.ENABLE_SOME_USERS);
            this.kerbConfManager.setKerberosUserPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY);
            this.kerbConfManager.setKerberosUserPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_IN_GROUP);
            this.kerbConfManager.setKerberosEnabled(true);
        } else {
            this.kerbConfManager.setKerberosUserPermission(KerbConfManager.KerberosUserPermissionType.DISABLE_ALL_USERS);
            this.kerbConfManager.setKerberosUserPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_OR_GROUP);
            this.kerbConfManager.setKerberosUserPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_IN_GROUP);
            this.kerbConfManager.setKerberosEnabled(false);
        }
    }

    @NotNull
    public UpgradeMessage upgradeKerberosSettingsConfigurations() {
        if (this.isBreakingChangesForKerberosUserPermissions()) {
            this.updateKerberosUserPermission();
            new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "Successfully upgraded Kantega SSO Enterprise Kerberos user permission configurations.");
        }
        return new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "Nothing to update");
    }

    public boolean isBreakingChanges() {
        return this.isBreakingChangesForKerberosUserPermissions();
    }

    private boolean isBreakingChangesForKerberosUserPermissions() {
        Version versionWithRefactoredKerberosUserPermissions = new Version("6.37.4");
        Version platform7versionWithRefactoredKerberosUserPermissions = new Version("7.37.4");
        Version currentConfigVersion = (Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrNull();
        if (currentConfigVersion == null) {
            return true;
        }
        if (currentConfigVersion.getMajor() == 6) {
            return versionWithRefactoredKerberosUserPermissions.isHigherThan(currentConfigVersion);
        }
        if (currentConfigVersion.getMajor() == 7) {
            return platform7versionWithRefactoredKerberosUserPermissions.isHigherThan(currentConfigVersion);
        }
        return false;
    }
}

