/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.security;

import com.atlassian.sal.api.ApplicationProperties;
import javax.servlet.http.Cookie;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

public class CookieSecurity {
    public static Cookie newHttpOnlyCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setHttpOnly(true);
        cookie.setSecure(false);
        return cookie;
    }

    public static Cookie newSecureHttpOnlyCookie(String name, String value) {
        Cookie cookie = CookieSecurity.newHttpOnlyCookie(name, value);
        cookie.setSecure(true);
        return cookie;
    }

    public static Cookie cookieWithDynamicSecurity(ApplicationProperties appProps, String name, String value) {
        return HttpUrlUtils.applicationUsesHttps((ApplicationProperties)appProps) ? CookieSecurity.newSecureHttpOnlyCookie(name, value) : CookieSecurity.newHttpOnlyCookie(name, value);
    }
}

