/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class SamlTestServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;

    @Inject
    public SamlTestServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration idp = this.idpConfManager.getIdentityProviderById(id);
        String action = req.getParameter("action");
        if ("delete".equals(action)) {
            String testId = req.getParameter("testId");
            this.idpConfManager.deleteTestDirectory(id, testId);
            resp.sendRedirect("test");
        } else if ("notification".equals(action)) {
            String notificationEmails = req.getParameter("notificationEmails");
            IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(idp);
            builder.setNotificationEmails(notificationEmails);
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
            resp.sendRedirect(this.idpConfManager.getServiceProviderNonAdminTestUrl(req, id));
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IdpConfiguration idp = this.idpConfManager.getIdentityProviderById(IdpConfManager.IdpServletUtil.getId(request));
        if (idp == null) {
            response.sendError(404);
            return;
        }
        response.setHeader("Cache-Control", "private, max-age=0, no-cache");
        response.setContentType("text/html");
        Map<String, Object> model = this.newModel(request);
        model.put("menuItem", "providerTest");
        model.put("topMenu", "SAML");
        model.put("dateTool", new DateTool());
        model.put("isSystemAdmin", true);
        model.put("idp", idp);
        model.put("recordedTests", this.idpConfManager.getRecordedTests(idp.getId()));
        model.put("shareURL", this.idpConfManager.getServiceProviderNonAdminTestUrl(request, idp.getId()));
        model.put("providerUrl", this.idpConfManager.getProviderAdminUrl(idp.getId(), request));
        model.put("samlConfigUrl", this.idpConfManager.getIdpConfigUrl(request));
        model.put("loginUrl", this.idpConfManager.getServiceProviderLoginUrl(request, idp.getId()));
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("ack", request.getParameter("ack") != null);
        this.renderer.render("templates/idp-login-test/test-overview.vm", model, (Writer)response.getWriter());
    }
}

