/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usergroups;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import kantega.shaded.com.fasterxml.jackson.databind.JsonNode;
import kantega.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import kantega.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import kantega.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.GetCleanupRule;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.utils.GroupSearchUtil;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="get-user-groups")
@PublicApi
public class GetUserGroups {
    private static final Logger log = LoggerFactory.getLogger(GetCleanupRule.class);
    UserManager userManager;
    JsonWrapper jsonWrapper;

    @Inject
    public GetUserGroups(@ComponentImport UserManager userManager, JsonWrapper jsonWrapper) {
        this.userManager = userManager;
        this.jsonWrapper = jsonWrapper;
    }

    private Response run(UserProfile userProfile, String query, UserManager userManager) {
        if (!userManager.isSystemAdmin(userProfile.getUserKey())) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.FORBIDDEN, "Missing access privileges");
        }
        try {
            List<Map<String, String>> groups = GroupSearchUtil.getGroupsAsListMap(query, userManager);
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode rootNode = mapper.createObjectNode();
            ArrayNode listGroups = mapper.createArrayNode();
            for (Map<String, String> value : groups) {
                ObjectNode group = mapper.createObjectNode();
                group.put("name", value.get("name"));
                group.put("id", value.get("id"));
                listGroups.add((JsonNode)group);
            }
            rootNode.putIfAbsent("groups", (JsonNode)listGroups);
            return (Response)this.jsonWrapper.tryBuildJsonString(rootNode).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
        }
        catch (Exception e) {
            log.error("Failed to map groups to object", (Throwable)e);
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Failed to map groups JSON to Object.");
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request, @QueryParam(value="query") String query) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, query, this.userManager)).onFailure(e -> log.error("Encountered an exception while atempting to GET user groups. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

