/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.intercept.model;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction2;
import io.vavr.CheckedFunction3;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.security.Principal;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.intercept.model.AuthMethod;
import org.kantega.atlaskerb.intercept.model.InterceptExitCondition;

public class InterceptResult {
    private final Option<Response.Status> httpStatus;
    private final Option<String> maybeUsername;
    private final Option<Principal> maybePrincipal;
    private final Option<Integer> failedLoginAttempts;
    private final InterceptExitCondition type;
    private final String message;
    private final AuthMethod authMethod;
    private final CheckedFunction3<ServletRequest, ServletResponse, FilterChain, Void> customFilterCallback;
    private final CheckedFunction2<HttpServletRequest, HttpServletResponse, Void> writeResponseCallback;
    private final Option<String> redirectTarget;

    private InterceptResult(Response.Status httpStatus, String username, Principal principal, Integer failedLoginAttempts, InterceptExitCondition type, String message, AuthMethod authMethod, CheckedFunction3<ServletRequest, ServletResponse, FilterChain, Void> customFilterCallback, CheckedFunction2<HttpServletRequest, HttpServletResponse, Void> writeResponseCallback, String target) {
        this.httpStatus = Option.of((Object)httpStatus);
        this.maybeUsername = Option.of((Object)username).filter(StringUtils::isNotBlank);
        this.maybePrincipal = Option.of((Object)principal);
        this.failedLoginAttempts = Option.of((Object)failedLoginAttempts);
        this.type = type;
        this.message = message;
        this.authMethod = authMethod;
        this.customFilterCallback = customFilterCallback;
        this.writeResponseCallback = writeResponseCallback;
        this.redirectTarget = Option.of((Object)target);
    }

    public InterceptResult(InterceptExitCondition type, String message, AuthMethod authMethod) {
        this.redirectTarget = Option.none();
        this.httpStatus = Option.none();
        this.maybeUsername = Option.none();
        this.maybePrincipal = Option.none();
        this.failedLoginAttempts = Option.none();
        this.type = type;
        this.message = message;
        this.authMethod = authMethod;
        this.customFilterCallback = null;
        this.writeResponseCallback = null;
    }

    public InterceptResult(InterceptExitCondition type, String message) {
        this.redirectTarget = Option.none();
        this.httpStatus = Option.none();
        this.maybeUsername = Option.none();
        this.maybePrincipal = Option.none();
        this.failedLoginAttempts = Option.none();
        this.type = type;
        this.message = message;
        this.authMethod = AuthMethod.UNKNOWN;
        this.customFilterCallback = null;
        this.writeResponseCallback = null;
    }

    public Option<Response.Status> getHttpStatus() {
        return this.httpStatus;
    }

    public Option<String> getMaybeUsername() {
        return this.maybeUsername;
    }

    public Option<Principal> getMaybePrincipal() {
        return this.maybePrincipal;
    }

    public Option<Integer> getMaybeFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    public InterceptExitCondition getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    public Option<String> getMaybeRedirectTarget() {
        return this.redirectTarget;
    }

    public Try<Void> writeRequestAndResponse(HttpServletRequest request, HttpServletResponse response) {
        if (this.writeResponseCallback != null) {
            return Try.of((CheckedFunction0 & Serializable)() -> (Void)this.writeResponseCallback.apply((Object)request, (Object)response));
        }
        if (this.type == InterceptExitCondition.LOGIN_FAILED) {
            return Try.run(() -> this.httpStatus.peek(status -> response.setStatus(status.getStatusCode())));
        }
        return Try.success(null);
    }

    public Try<Void> doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) {
        if (this.customFilterCallback != null) {
            return Try.of((CheckedFunction0 & Serializable)() -> (Void)this.customFilterCallback.apply((Object)req, (Object)resp, (Object)chain));
        }
        return Try.run(() -> chain.doFilter(req, resp));
    }

    public static Builder of(String message) {
        return new Builder(message);
    }

    public static Builder success(String message) {
        return InterceptResult.of(message).setType(InterceptExitCondition.LOGIN_SUCCESS);
    }

    public static InterceptResult passDownFilterChain() {
        return InterceptResult.of("Pass down filter chain").setType(InterceptExitCondition.PASS_DOWN_FILTER_CHAIN).build();
    }

    public static InterceptResult continueNext() {
        return new Builder("Passing to next intercept check").setType(InterceptExitCondition.NEXT_INTERCEPT).build();
    }

    public static InterceptResult continueNext(String message) {
        return new Builder(message).setType(InterceptExitCondition.NEXT_INTERCEPT).build();
    }

    public String toString() {
        return "InterceptResult{, username=" + (String)this.maybeUsername.getOrElse((Object)"anonymous") + ", type=" + this.type + ", message='" + this.message + "', authMethod=" + this.authMethod + ", httpStatus=" + (String)this.httpStatus.map(Response.Status::getStatusCode).map(String::valueOf).getOrElse((Object)"not set") + ", redirectTarget=" + (String)this.redirectTarget.getOrElse((Object)"not set") + ", customFilterCallbackNotNull=" + (this.customFilterCallback != null) + ", writeResponseCallbackNotNull=" + (this.writeResponseCallback != null) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InterceptResult)) {
            return false;
        }
        InterceptResult that = (InterceptResult)o;
        return Objects.equals(this.getHttpStatus(), that.getHttpStatus()) && Objects.equals(this.getMaybeUsername(), that.getMaybeUsername()) && Objects.equals(this.getMaybePrincipal(), that.getMaybePrincipal()) && this.getType() == that.getType() && this.getMessage().equals(that.getMessage()) && this.getAuthMethod() == that.getAuthMethod();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getMessage(), this.getAuthMethod()});
    }

    public static class Builder {
        private Response.Status httpStatus;
        private String username;
        private Principal principal;
        private Integer failedLoginAttempts;
        private InterceptExitCondition type;
        private final String message;
        private AuthMethod authMethod;
        private String redirectTarget;
        private CheckedFunction3<ServletRequest, ServletResponse, FilterChain, Void> customFilterCallback;
        private CheckedFunction2<HttpServletRequest, HttpServletResponse, Void> writeResponseCallback;

        public Builder(String message) {
            this.message = message;
            this.authMethod = AuthMethod.UNKNOWN;
        }

        public Builder setHttpStatus(Response.Status httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public Response.Status getHttpStatus() {
            return this.httpStatus;
        }

        public String getUsername() {
            return this.username;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Integer getFailedLoginAttempts() {
            return this.failedLoginAttempts;
        }

        public Builder setFailedLoginAttempts(Integer failedLoginAttempts) {
            this.failedLoginAttempts = failedLoginAttempts;
            return this;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public Builder setPrincipal(Principal principal) {
            this.principal = principal;
            return this;
        }

        public String getRedirectTarget() {
            return this.redirectTarget;
        }

        public String getMessage() {
            return this.message;
        }

        public AuthMethod getAuthMethod() {
            return this.authMethod;
        }

        public Builder setAuthMethod(AuthMethod authMethod) {
            this.authMethod = authMethod;
            return this;
        }

        public InterceptExitCondition getType() {
            return this.type;
        }

        public Builder setType(InterceptExitCondition interceptType) {
            this.type = interceptType;
            return this;
        }

        public Builder setRedirectTarget(String redirectTarget) {
            this.redirectTarget = redirectTarget;
            return this;
        }

        public CheckedFunction3<ServletRequest, ServletResponse, FilterChain, Void> getCustomFilterCallback() {
            return this.customFilterCallback;
        }

        public Builder setCustomFilterCallback(CheckedFunction3<ServletRequest, ServletResponse, FilterChain, Void> customFilterCallback) {
            this.customFilterCallback = customFilterCallback;
            return this;
        }

        public CheckedFunction2<HttpServletRequest, HttpServletResponse, Void> getWriteResponseCallback() {
            return this.writeResponseCallback;
        }

        public Builder setWriteResponseCallback(CheckedFunction2<HttpServletRequest, HttpServletResponse, Void> writeResponseCallback) {
            this.writeResponseCallback = writeResponseCallback;
            return this;
        }

        public InterceptResult build() {
            return new InterceptResult(this.httpStatus, this.username, this.principal, this.failedLoginAttempts, this.type, this.message, this.authMethod, this.customFilterCallback, this.writeResponseCallback, this.redirectTarget);
        }
    }
}

