/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.utils.InternetAddressUtils;

public class IpRestrictionFilter {
    private final String[] unblockedlist;
    private final String[] blockedlist;
    final KerbConfManager.IpRestrictionType restrictionType;

    IpRestrictionFilter(String[] unblockedlist, String[] blockedlist, KerbConfManager.IpRestrictionType restrictionType) {
        this.unblockedlist = unblockedlist;
        this.blockedlist = blockedlist;
        this.restrictionType = restrictionType;
    }

    public boolean isRemoteAddressEnabled(String remoteAddr) {
        if (this.restrictionType == KerbConfManager.IpRestrictionType.UNRESTRICTED) {
            return true;
        }
        boolean unblocked = InternetAddressUtils.isAddressPermissionMatch((String)remoteAddr, (String[])this.unblockedlist);
        boolean blocked = InternetAddressUtils.isAddressPermissionMatch((String)remoteAddr, (String[])this.blockedlist);
        if (this.restrictionType == KerbConfManager.IpRestrictionType.OPEN) {
            return !blocked || unblocked;
        }
        if (this.restrictionType == KerbConfManager.IpRestrictionType.STRICT) {
            return unblocked && !blocked;
        }
        return true;
    }

    public static class InheritingFilter
    extends IpRestrictionFilter {
        private final IpRestrictionFilter parentFilter;

        public InheritingFilter(String[] unblockedlist, String[] blockedlist, KerbConfManager.IpRestrictionType restrictionType, IpRestrictionFilter parentFilter) {
            super(unblockedlist, blockedlist, restrictionType);
            this.parentFilter = parentFilter;
        }

        @Override
        public boolean isRemoteAddressEnabled(String remoteAddr) {
            if (this.restrictionType == KerbConfManager.IpRestrictionType.UNRESTRICTED) {
                return this.parentFilter.isRemoteAddressEnabled(remoteAddr);
            }
            return super.isRemoteAddressEnabled(remoteAddr);
        }
    }
}

