/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.config;

import io.vavr.control.Either;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kantega.atlaskerb.KerbConfManager;

public class ConfigNameSpaces {

    public static enum KERBEROS_SETTINGS {
        KSSO_CONFIG_VERSION(KerbConfManager.KEYS.KSSO_CONFIG_VERSION.key),
        ADDITIONAL_USER_SUFFIX(KerbConfManager.KEYS.ADDITIONAL_USER_SUFFIX.key),
        LEGACY_REGEX_LOOKUP(KerbConfManager.KEYS.LEGACY_REGEX_LOOKUP.key),
        LEGACY_REGEX_REPLACEMENT(KerbConfManager.KEYS.LEGACY_REGEX_REPLACEMENT.key),
        REGEX_LOOKUP_ENABLED(KerbConfManager.KEYS.REGEX_LOOKUP_ENABLED.key),
        KERBEROS_MULTI_REGEX(KerbConfManager.KEYS.KERBEROS_MULTI_REGEX.key),
        ONLY_REGEX_TRANSFORMATION_LOOKUP(KerbConfManager.KEYS.ONLY_REGEX_TRANSFORMATION_LOOKUP.key),
        CROWD_AUTO_ADD_GROUPS(KerbConfManager.KEYS.CROWD_AUTO_ADD_GROUPS.key),
        LEGACY_GLOBAL_IP_BLOCKEDLIST(KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST.key),
        LEGACY_GLOBAL_IP_UNBLOCKEDLIST(KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST.key),
        GLOBAL_IP_BLOCKEDLIST(KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST.key),
        GLOBAL_IP_UNBLOCKEDLIST(KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST.key),
        GLOBAL_IP_RESTRICTION_TYPE(KerbConfManager.KEYS.GLOBAL_IP_RESTRICTION_TYPE.key),
        LEGACY_REST_IP_BLOCKEDLIST(KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST.key),
        LEGACY_REST_IP_UNBLOCKEDLIST(KerbConfManager.KEYS.LEGACY_REST_IP_UNBLOCKEDLIST.key),
        REST_IP_BLOCKEDLIST(KerbConfManager.KEYS.REST_IP_BLOCKEDLIST.key),
        REST_IP_UNBLOCKEDLIST(KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST.key),
        REST_IP_RESTRICTION_TYPE(KerbConfManager.KEYS.REST_IP_RESTRICTION_TYPE.key),
        CUSTOM_DISABLED_USER_AGENTS(KerbConfManager.KEYS.CUSTOM_DISABLED_USER_AGENTS.key),
        KEYTAB_FILE(KerbConfManager.KEYS.KEYTAB_FILE.key),
        VALID_USER_GROUPS(KerbConfManager.KEYS.VALID_USER_GROUPS.key),
        PRINCIPAL(KerbConfManager.KEYS.PRINCIPAL.key),
        REQUIRED_GROUP(KerbConfManager.KEYS.REQUIRED_GROUP.key),
        BITBUCKET_SCM_URLS_DEFAULT(KerbConfManager.KEYS.BITBUCKET_SCM_URLS_DEFAULT.key),
        BITBUCKET_SCM_URLS_ENABLED(KerbConfManager.KEYS.BITBUCKET_SCM_URLS_ENABLED.key),
        BITBUCKET_KERBEROS_SCM_URLS_ENABLED(KerbConfManager.KEYS.BITBUCKET_KERBEROS_SCM_URLS_ENABLED.key),
        BITBUCKET_SCM_URL_TYPES(KerbConfManager.KEYS.BITBUCKET_SCM_URL_TYPES.key),
        FAILURE_COLLECTION(KerbConfManager.KEYS.FAILURE_COLLECTION.key),
        KERBEROS_ENABLED(KerbConfManager.KEYS.KERBEROS_ENABLED.key),
        KERBEROS_USER_PERMISSION(KerbConfManager.KEYS.KERBEROS_USER_PERMISSION.key),
        KERBEROS_USER_PERMISSION_SOME(KerbConfManager.KEYS.KERBEROS_USER_PERMISSION_SOME.key),
        KERBEROS_USER_PERMISSION_GROUP(KerbConfManager.KEYS.KERBEROS_USER_PERMISSION_GROUP.key),
        KEYTAB_UPLOADED(KerbConfManager.KEYS.KEYTAB_UPLOADED.key),
        JIRA_REST_AUTH_ENABLED(KerbConfManager.KEYS.JIRA_REST_AUTH_ENABLED.key),
        KERBEROS_JSM_ENABLED(KerbConfManager.KEYS.KERBEROS_JSM_ENABLED.key),
        KERBEROS_KNOWLEDGEBASE_ENABLED(KerbConfManager.KEYS.KERBEROS_KNOWLEDGEBASE_ENABLED.key),
        REST_AUTH_ENABLED(KerbConfManager.KEYS.REST_AUTH_ENABLED.key),
        KERBEROS_REST_FROM_BROWSER_ENABLED(KerbConfManager.KEYS.KERBEROS_REST_FROM_BROWSER_ENABLED.key),
        USERNAME_ATTR_LOOKUP_ENABLED(KerbConfManager.KEYS.USERNAME_ATTR_LOOKUP_ENABLED.key),
        USER_PRINCIPAL_ATTR_LOOKUP_ENABLED(KerbConfManager.KEYS.USER_PRINCIPAL_ATTR_LOOKUP_ENABLED.key),
        WEBDAV_ENABLED(KerbConfManager.KEYS.WEBDAV_ENABLED.key),
        USER_DETAILS_IN_COMMENTS_ENABLED(KerbConfManager.KEYS.USER_DETAILS_IN_COMMENTS_ENABLED.key),
        ALLOW_KERBEROS_LOGIN_GROUPS(KerbConfManager.KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key),
        DISALLOW_KERBEROS_LOGIN_GROUPS(KerbConfManager.KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key),
        GROUP_ADD_MAPPING(KerbConfManager.KEYS.GROUP_ADD_MAPPING.key),
        LOOKUP_USERNAME_FROM_MAPPING_FILE(KerbConfManager.KEYS.LOOKUP_USERNAME_FROM_MAPPING_FILE.key),
        USE_LEGACY_KERBEROS(KerbConfManager.KEYS.USE_LEGACY_KERBEROS.key);

        public final ConfigSubset configSubset = ConfigSubset.KERBEROS;
        public final String key;

        private KERBEROS_SETTINGS(String key) {
            this.key = key;
        }

        public boolean hasAlias(String alias) {
            return this.key.equals(alias);
        }
    }

    public static enum COMMON_SETTINGS {
        PREEMPTIVE_AUTH_EXCLUDED_PATHS(KerbConfManager.KEYS.PREEMPTIVE_AUTH_EXCLUDED_PATHS.key),
        REST_EXCLUDED_PATHS(KerbConfManager.KEYS.REST_EXCLUDED_PATHS.key),
        PREFERRED_PROXY_HEADER(KerbConfManager.KEYS.PREFERRED_PROXY_HEADER.key),
        REQUIRE_LOGIN_ENABLED(KerbConfManager.KEYS.REQUIRE_LOGIN_ENABLED.key),
        SEND_TO_LOGIN_ENABLED(KerbConfManager.KEYS.SEND_TO_LOGIN_ENABLED.key),
        ERROR_PAGE_MESSAGE(KerbConfManager.KEYS.ERROR_PAGE_MESSAGE.key),
        TRADITIONAL_LOGIN_DISABLED_MESSAGE(KerbConfManager.KEYS.TRADITIONAL_LOGIN_DISABLED_MESSAGE.key),
        ALL_TRADITIONAL_LOGIN_DISABLED_MESSAGE(KerbConfManager.KEYS.ALL_TRADITIONAL_LOGIN_DISABLED_MESSAGE.key),
        BASIC_AUTH_IP_RESTRICTION_TYPE(KerbConfManager.KEYS.BASIC_AUTH_IP_RESTRICTION_TYPE.key),
        BASIC_AUTH_IP_BLOCKEDLIST(KerbConfManager.KEYS.BASIC_AUTH_IP_BLOCKEDLIST.key),
        BASIC_AUTH_IP_STRICT_BLOCKEDLIST(KerbConfManager.KEYS.BASIC_AUTH_IP_STRICT_BLOCKEDLIST.key),
        BASIC_AUTH_IP_STRICT_UNBLOCKEDLIST(KerbConfManager.KEYS.BASIC_AUTH_IP_STRICT_UNBLOCKEDLIST.key),
        BASIC_AUTH_IP_OPEN_BLOCKEDLIST(KerbConfManager.KEYS.BASIC_AUTH_IP_OPEN_BLOCKEDLIST.key),
        BASIC_AUTH_IP_OPEN_UNBLOCKEDLIST(KerbConfManager.KEYS.BASIC_AUTH_IP_OPEN_UNBLOCKEDLIST.key),
        BASIC_AUTH_IP_UNBLOCKEDLIST(KerbConfManager.KEYS.BASIC_AUTH_IP_UNBLOCKEDLIST.key),
        BASIC_AUTH_PERMISSION_TYPE(KerbConfManager.KEYS.BASIC_AUTH_PERMISSION_TYPE.key),
        BASIC_AUTH_PERMISSION_SOME_USERS_CONFIG(KerbConfManager.KEYS.BASIC_AUTH_PERMISSION_SOME_USERS_CONFIG.key),
        BASIC_AUTH_PERMISSION_GROUP(KerbConfManager.KEYS.BASIC_AUTH_PERMISSION_GROUP.key),
        ALLOW_TRADITIONAL_LOGIN_GROUPS(KerbConfManager.KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key),
        DISALLOW_TRADITIONAL_LOGIN_GROUPS(KerbConfManager.KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key),
        ALLOW_BASIC_AUTH_GROUPS(KerbConfManager.KEYS.ALLOW_BASIC_AUTH_GROUPS.key),
        DISALLOW_BASIC_AUTH_GROUPS(KerbConfManager.KEYS.DISALLOW_BASIC_AUTH_GROUPS.key),
        LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST(KerbConfManager.KEYS.LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST.key),
        MANUAL_LOGIN_LOG_ENABLED(KerbConfManager.KEYS.MANUAL_LOGIN_LOG_ENABLED.key),
        HEADER_USERNAME_IP_UNBLOCKEDLIST(KerbConfManager.KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST.key),
        HEADER_USERNAME_ATTRIBUTE(KerbConfManager.KEYS.HEADER_USERNAME_ATTRIBUTE.key),
        HEADERAUTH_USE_X_FORWARDED_FOR(KerbConfManager.KEYS.HEADERAUTH_USE_X_FORWARDED_FOR.key),
        HEADER_EMAIL_ATTRIBUTE(KerbConfManager.KEYS.HEADER_EMAIL_ATTRIBUTE.key),
        JSM_SIGNUP_EMAIL_UNBLOCKEDLIST(KerbConfManager.KEYS.JSM_SIGNUP_EMAIL_UNBLOCKEDLIST.key),
        JSM_SIGNUP_FORM_URLPARTS(KerbConfManager.KEYS.JSM_SIGNUP_FORM_URLPARTS.key),
        REMEMBERME_COOKIE_ENABLED(KerbConfManager.KEYS.REMEMBERME_COOKIE_ENABLED.key),
        KSSO_CONFIG_VERSION(KerbConfManager.KEYS.KSSO_CONFIG_VERSION.key),
        SAVED_HOSTAPP_SERVER_BASE_URL(KerbConfManager.KEYS.SAVED_HOSTAPP_SERVER_BASE_URL.key),
        FORCED_SSO_URLS(KerbConfManager.KEYS.FORCED_SSO_URLS.key),
        CONFIG_UPDATE_FAILURES(KerbConfManager.KEYS.CONFIG_UPDATE_FAILURES.key),
        MS_TEAMS_AUTHENTICATION_ENABLED(KerbConfManager.KEYS.MS_TEAMS_AUTHENTICATION_ENABLED.key),
        MS_TEAMS_SECURITY_HEADERS_ENABLED(KerbConfManager.KEYS.MS_TEAMS_SECURITY_HEADERS_ENABLED.key),
        SECURITY_HEADER_ALLOWED_HOST_NAMES(KerbConfManager.KEYS.SECURITY_HEADER_ALLOWED_HOST_NAMES.key),
        MS_TEAMS_CLIENT_ID(KerbConfManager.KEYS.MS_TEAMS_CLIENT_ID.key),
        MS_TEAMS_SECRET(KerbConfManager.KEYS.MS_TEAMS_SECRET.key),
        LDAP_FILTER_ENCODING(KerbConfManager.KEYS.LDAP_FILTER_ENCODING.key),
        LICENSE_EXPIRY_NOTIFICATIONS_SNOOZE(KerbConfManager.KEYS.LICENSE_EXPIRY_NOTIFICATIONS_SNOOZE.key),
        SEND_TO_DASHBOARD_AFTER_LOGIN(KerbConfManager.KEYS.SEND_TO_DASHBOARD_AFTER_LOGIN.key),
        COLLECT_LAST_USER_AGENTS_LIST_ENABLED(KerbConfManager.KEYS.COLLECT_LAST_USER_AGENTS_LIST_ENABLED.key),
        JSM_CUSTOM_INFO_BOX_CONTENT(KerbConfManager.KEYS.JSM_CUSTOM_INFO_BOX_CONTENT.key),
        SHOULD_HIDE_USERNAME_FIELD(KerbConfManager.KEYS.SHOULD_HIDE_USERNAME_FIELD.key),
        SHOW_INFO_BOX_ON_JSM_LOGIN(KerbConfManager.KEYS.SHOW_INFO_BOX_ON_JSM_LOGIN.key),
        SHOW_CUSTOM_TEXT_BOX_ON_LOGIN_PAGE(KerbConfManager.KEYS.SHOW_CUSTOM_TEXT_BOX_ON_LOGIN_PAGE.key),
        CUSTOM_TEXT_ON_LOGIN_PAGE(KerbConfManager.KEYS.CUSTOM_TEXT_ON_LOGIN_PAGE.key),
        LDAP_PASSWORD_ENCRYPTION_KEY(KerbConfManager.KEYS.LDAP_PASSWORD_ENCRYPTION_KEY.key),
        PASSWORD_LOGIN_GROUP_ADD_MAPPING(KerbConfManager.KEYS.PASSWORD_LOGIN_GROUP_ADD_MAPPING.key),
        CONTENT_SECURITY_POLICY_HOST_NAMES(KerbConfManager.KEYS.CONTENT_SECURITY_POLICY_HOST_NAMES.key),
        SAMESITE_COOKIE_POLICY(KerbConfManager.KEYS.SAMESITE_COOKIE_POLICY.key);

        public final String key;
        public final ConfigSubset configSubset = ConfigSubset.COMMON;

        private COMMON_SETTINGS(String key) {
            this.key = key;
        }

        public boolean hasAlias(String alias) {
            return this.key.equals(alias);
        }
    }

    public static enum API_TOKEN_SETTINGS {
        KSSO_CONFIG_VERSION(KerbConfManager.KEYS.KSSO_CONFIG_VERSION.key),
        API_TOKENS_ENABLED(KerbConfManager.KEYS.API_TOKENS_ENABLED.key),
        API_TOKENS_ADDITIONAL_BEARER_KEY(KerbConfManager.KEYS.API_TOKENS_ADDITIONAL_BEARER_KEY.key),
        USER_API_TOKEN_ENABLED(KerbConfManager.KEYS.USER_API_TOKEN_ENABLED.key),
        API_TOKEN_USER_PERMISSION(KerbConfManager.KEYS.API_TOKEN_USER_PERMISSION.key),
        API_TOKEN_ALLOWED_USER_GROUPS(KerbConfManager.KEYS.API_TOKEN_ALLOWED_USER_GROUPS.key),
        LEGACY_API_TOKEN_IP_BLOCKEDLIST(KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST.key),
        LEGACY_API_TOKEN_IP_UNBLOCKEDLIST(KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST.key),
        API_TOKEN_IP_BLOCKEDLIST(KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST.key),
        API_TOKEN_IP_UNBLOCKEDLIST(KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST.key),
        API_TOKEN_IP_RESTRICTION_TYPE(KerbConfManager.KEYS.API_TOKEN_IP_RESTRICTION_TYPE.key),
        API_TOKEN_USER_MAX_TIME_RESTRICTION(KerbConfManager.KEYS.API_TOKEN_USER_MAX_TIME_RESTRICTION.key),
        LOCKED_REST_API_ERROR_PAGE_MESSAGE(KerbConfManager.KEYS.LOCKED_REST_API_ERROR_PAGE_MESSAGE.key),
        API_TOKEN_ACCESS_URLS(KerbConfManager.KEYS.API_TOKEN_ACCESS_URLS.key),
        API_TOKEN_GROUP_TIME_RESTRICTIONS(KerbConfManager.KEYS.API_TOKEN_GROUP_TIME_RESTRICTIONS.key);

        public final String key;
        public final ConfigSubset configOption = ConfigSubset.API_TOKENS;

        private API_TOKEN_SETTINGS(String key) {
            this.key = key;
        }

        public boolean hasAlias(String alias) {
            return this.key.equals(alias);
        }
    }

    public static enum IDP_SETTINGS {
        KSSO_CONFIG_VERSION(KerbConfManager.KEYS.KSSO_CONFIG_VERSION.key),
        IDP_DISABLED_USER_AGENTS(KerbConfManager.KEYS.IDP_DISABLED_USER_AGENTS.key),
        SSO_ENABLED_FOR_USER_AVATAR(KerbConfManager.KEYS.SSO_ENABLED_FOR_USER_AVATAR.key),
        SAML_LOGIN_USERNAME_PLACEHOLDER(KerbConfManager.KEYS.SAML_LOGIN_USERNAME_PLACEHOLDER.key),
        USERNAME_FIELD_TEXT(KerbConfManager.KEYS.USERNAME_FIELD_TEXT.key),
        NEXT_BUTTON_TEXT(KerbConfManager.KEYS.NEXT_BUTTON_TEXT.key),
        IDP_LIST_TITLE_TEXT(KerbConfManager.KEYS.IDP_LIST_TITLE_TEXT.key),
        SHOULD_HIDE_USERNAME_FIELD(KerbConfManager.KEYS.SHOULD_HIDE_USERNAME_FIELD.key),
        SHARED_LOGIN_TITLE(KerbConfManager.KEYS.SHARED_LOGIN_TITLE.key),
        SHARED_LOGIN_SUBTITLE(KerbConfManager.KEYS.SHARED_LOGIN_SUBTITLE.key),
        SHARED_LOGIN_ALTERNATIVE_DIVIDER(KerbConfManager.KEYS.SHARED_LOGIN_ALTERNATIVE_DIVIDER.key),
        SHARED_CANNOT_LOGIN_TEXT(KerbConfManager.KEYS.SHARED_CANNOT_LOGIN_TEXT.key),
        AUTOMATIC_TRADITIONAL_LOGIN_BUTTON_TEXT(KerbConfManager.KEYS.AUTOMATIC_TRADITIONAL_LOGIN_BUTTON_TEXT.key),
        MANUAL_USERNAME_LOGIN_SUBTITLE(KerbConfManager.KEYS.MANUAL_USERNAME_LOGIN_SUBTITLE.key),
        MANUAL_USERNAME_PLACEHOLDER_TEXT(KerbConfManager.KEYS.MANUAL_USERNAME_PLACEHOLDER_TEXT.key),
        MANUAL_CONTINUE_BUTTON_TEXT(KerbConfManager.KEYS.MANUAL_CONTINUE_BUTTON_TEXT.key),
        REDIRECT_REDIRECTION_TEXT(KerbConfManager.KEYS.REDIRECT_REDIRECTION_TEXT.key),
        REDIRECT_CANCEL_REDIRECT_BUTTON_TEXT(KerbConfManager.KEYS.REDIRECT_CANCEL_REDIRECT_BUTTON_TEXT.key),
        REDIRECT_REDIRECTION_HINT(KerbConfManager.KEYS.REDIRECT_REDIRECTION_HINT.key),
        ATLASSIAN_USE_SSO_BUTTON_TEXT(KerbConfManager.KEYS.ATLASSIAN_USE_SSO_BUTTON_TEXT.key),
        ALLOW_LEGACY_SAFE_REDIRECT(KerbConfManager.KEYS.ALLOW_LEGACY_SAFE_REDIRECT.key);

        public final String key;
        public final ConfigSubset configOption = ConfigSubset.IDP;

        private IDP_SETTINGS(String key) {
            this.key = key;
        }

        public boolean hasAlias(String alias) {
            return this.key.equals(alias);
        }
    }

    public static enum USER_CLEANUP_SETTINGS {
        KSSO_CONFIG_VERSION(KerbConfManager.KEYS.KSSO_CONFIG_VERSION.key),
        USER_CLEANUP_RULE(KerbConfManager.KEYS.USER_CLEANUP_RULE.key),
        JSM_CLEANUP_RULE(KerbConfManager.KEYS.JSM_CLEANUP_RULE.key);

        public final String key;
        public final ConfigSubset configSubset = ConfigSubset.USER_CLEANUP;

        private USER_CLEANUP_SETTINGS(String key) {
            this.key = key;
        }

        public boolean hasAlias(String alias) {
            return this.key.equals(alias);
        }
    }

    public static enum ConfigSubset {
        COMMON("config_subset:common", "Common settings"),
        KERBEROS("config_subset:kerberos", "Kerberos settings"),
        IDP("config_subset:idp", "Identity Providers settings"),
        USER_CLEANUP("config_subset:userCleanup", "User Cleanup settings"),
        CLOUD_USER_PROVISIONING("config_subset:cloudUserProvisioning", "Cloud User Provisioning settings"),
        API_TOKENS("config_subset:apiTokens", "API Tokens settings");

        public final String key;
        public final String displayName;

        private ConfigSubset(String key, String displayName) {
            this.key = key;
            this.displayName = displayName;
        }

        public static ConfigSubset fromKey(String configSubsetStringKey) {
            for (ConfigSubset configSubset : ConfigSubset.values()) {
                if (!configSubset.key.equals(configSubsetStringKey)) continue;
                return configSubset;
            }
            throw new IllegalArgumentException("Illegal argument: " + configSubsetStringKey);
        }

        public static Set<Either<String, ConfigSubset>> fromStringList(List<String> subsetStrings) {
            if (subsetStrings == null) {
                throw new IllegalArgumentException("Subset strings cannot be null");
            }
            HashSet<Either<String, ConfigSubset>> configSubsets = new HashSet<Either<String, ConfigSubset>>();
            for (String subsetString : subsetStrings) {
                try {
                    configSubsets.add((Either<String, ConfigSubset>)Either.right((Object)((Object)ConfigSubset.fromKey(subsetString))));
                }
                catch (IllegalArgumentException e) {
                    configSubsets.add((Either<String, ConfigSubset>)Either.left((Object)("Unable to parse subset string" + subsetString + ": " + e.getMessage())));
                }
            }
            return configSubsets;
        }

        public String getKey() {
            return this.key;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static List<ConfigSubset> getValues() {
            return Arrays.asList(ConfigSubset.values());
        }
    }
}

