/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.kantegasso.runtimetrust.Fingerprint;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.RequireLoggedInUserServlet;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.kerberos.servlet.ConfigureIpRestrictionsAction;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.upgrade.data.UpgradeMessage;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequireAdminServlet
extends RequireLoggedInUserServlet {
    private static final Logger log = LoggerFactory.getLogger(RequireAdminServlet.class);
    public final UserManager userManager;
    public final TemplateRenderer templateRenderer;
    public final WebSudoManager webSudoManager;
    public final PluginLicenseManager pluginLicenseManager;
    public final HostApp hostApp;
    public final UserLookupService userLookupService;
    public final ApplicationProperties applicationProperties;
    public final PluginAccessor pluginAccessor;
    public final KerbConfManager kerbConfManager;
    public final ScimConfManager scimConfManager;
    public final IdpConfManager idpConfManager;
    public final ConnectorConfManager connectorConfManager;
    public final OidcLibWrapper oidcLibWrapper;
    public final KssoUpgradeManager kssoUpgradeManager;
    private final SecureRandom random = new SecureRandom();

    public RequireAdminServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket.getUserManager(), bucket.getLoginUriProvider());
        this.userManager = bucket.getUserManager();
        this.templateRenderer = bucket.getTemplateRenderer();
        this.webSudoManager = bucket.getWebSudoManager();
        this.pluginLicenseManager = bucket.getPluginLicenseManager();
        this.hostApp = bucket.getHostApp();
        this.userLookupService = bucket.getUserLookupService();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.scimConfManager = bucket.getScimConfManager();
        this.oidcLibWrapper = bucket.getOidcFactory().createOidcLibWrapper(bucket.getJsonWrapper());
        this.applicationProperties = bucket.getApplicationProperties();
        this.pluginAccessor = bucket.getPluginAccessor();
        this.kssoUpgradeManager = bucket.getKssoUpgradeManager();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            if (this.kssoUpgradeManager.isKssoConfigUpgradeNeeded() && !this.kssoUpgradeManager.hasUpgradeFailures() && this.isPageThatShouldUpdateConfigAutomatically(req)) {
                List<UpgradeMessage> list = this.kssoUpgradeManager.doUpgrade();
            } else if (this.kerbConfManager.getSavedKssoConfigVersion().isEmpty()) {
                this.kerbConfManager.upgradeKssoVersionInConfig();
            }
        }
        catch (Exception e) {
            log.error("Encountered an error during upgrade.", (Throwable)e);
        }
        this.checkAndUpdateSavedBaseUrl(req);
    }

    private void checkAndUpdateSavedBaseUrl(HttpServletRequest req) {
        this.kerbConfManager.getSavedHostappBaseUrl().peek(savedBaseUrl -> {
            String requestBaseUrl = HttpUrlUtils.getRequestBaseUrl((HttpServletRequest)req);
            if (StringUtils.isNotBlank((CharSequence)savedBaseUrl) && !savedBaseUrl.equals(HttpUrlUtils.getRequestBaseUrl((HttpServletRequest)req))) {
                this.kerbConfManager.setHostappBaseUrlChanged(HttpUrlUtils.getRequestBaseUrl((HttpServletRequest)req));
            } else if (savedBaseUrl.equals(requestBaseUrl) && this.kerbConfManager.getHostappBaseUrlChanged().isDefined()) {
                this.kerbConfManager.removeHostappBaseUrlChanged();
            }
        }).onEmpty(() -> this.kerbConfManager.setSavedHostappBaseUrl(HttpUrlUtils.getRequestBaseUrl((HttpServletRequest)req)));
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Cache-Control", "private, max-age=0, no-cache");
        UserKey remoteUserKey = this.userManager.getRemoteUserKey(request);
        if (remoteUserKey == null) {
            this.redirectToLogin(request, response);
            return;
        }
        if (!this.userManager.isSystemAdmin(remoteUserKey)) {
            response.setContentType("text/html");
            response.sendError(401, "Page requires system administrator access");
            return;
        }
        this.ensureCsrfTokenInSession(request);
        try {
            if (!this.expectsMultipart() && !this.checkCsrf(request)) {
                this.renderCsrfFailed(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest(request);
            if (this.hostApp.isModificationOnGetSupported() && request.getMethod().equalsIgnoreCase("GET") || request.getMethod().equalsIgnoreCase("POST")) {
                if (this.kssoUpgradeManager.isKssoConfigUpgradeNeeded() && !this.kssoUpgradeManager.hasUpgradeFailures() && !this.kssoUpgradeManager.hasBadVersionUpgrade()) {
                    if (this.isPageThatShouldUpdateConfigAutomatically(request)) {
                        List<UpgradeMessage> list = this.kssoUpgradeManager.doUpgrade();
                    }
                } else if (this.kerbConfManager.getSavedKssoConfigVersion().isEmpty() && !this.kerbConfManager.hasKerberosFolder()) {
                    this.kerbConfManager.upgradeKssoVersionInConfig();
                }
            }
            if (!"BAMBOO".equalsIgnoreCase(this.applicationProperties.getDisplayName())) {
                this.checkAndUpdateSavedBaseUrl(request);
            }
            super.service(request, response);
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
        catch (CsrfException e) {
            this.renderCsrfFailed(request, response);
        }
        catch (Exception e) {
            log.error("Error in RequireAdminServlet", (Throwable)e);
            response.setContentType("text/html");
            response.sendError(500, "Error in RequireAdminServlet: " + StringEscapeUtils.escapeHtml4((String)e.getMessage()));
        }
    }

    private boolean isPageThatShouldUpdateConfigAutomatically(HttpServletRequest request) {
        String requestUri = HttpUrlUtils.getInternalPath((HttpServletRequest)request);
        return !requestUri.equals(this.kerbConfManager.getPluginRootUri() + "/dark-features") && !requestUri.equals(this.kerbConfManager.getPluginRootUri() + "/support") && !requestUri.equals(this.kerbConfManager.getPluginRootUri() + "/debuginfo") && !requestUri.equals(this.kerbConfManager.getPluginRootUri() + "/backup") && !requestUri.equals(this.kerbConfManager.getPluginRootUri() + "/config-status") && !requestUri.equals(this.kerbConfManager.getPluginRootUri() + "/dashboard") && !requestUri.equals(this.kerbConfManager.getPluginRootUri() + "/create-backup");
    }

    private void renderCsrfFailed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setStatus(400);
        this.templateRenderer.render("templates/atlaskerb/csrf-failed.vm", this.newModel(request), (Writer)response.getWriter());
    }

    private boolean checkCsrf(HttpServletRequest request) {
        boolean tokenIsValid;
        HttpSession httpSession = request.getSession();
        if (this.isSafeHttpMethod(request)) {
            return true;
        }
        this.ensureCsrfTokenInSession(request);
        String token_param = request.getParameter("krb_token");
        String token = (String)httpSession.getAttribute("krb_csrf_token");
        boolean bl = tokenIsValid = token != null && token.equals(token_param);
        if (this.kerbConfManager.isCsrfOriginCheckEnabled()) {
            return tokenIsValid && this.isSameOriginOrReferer(request);
        }
        return tokenIsValid;
    }

    private boolean isSameOriginOrReferer(HttpServletRequest request) {
        Try expectedOrigin = Try.of((CheckedFunction0 & Serializable)() -> new URI(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)).getAuthority());
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> (String)List.of((Object[])new String[]{"Origin", "Referer"}).map(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)).filter(Objects::nonNull).peek()).mapTry((CheckedFunction1 & Serializable)requestOrigin -> new URI((String)requestOrigin).getAuthority().equals(expectedOrigin.get())).onFailure(throwable -> log.warn("[KSSO CSRF] NOT OK | " + String.format("Origin: %s | Referer: %s | Expected: %s | Application Base URL: %s", request.getHeader("Origin"), request.getHeader("Referer"), expectedOrigin.getOrElse((Object)"Not able to parse."), this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)))).getOrElse((Object)true);
    }

    private boolean isSafeHttpMethod(HttpServletRequest request) {
        return List.of((Object[])new String[]{"GET", "HEAD", "OPTIONS", "TRACE"}).contains((Object)request.getMethod());
    }

    private void ensureCsrfTokenInSession(HttpServletRequest request) {
        if (request.getSession().getAttribute("krb_csrf_token") == null) {
            byte[] passwordBytes = new byte[32];
            this.random.nextBytes(passwordBytes);
            String token = Fingerprint.sha1Fingerprint((byte[])passwordBytes);
            request.getSession().setAttribute("krb_csrf_token", (Object)token);
        }
    }

    @Override
    protected Map<String, Object> newModel(HttpServletRequest req) {
        boolean isSamlEnabled;
        Map<String, Object> model = super.newModel(req);
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        model.put("pluginAdminPath", contextPath + "/plugins/servlet/" + PluginKey.getPluginKeyBasepart());
        model.put("pluginKey", PluginKey.getPluginKey());
        model.put("pluginKeyBasePart", PluginKey.getPluginKeyBasepart());
        model.put("defaultSSOProductKey", PluginKey.getDefaultSSOProductKey());
        model.put("pluginResource", PluginKey.getPluginKey() + ":entrypoint-atlaskerb");
        String basePath = (String)Try.of((CheckedFunction0 & Serializable)() -> new URL(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)).getPath()).getOrElse((Object)"");
        model.put("basePath", basePath);
        Option maybeLicense = this.pluginLicenseManager.getLicense();
        if (maybeLicense.isDefined()) {
            this.populateModelWithLicenseInfo(model, (Option<PluginLicense>)maybeLicense);
        }
        String installedPluginVersion = (String)io.vavr.control.Option.of((Object)this.pluginAccessor).map(pluginAccessor -> pluginAccessor.getPlugin(this.pluginLicenseManager.getPluginKey())).map(Plugin::getPluginInformation).map(PluginInformation::getVersion).getOrElse((Object)"UNKNOWN");
        model.put("installedPluginVersion", installedPluginVersion);
        model.put("kssoVersionOver7", KerbConfManager.getRunningKssoVersion().isHigherThanOrEqualTo(Version.of((String)"7.0.0")));
        model.put("shouldUseLegacyLoginExperience", this.hostApp.shouldUseLegacyLoginExperience());
        String requestURI = req.getRequestURI();
        if (requestURI.contains("/saml/")) {
            model.put("topMenu", "SAML");
            model.put("connectorTool", new ConnectorTool(this.connectorConfManager));
        } else {
            model.put("topMenu", "Kerberos");
            model.put("supportsRemoveAllRememberMeTokens", this.hostApp.supportsRemoveAllRememberMeTokens());
            model.put("hasRestApi", this.hostApp.hasRestApi());
            model.put("hasWritableCrowd", this.userLookupService.hasWritableCrowdDirectory());
            model.put("kerberosEnabled", this.kerbConfManager.isKerberosEnabled());
            model.put("preemptivePaths", this.hostApp.getRequireLoginPathMappings());
            IpRestrictionConfig restrictionCfg = this.kerbConfManager.getIpRestrictionConfig();
            ConfigureIpRestrictionsAction.populateModel(model, restrictionCfg);
        }
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("displaySingleLogout", !this.hostApp.isProductMatch("fecru"));
        model.put("applicationProperties", this.kerbConfManager.getApplicationProperties());
        model.put("platformId", this.kerbConfManager.getApplicationProperties().getPlatformId());
        model.put("isKerberosConfigured", this.kerbConfManager.isKeytabConfigured());
        model.put("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        model.put("isIdpConfigured", !this.idpConfManager.getIdentityProviders().isEmpty());
        model.put("hasIdpDrafts", !this.idpConfManager.getDrafts().isEmpty());
        model.put("hasKssoUpgradeErrors", this.kssoUpgradeManager.hasUpgradeFailures());
        model.put("hasApiTokenUpgradeErrors", this.kssoUpgradeManager.getUpgradeFailures().exists(upgradeConfigResult -> upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST));
        model.put("hasIpRestrictUpgradeErrors", this.kssoUpgradeManager.getUpgradeFailures().exists(upgradeConfigResult -> upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_REST_IP_UNBLOCKEDLIST));
        model.put("hasHeaderAuthUpgradeErrors", this.kssoUpgradeManager.getUpgradeFailures().exists(upgradeConfigResult -> upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST));
        model.put("kssoConfigUpdateNeeded", this.kssoUpgradeManager.isKssoConfigUpgradeNeeded());
        model.put("hasBadVersionUpgrade", this.kssoUpgradeManager.hasBadVersionUpgrade());
        model.put("isCloudConnectorsConfigured", !this.connectorConfManager.getDirectories().isEmpty() || !this.scimConfManager.getTenantConfigs().isEmpty());
        model.put("crowdDirectoryFinder", new CrowdDirectoryFinder(this.hostApp));
        model.put("isScimEnabled", this.scimConfManager.isScimEnabled());
        String page = requestURI.substring(requestURI.lastIndexOf("/") + 1);
        if (!page.isEmpty()) {
            model.put("menuItem", page);
        }
        model.put("backUrl", this.validateURLInput(req.getParameter("backUrl")));
        model.put("backLinkDescription", req.getParameter("backLinkDescription"));
        model.put("isJsdInstalled", this.kerbConfManager.isJsmInstalled());
        model.put("hasMultipleIdentityProviders", this.idpConfManager.hasMultipleIdentityProviders());
        boolean bl = isSamlEnabled = this.idpConfManager.hasEnabledSamlProviders() && this.idpConfManager.isFederatedSsoEnabled();
        if (isSamlEnabled) {
            try {
                X509Certificate activeCert = this.idpConfManager.parseCert(this.idpConfManager.getSigningCert());
                model.put("isValidCertificate", CertTool.isValidCertificate(activeCert, 0));
                model.put("isExpiringSoonCertificate", CertTool.isExpiringSoon(activeCert));
            }
            catch (Exception e) {
                log.debug("Failed to obtain certificates for checking expiry: ", (Throwable)e);
            }
        }
        model.put("isSamlEnabled", isSamlEnabled);
        model.put("warnSamlKeyExpires", this.idpConfManager.isWarnSamlKeyExpires());
        model.put("samlEnabled", this.idpConfManager.isFederatedSsoEnabled());
        return model;
    }

    private String validateURLInput(String backUrl) {
        if (backUrl != null) {
            try {
                URI uri = new URI(backUrl);
                return uri.getQuery() != null ? uri.getPath() + "?" + uri.getQuery() : uri.getPath();
            }
            catch (URISyntaxException e) {
                log.error("Not valid backlink url", (Throwable)e);
            }
        }
        return null;
    }

    private void populateModelWithLicenseInfo(Map<String, Object> model, Option<PluginLicense> maybeLicense) {
        PluginLicense license = (PluginLicense)maybeLicense.get();
        model.put("licenseExists", true);
        model.put("licenseIsValid", license.isValid());
        if (license.getError().isDefined()) {
            model.put("licenseErrorName", ((LicenseError)license.getError().get()).name());
        }
        model.put("licenseType", license.getLicenseType().name());
        model.put("licenseMaximumUsers", license.getMaximumNumberOfUsers());
    }

    protected TemplateRenderer getTemplateRenderer() {
        return this.templateRenderer;
    }

    protected boolean expectsMultipart() {
        return false;
    }

    protected MultipartHttpRequest getMultipartRequest(HttpServletRequest request, long maxSize) throws IOException {
        if (!this.expectsMultipart()) {
            throw new IllegalArgumentException("Servlet has not declared that it expects multipart/form-data");
        }
        MultipartHttpRequest multipartRequest = this.hostApp.getMultipartRequest(request, maxSize);
        if (!this.checkCsrf((HttpServletRequest)multipartRequest)) {
            throw new CsrfException();
        }
        return multipartRequest;
    }

    protected io.vavr.control.Option<String> getSafeParameter(String parameter, HttpServletRequest request) {
        return io.vavr.control.Option.of((Object)request.getParameter(parameter)).map(StringUtils::trim).filter(StringUtils::isNotBlank);
    }

    private static class CsrfException
    extends SecurityException {
        private CsrfException() {
        }
    }

    public static class ConnectorTool {
        private final ConnectorConfManager connectorConfManager;

        ConnectorTool(ConnectorConfManager connectorConfManager) {
            this.connectorConfManager = connectorConfManager;
        }

        public boolean hasConnectorForKind(IdpConfiguration.Kind kind) {
            for (ConnectorType connectorType : this.connectorConfManager.getConnectorTypes().values()) {
                if (connectorType.getIdentityProviderKind() != kind) continue;
                return true;
            }
            return false;
        }
    }
}

