/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.security.CookieSecurity;

@UnrestrictedAccess
public class RememberJsmLogoutFilter
implements Filter {
    private final ApplicationProperties applicationProperties;
    private final IdpConfManager idpConfManager;

    @Inject
    RememberJsmLogoutFilter(@ComponentImport ApplicationProperties applicationProperties, IdpConfManager idpConfManager) {
        this.applicationProperties = applicationProperties;
        this.idpConfManager = idpConfManager;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String sessionCookieValue = null;
        IdpConfiguration idpConf = null;
        String idpIdSessionKey = (String)req.getSession().getAttribute("ksso.idp.id.session.key");
        if (idpIdSessionKey != null) {
            Object samlSessionIdentification;
            idpConf = this.idpConfManager.getIdentityProviderById(idpIdSessionKey);
            sessionCookieValue = idpConf.getId() + "#" + idpIdSessionKey;
            String idTokenSessionKey = (String)req.getSession().getAttribute("ksso.oidc.idtoken");
            if (StringUtils.isNotBlank((CharSequence)idTokenSessionKey)) {
                sessionCookieValue = sessionCookieValue + "#" + idTokenSessionKey;
            }
            if ((samlSessionIdentification = req.getSession().getAttribute("ksso.saml.session.identification")) != null) {
                sessionCookieValue = sessionCookieValue + "#" + samlSessionIdentification;
            }
            sessionCookieValue = Base64.getEncoder().encodeToString(sessionCookieValue.getBytes(StandardCharsets.UTF_8));
        }
        if (sessionCookieValue != null) {
            Cookie cookie = CookieSecurity.cookieWithDynamicSecurity(this.applicationProperties, "ksso_idp_session_data", sessionCookieValue);
            cookie.setPath(req.getContextPath() + "/");
            res.addCookie(cookie);
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    public void destroy() {
    }
}

