/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

public class SharedRedirectRulesServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;

    @Inject
    public SharedRedirectRulesServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "SAML");
        model.put("menuItem", "shared-redirect-rules");
        model.put("shouldUseLegacyLoginExperience", this.hostApp.shouldUseLegacyLoginExperience());
        model.put("instantlyRedirectBasedOnRememberedUsername", this.kerbConfManager.shouldHideUsernameField());
        model.put("redirectProgressDelay", this.idpConfManager.getRedirectProgressDelay());
        model.put("usernamePasswordLinkEnabled", this.idpConfManager.isUsernamePasswordLinkEnabled());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/shared-redirect-rules.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String usernamePasswordLinkEnabled;
        String instantlyRedirectBasedOnRememberedUsername = req.getParameter("instantlyRedirectBasedOnRememberedUsername");
        this.kerbConfManager.setShouldHideUsernameField(instantlyRedirectBasedOnRememberedUsername != null);
        String redirectProgressDelay = req.getParameter("redirectProgressDelay");
        if (redirectProgressDelay != null) {
            this.idpConfManager.setRedirectProgressDelay(redirectProgressDelay);
        }
        this.idpConfManager.setUsernamePasswordLinkEnabled((usernamePasswordLinkEnabled = req.getParameter("usernamePasswordLinkEnabled")) != null);
        SharedRedirectRulesServlet.sendSuccess(resp);
    }

    private static void sendSuccess(HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.getWriter().print("<html>Settings was saved</html>");
    }
}

