/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPreservableHeaderAwareResponse
extends HttpServletResponseWrapper {
    private final HashSet<Integer> ignoreSetStatusCodes = new HashSet<Integer>(Arrays.asList(200, 400, 401, 403, 404));
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public StatusPreservableHeaderAwareResponse(HttpServletResponse resp) {
        super(resp);
    }

    public void addHeader(String name, String value) {
        if ("WWW-Authenticate".equalsIgnoreCase(name)) {
            this.log.debug("resp.addHeader('{}', '{}') dropped: Negotiate already requested (Kerberos for REST).", (Object)name, (Object)value);
        } else {
            super.addHeader(name, value);
        }
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
    }

    public void setStatus(int sc, String sm) {
        String header = this.getHeader("WWW-Authenticate");
        if (this.ignoreSetStatusCodes.contains(sc)) {
            this.log.debug("Ignoring set status: {} {}", (Object)sc, (Object)sm);
        } else {
            this.log.trace("Status have changed: {} {}; WWW-Authenticate: {}", new Object[]{sc, sm, header});
            super.setStatus(sc, StringEscapeUtils.escapeHtml4((String)sm));
        }
    }

    public PrintWriter getWriter() throws IOException {
        return super.getWriter();
    }

    public void setStatus(int sc) {
        String header = this.getHeader("WWW-Authenticate");
        if (this.ignoreSetStatusCodes.contains(sc)) {
            this.log.debug("Ignoring set status: {}", (Object)sc);
        } else {
            this.log.trace("Status have changed: {}; WWW-Authenticate: {}", (Object)sc, (Object)header);
            super.setStatus(sc);
        }
    }

    public void sendError(int sc, String msg) throws IOException {
    }

    public void sendError(int sc) throws IOException {
    }
}

