/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.InitiateOidcLogin;
import org.kantega.atlaskerb.identityproviders.oidc.OidcDataCache;
import org.kantega.atlaskerb.identityproviders.oidc.OidcFactory;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.ResumeOidcLoginServlet;
import org.kantega.atlaskerb.saml.AtlSpServletSupport;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.kantega.atlaskerb.saml.util.ErrorPageRenderer;
import org.kantega.atlaskerb.utils.CookieUtil;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.TestUtils;
import org.kantega.samllib.SpLoginServlet;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class AtlSpLoginServlet
extends SpLoginServlet {
    private static final String PATH_POSTFIX = "/login";
    private static final String PATH_PREFIX = "/plugins/servlet/no.kantega.saml/sp/";
    private final AtlSpServletSupport atlSpServletSupport;
    private final ApplicationProperties applicationProperties;
    private final OidcDataCache oidcDataCache;
    private final IdpConfManager idpConfManager;
    private final OidcLibWrapper oidcLibWrapper;
    private final ErrorPageRenderer errorPageRenderer;
    private final InitiateOidcLogin initiateOidcLogin;
    private static final Logger log = LoggerFactory.getLogger(AtlSpLoginServlet.class);

    @Inject
    public AtlSpLoginServlet(AtlSpServletSupport atlSpServletSupport, ApplicationProperties applicationProperties, IdpConfManager idpConfManager, OidcDataCache oidcDataCache, OidcFactory oidcFactory, JsonWrapper jsonWrapper, ErrorPageRenderer errorPageRenderer, InitiateOidcLogin initiateOidcLogin) {
        this.atlSpServletSupport = atlSpServletSupport;
        this.applicationProperties = applicationProperties;
        this.idpConfManager = idpConfManager;
        this.oidcDataCache = oidcDataCache;
        this.oidcLibWrapper = oidcFactory.createOidcLibWrapper(jsonWrapper);
        this.errorPageRenderer = errorPageRenderer;
        this.initiateOidcLogin = initiateOidcLogin;
    }

    @UnrestrictedAccess
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean isTest = TestUtils.isTest(req);
        Optional maybeIdpConfig = AtlSpServletSupport.getSpId(req, PATH_PREFIX, PATH_POSTFIX).flatMap(id -> isTest ? this.atlSpServletSupport.getIdpConfigForTest((String)id) : this.atlSpServletSupport.getIdpConfig((String)id));
        if (!maybeIdpConfig.isPresent()) {
            this.atlSpServletSupport.renderNotFound(req, resp);
        } else {
            String loginHint = req.getParameter("username");
            CookieUtil.keepUsernameInSession(req, loginHint);
            IdpConfiguration idpConfig = (IdpConfiguration)maybeIdpConfig.get();
            if (idpConfig.isOidc()) {
                InitiateOidcLogin.OidcLoginResult result;
                OidcIdpConfiguration oidcConfig = (OidcIdpConfiguration)idpConfig;
                String callbackUrl = ResumeOidcLoginServlet.getCallbackUrl(this.applicationProperties);
                String redirectTargetUrl = req.getParameter("target");
                Iterator knownDomainsIterator = idpConfig.getKnownDomains().iterator();
                String domainHint = null;
                if (idpConfig.isHostedDomain() && knownDomainsIterator.hasNext()) {
                    domainHint = (String)knownDomainsIterator.next();
                }
                if ((result = this.initiateOidcLogin.run(oidcConfig, this.idpConfManager, callbackUrl, loginHint, domainHint, this.oidcDataCache, redirectTargetUrl, this.oidcLibWrapper, isTest)).isSuccess()) {
                    String idpRedirectUrl = result.getAuthorizationUrl();
                    log.debug("WebSudo isForceAuthn queryString: {}", (Object)req.getQueryString());
                    if (StringUtils.contains((CharSequence)req.getQueryString(), (CharSequence)"ForceAuthn=true")) {
                        req.getSession().setAttribute("ForceAuthInitiated", (Object)"true");
                        idpRedirectUrl = idpRedirectUrl + "&prompt=login&max_age=0";
                    }
                    resp.sendRedirect(idpRedirectUrl);
                } else {
                    this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, result.getError(), req.getRequestURI(), resp);
                }
            } else {
                SamlIdpConfiguration samlConfig = (SamlIdpConfiguration)idpConfig;
                req.setAttribute("usePostBinding", (Object)samlConfig.isUsePostBinding());
                super.doGet(req, resp);
            }
        }
    }

    @UnrestrictedAccess
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.getServiceProviderSpi(req) == null) {
            this.atlSpServletSupport.renderNotFound(req, resp);
        } else {
            super.doPost(req, resp);
        }
    }

    protected ServiceProviderSpi getServiceProviderSpi(HttpServletRequest req) {
        return AtlSpServletSupport.getSpId(req, PATH_PREFIX, PATH_POSTFIX).flatMap(this.atlSpServletSupport::getServiceProviderSpi).orElse(null);
    }
}

