/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.logout;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.sal.api.ApplicationProperties;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelper;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelperFactory;
import org.kantega.atlaskerb.saml.util.SessionIdentificationHelper;
import org.kantega.atlaskerb.security.CookieSecurity;
import org.kantega.samllib.validation.SAMLSessionIdentification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class SingleLogoutFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SingleLogoutFilter.class);
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final SingleLogoutAppHelper logoutAppHelper;
    private final ApplicationProperties applicationProperties;
    private String[] products;

    @Inject
    public SingleLogoutFilter(IdpConfManager idpConfManager, HostAppFactory hostAppFactory, SingleLogoutAppHelperFactory singleLogoutAppHelperFactory, ApplicationProperties applicationProperties) {
        this.idpConfManager = idpConfManager;
        this.hostApp = hostAppFactory.getInstance();
        this.logoutAppHelper = singleLogoutAppHelperFactory.getInstance();
        this.applicationProperties = applicationProperties;
    }

    public void init(FilterConfig filterConfig) {
        String productsParam = filterConfig.getInitParameter("products");
        if (productsParam != null) {
            this.products = productsParam.split(",");
            for (int i = 0; i < this.products.length; ++i) {
                this.products[i] = this.products[i].trim().toLowerCase();
            }
        }
    }

    private boolean isProductMatch() {
        for (String product : this.products) {
            if (!this.hostApp.isProductMatch(product)) continue;
            return true;
        }
        return false;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (!this.isProductMatch() || req.getParameter("nosaml") != null || req.getParameter("nosso") != null) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        String qs = req.getQueryString();
        if (StringUtils.contains((CharSequence)qs, (CharSequence)"slo=finished") || StringUtils.contains((CharSequence)req.getRequestURI(), (CharSequence)"/servicedesk/") && !StringUtils.contains((CharSequence)qs, (CharSequence)"logout=true") && !StringUtils.contains((CharSequence)req.getHeader("referer"), (CharSequence)"logout=true")) {
            chain.doFilter(request, response);
            return;
        }
        log.debug("Intercepting logout request: {}", (Object)req.getRequestURI());
        String idpConfigId = this.logoutAppHelper.getIdpSessionIdFromCookieAndSetInSession(req, res);
        if (!StringUtils.isBlank((CharSequence)idpConfigId)) {
            Cookie cookie = CookieSecurity.cookieWithDynamicSecurity(this.applicationProperties, "krb_logout_uri", req.getRequestURI());
            cookie.setPath(req.getContextPath() + "/");
            cookie.setComment("HttpOnly");
            res.addCookie(cookie);
        } else {
            try {
                Object samlSessionIdentification = req.getSession().getAttribute("ksso.saml.session.identification");
                log.debug("Single Logout: Getting session identification: {}", samlSessionIdentification);
                if (samlSessionIdentification != null) {
                    log.debug("Session identification object: {}", samlSessionIdentification);
                    SAMLSessionIdentification sessionIdentification = SessionIdentificationHelper.fromJson(samlSessionIdentification.toString());
                    idpConfigId = sessionIdentification.getIdpId();
                    log.debug("idpConfigId: {} , idpConfiguration name: {}", (Object)idpConfigId, (Object)this.idpConfManager.getIdentityProviderById(idpConfigId).getName());
                } else {
                    log.debug("Session identification object is null. This may be because this was not set correctly during SAML login, or this is a non-SAML logout.");
                }
            }
            catch (Exception e) {
                log.error("Problem finding idpConfigId", (Throwable)e);
            }
            Try maybeIdpConfigId = Try.of((CheckedFunction0 & Serializable)() -> req.getSession(false)).filterTry(Objects::nonNull).mapTry((CheckedFunction1 & Serializable)s -> s.getAttribute("ksso.idp.id.session.key")).filterTry(Objects::nonNull).mapTry(Object::toString).onFailure(_e -> log.debug("Unable to find IdP session.")).mapTry(this.idpConfManager::getIdentityProviderById).filterTry(IdpConfiguration::isSingleLogoutEnabled);
            if (maybeIdpConfigId.isEmpty()) {
                log.debug("No idpConfigId found in session. Skipping SLO.");
                chain.doFilter(request, response);
                return;
            }
            log.debug("Continuing with SLO.");
            idpConfigId = ((IdpConfiguration)maybeIdpConfigId.get()).getId();
        }
        if (this.idpConfManager.getIdentityProviderById(idpConfigId).isSingleLogoutEnabled()) {
            this.logoutAppHelper.initiateLogout(req, res, idpConfigId);
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    public void destroy() {
    }
}

