/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.websudo;

import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.sal.api.component.ComponentLocator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.websudo.WebSudoServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent
public class BambooWebSudoServlet
extends WebSudoServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Method setWebSudoSessionMethod;
    private Object webSudoManager;

    @Autowired
    @Inject
    public BambooWebSudoServlet() {
        try {
            ClassLoader ccl = ((Object)((Object)this)).getClass().getClassLoader().getParent();
            if (ccl != null) {
                this.WEB_SUDO_SERVLET_URL = "bambooWebsudo";
                Class<?> bambooWebSudoManagerClass = ccl.loadClass("com.atlassian.bamboo.sal.BambooWebSudoManager");
                this.webSudoManager = ComponentLocator.getComponent(bambooWebSudoManagerClass);
                this.setWebSudoSessionMethod = bambooWebSudoManagerClass.getMethod("setWebSudoSession", HttpServletRequest.class, HttpServletResponse.class);
            }
        }
        catch (Exception e) {
            this.log.warn("Could not load BambooWebSudoManager", (Throwable)e);
        }
    }

    @Override
    protected void startWebsudoSession(HttpServletRequest req, HttpServletResponse resp) {
        try {
            if (this.setWebSudoSessionMethod != null) {
                this.setWebSudoSessionMethod.invoke(this.webSudoManager, req, resp);
                this.log.debug("Websudo session initiated via SSO");
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.log.error("Could not initiate Websudo session", (Throwable)e);
        }
    }
}

